/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="font")
public class FontFilter
extends AbstractHTMLFilter {
    private Map<String, String> fontSizeMap = new HashMap<String, String>();

    public FontFilter() {
        this.fontSizeMap.put("1", "0.6em");
        this.fontSizeMap.put("2", "0.8em");
        this.fontSizeMap.put("3", "1.0em");
        this.fontSizeMap.put("4", "1.2em");
        this.fontSizeMap.put("5", "1.4em");
        this.fontSizeMap.put("6", "1.6em");
        this.fontSizeMap.put("7", "1.8em");
        this.fontSizeMap.put("-3", "0.4em");
        this.fontSizeMap.put("-2", this.fontSizeMap.get("1"));
        this.fontSizeMap.put("-1", this.fontSizeMap.get("2"));
        this.fontSizeMap.put("+1", this.fontSizeMap.get("4"));
        this.fontSizeMap.put("+2", this.fontSizeMap.get("5"));
        this.fontSizeMap.put("+3", this.fontSizeMap.get("6"));
    }

    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        List<Element> fontTags = this.filterDescendants(document.getDocumentElement(), new String[]{"font"});
        for (Element fontTag : fontTags) {
            Element span = document.createElement("span");
            this.moveChildren(fontTag, span);
            StringBuffer buffer = new StringBuffer();
            if (fontTag.hasAttribute("color")) {
                buffer.append(String.format("color:%s;", fontTag.getAttribute("color")));
            }
            if (fontTag.hasAttribute("face")) {
                buffer.append(String.format("font-family:%s;", fontTag.getAttribute("face")));
            }
            if (fontTag.hasAttribute("size")) {
                String fontSize = fontTag.getAttribute("size");
                String fontSizeCss = this.fontSizeMap.get(fontSize);
                fontSizeCss = fontSizeCss != null ? fontSizeCss : fontSize;
                buffer.append(String.format("font-size:%s;", fontSizeCss));
            }
            if (fontTag.hasAttribute("style")) {
                buffer.append(fontTag.getAttribute("style"));
            }
            if (!buffer.toString().trim().equals("")) {
                span.setAttribute("style", buffer.toString());
            }
            fontTag.getParentNode().insertBefore(span, fontTag);
            fontTag.getParentNode().removeChild(fontTag);
        }
    }
}

