/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.StandaloneAppRequestContext;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.application.UIStandaloneAppContainer;
import org.exoplatform.portal.webui.workspace.UIStandaloneApplicationLifecycle;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIStandaloneApplicationLifecycle.class, template="system:/groovy/portal/webui/workspace/UIPortalApplication.gtmpl")
public class UIStandaloneApplication
extends UIApplication {
    public static final int NORMAL_MODE = 0;
    private int modeState = 0;
    private Locale locale_ = Locale.ENGLISH;
    private String skin_ = "Default";
    private Orientation orientation_ = Orientation.LT;
    private boolean isSessionOpen = false;

    public UIStandaloneApplication() throws Exception {
        this.addChild(UIStandaloneAppContainer.class, null, null);
    }

    public void renderChildren() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        super.renderChildren(context);
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        UIStandaloneAppContainer staContaner;
        String storageId = ((StandaloneAppRequestContext)context).getStorageId();
        if (!storageId.equals((staContaner = (UIStandaloneAppContainer)this.getChild(UIStandaloneAppContainer.class)).getCurrStorageId())) {
            staContaner.setCurrStorageId(storageId);
        }
        super.processDecode(context);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        if (!context.useAjax()) {
            super.processRender(context);
        } else {
            PortalRequestContext pcontext = (PortalRequestContext)context;
            Set list = context.getUIComponentToUpdateByAjax();
            w.write("<div class=\"PortalResponse\">");
            w.write("<div class=\"PortalResponseData\">");
            if (list != null) {
                for (UIComponent uicomponent : list) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("AJAX call: Need to refresh the UI component " + uicomponent.getName()));
                    }
                    this.renderBlockToUpdate(uicomponent, context, w);
                }
            }
            w.write("</div>");
            w.write("<div class=\"PortalResponseScript\">");
            pcontext.getJavascriptManager().writeJavascript(w);
            w.write("eXo.core.Browser.onLoad();\n");
            pcontext.getJavascriptManager().writeCustomizedOnLoadScript(w);
            w.write("</div>");
            w.write("</div>");
        }
    }

    public Collection<String> getJavascriptURLs() {
        JavascriptConfigService service = (JavascriptConfigService)this.getApplicationComponent(JavascriptConfigService.class);
        return service.getAvailableScriptsPaths();
    }

    public Collection<Skin> getPortalSkins() {
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        ArrayList<Skin> skins = new ArrayList<Skin>(skinService.getPortalSkins(this.skin_));
        return skins;
    }

    public Set<Skin> getPortletSkins() {
        HashSet<Skin> skins = new HashSet<Skin>();
        return skins;
    }

    public boolean isSessionOpen() {
        return this.isSessionOpen;
    }

    public void setSessionOpen(boolean isSessionOpen) {
        this.isSessionOpen = isSessionOpen;
    }

    public String getSkin() {
        return this.skin_;
    }

    public Orientation getOrientation() {
        return this.orientation_;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation_ = orientation;
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public void setLocale(Locale locale) {
        this.locale_ = locale;
    }

    public void setModeState(int mode) {
        this.modeState = mode;
    }

    public int getModeState() {
        return this.modeState;
    }
}

