/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal;

import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DefaultConverterManager
extends AbstractLogEnabled
implements ConverterManager {
    @Requirement
    private ComponentManager componentManager;
    @Requirement(value="enum")
    private Converter enumConverter;
    @Requirement
    private Converter defaultConverter;

    @Override
    public <T> T convert(Class<T> targetClass, Object value) {
        Converter converter = this.lookupConverter(targetClass);
        if (converter != null) {
            return converter.convert(targetClass, value);
        }
        throw new ConversionException("Can't find converter to convert value [" + value + "] to type [" + targetClass + "] ");
    }

    private Converter lookupConverter(Class<?> targetType) {
        Converter converter = null;
        try {
            converter = (Converter)this.componentManager.lookup(Converter.class, targetType.getName());
        }
        catch (ComponentLookupException e) {
            this.getLogger().debug("Failed to find a proper Converter for type [" + targetType.getName() + "]", (Throwable)e);
        }
        if (converter == null) {
            if (Enum.class.isAssignableFrom(targetType)) {
                converter = this.enumConverter;
            } else {
                this.getLogger().debug("Trying default Converter for target type [" + targetType.getName() + "]");
                converter = this.defaultConverter;
            }
        }
        return converter;
    }
}

