/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DB2MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DB2SingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.GenericCQConnectionFactory;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class DB2ConnectionFactory
extends GenericCQConnectionFactory {
    private Boolean isReindexingSupport;

    public DB2ConnectionFactory(String dbDriver, String dbUrl, String dbUserName, String dbPassword, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws RepositoryException {
        super(dbDriver, dbUrl, dbUserName, dbPassword, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    public DB2ConnectionFactory(DataSource dbDataSource, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) {
        super(dbDataSource, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.multiDb) {
                return new DB2MultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerName, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            return new DB2SingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerName, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isIDNeededForPaging() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean isReindexingSupport() {
        if (this.isReindexingSupport == null) {
            block17: {
                con = null;
                try {
                    block16: {
                        con = this.getJdbcConnection();
                        metaData = con.getMetaData();
                        if (metaData.getDatabaseMajorVersion() > 9) {
                            this.isReindexingSupport = true;
                            break block16;
                        }
                        if (metaData.getDatabaseMajorVersion() == 9 && metaData.getDatabaseMinorVersion() > 7) {
                            this.isReindexingSupport = true;
                            break block16;
                        }
                        if (metaData.getDatabaseMajorVersion() == 9 && metaData.getDatabaseMinorVersion() == 7) {
                            maintenanceVersion = metaData.getDatabaseProductVersion().charAt(metaData.getDatabaseProductVersion().length() - 1);
                            this.isReindexingSupport = new Integer(maintenanceVersion) >= 2;
                            break block16;
                        }
                        this.isReindexingSupport = false;
                    }
                    var5_5 = null;
                    ** if (con == null) goto lbl-1000
                }
                catch (Throwable var4_11) {
                    var5_7 = null;
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    throw var4_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block17;
                    catch (Exception e) {
                        this.isReindexingSupport = false;
                        this.log.error((Object)"Error checking product version.", (Throwable)e);
                        var5_6 = null;
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException e) {}
                        }
                    }
                }
            }
            if (!this.isReindexingSupport.booleanValue()) {
                this.log.debug((Object)"The version of DB2 is prior to 9.7.2, so the old indexing mechanism will be used");
            }
        }
        return this.isReindexingSupport;
    }
}

