/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.federation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.PortletStatus;
import org.gatein.pc.api.StateEvent;
import org.gatein.pc.api.invocation.InvocationException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.federation.FederatedPortletInvoker;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.pc.federation.impl.FederatedPortlet;

public class FederatedPortletInvokerService
implements FederatedPortletInvoker {
    private String id;
    private PortletInvoker portletInvoker;
    private FederatingPortletInvoker federatingPortletInvoker;

    public FederatedPortletInvokerService(FederatingPortletInvoker federatingPortletInvoker, String id, PortletInvoker portletInvoker) {
        this.id = id;
        this.portletInvoker = portletInvoker;
        this.federatingPortletInvoker = federatingPortletInvoker;
    }

    @Override
    public PortletInvoker getPortletInvoker() {
        return this.portletInvoker;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public FederatingPortletInvoker getFederatingPortletInvoker() {
        return this.federatingPortletInvoker;
    }

    public Set<Portlet> getPortlets() throws PortletInvokerException {
        LinkedHashSet<Portlet> federatedPortlets = new LinkedHashSet<Portlet>();
        for (Portlet portlet : this.portletInvoker.getPortlets()) {
            FederatedPortlet federatedPortlet = new FederatedPortlet(this, this.reference(portlet.getContext()), portlet);
            federatedPortlets.add(federatedPortlet);
        }
        return federatedPortlets;
    }

    public Portlet getPortlet(PortletContext compoundPortletContext) throws IllegalArgumentException, PortletInvokerException {
        PortletContext portletContext = this.dereference(compoundPortletContext);
        Portlet portlet = this.portletInvoker.getPortlet(portletContext);
        return new FederatedPortlet(this, compoundPortletContext, portlet);
    }

    public PortletStatus getStatus(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        PortletContext context = this.dereference(portletContext);
        return this.portletInvoker.getStatus(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws InvocationException, PortletInvokerException {
        PortletContext compoundPortletContext = invocation.getTarget();
        PortletContext portletContext = this.dereference(compoundPortletContext);
        InstanceContext instanceContext = invocation.getInstanceContext();
        try {
            invocation.setTarget(portletContext);
            invocation.setInstanceContext((InstanceContext)new FederatedInstanceContext(instanceContext));
            PortletInvocationResponse portletInvocationResponse = this.portletInvoker.invoke(invocation);
            return portletInvocationResponse;
        }
        finally {
            invocation.setTarget(compoundPortletContext);
            invocation.setInstanceContext(instanceContext);
        }
    }

    public PortletContext createClone(PortletStateType stateType, PortletContext compoundPortletContext) throws PortletInvokerException {
        PortletContext portletContext = this.dereference(compoundPortletContext);
        PortletContext cloneContext = this.portletInvoker.createClone(stateType, portletContext);
        return this.reference(cloneContext);
    }

    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (portletContexts == null) {
            throw new IllegalArgumentException("Null portlet id list not accepted");
        }
        if (portletContexts.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<PortletContext> dereferencedList = new ArrayList<PortletContext>(portletContexts);
        for (int i = 0; i < dereferencedList.size(); ++i) {
            PortletContext compoundPortletContext = (PortletContext)dereferencedList.get(i);
            PortletContext portletContext = this.dereference(compoundPortletContext);
            dereferencedList.set(i, portletContext);
        }
        List failures = this.portletInvoker.destroyClones(dereferencedList);
        for (int i = 0; i < failures.size(); ++i) {
            DestroyCloneFailure failure = (DestroyCloneFailure)failures.get(i);
            String cloneId = failure.getPortletId();
            failure = new DestroyCloneFailure(PortletContext.reference((String)this.id, (PortletContext)PortletContext.createPortletContext((String)cloneId)).getId());
            failures.set(i, failure);
        }
        return failures;
    }

    public PropertyMap getProperties(PortletContext compoundPortletContext) throws PortletInvokerException {
        PortletContext portletId = this.dereference(compoundPortletContext);
        return this.portletInvoker.getProperties(portletId);
    }

    public PropertyMap getProperties(PortletContext compoundPortletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        PortletContext portletId = this.dereference(compoundPortletContext);
        return this.portletInvoker.getProperties(portletId, keys);
    }

    public PortletContext setProperties(PortletContext compoundPortletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        PortletContext portletContext = this.dereference(compoundPortletContext);
        portletContext = this.portletInvoker.setProperties(portletContext, changes);
        return this.reference(portletContext);
    }

    public PortletContext exportPortlet(PortletStateType stateType, PortletContext compoundPortletContext) throws PortletInvokerException {
        PortletContext portletContext = this.dereference(compoundPortletContext);
        portletContext = this.portletInvoker.exportPortlet(stateType, portletContext);
        return this.reference(portletContext);
    }

    public PortletContext importPortlet(PortletStateType stateType, PortletContext compoundPortletContext) throws PortletInvokerException {
        PortletContext portletContext = this.dereference(compoundPortletContext);
        portletContext = this.portletInvoker.exportPortlet(stateType, portletContext);
        return this.reference(portletContext);
    }

    private PortletContext dereference(PortletContext compoundPortletContext) {
        return PortletContext.dereference((PortletContext)compoundPortletContext);
    }

    private PortletContext reference(PortletContext portletContext) {
        return PortletContext.reference((String)this.id, (PortletContext)portletContext);
    }

    private class FederatedInstanceContext
    implements InstanceContext {
        private InstanceContext ctx;

        public FederatedInstanceContext(InstanceContext ctx) {
            this.ctx = ctx;
        }

        public String getId() {
            return this.ctx.getId();
        }

        public AccessMode getAccessMode() {
            return this.ctx.getAccessMode();
        }

        public void onStateEvent(StateEvent event) {
            this.ctx.onStateEvent(new StateEvent(FederatedPortletInvokerService.this.reference(event.getPortletContext()), event.getType()));
        }

        public PortletStateType<?> getStateType() {
            return this.ctx.getStateType();
        }
    }
}

