/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Property {
    private final String name;
    private final boolean internal;
    private final ValueType valueType;
    private final Set<String> choices;

    private Property(String name, boolean internal, ValueType valueType, String[] choices) {
        this.name = name;
        this.internal = internal;
        this.valueType = valueType;
        this.choices = choices != null ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(choices))) : null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isExternal() {
        return !this.internal;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Set<String> getChoices() {
        return this.choices;
    }

    private Property(String name, boolean internal, ValueType valueType) {
        this(name, internal, valueType, null);
    }

    public static Property internalBoolean(String name) {
        return new Property(name, true, ValueType.BOOLEAN);
    }

    public static Property internalClosedChoise(String name, String ... choices) {
        return new Property(name, true, ValueType.CLOSED_CHOICE, choices);
    }

    public static Property internalDate(String name) {
        return new Property(name, true, ValueType.DATE);
    }

    public static Property internalInteger(String name) {
        return new Property(name, true, ValueType.INTEGER);
    }

    public static Property internalRational(String name) {
        return new Property(name, true, ValueType.RATIONAL);
    }

    public static Property internalOpenChoise(String name, String ... choices) {
        return new Property(name, true, ValueType.OPEN_CHOICE, choices);
    }

    public static Property internalReal(String name) {
        return new Property(name, true, ValueType.REAL);
    }

    public static Property internalText(String name) {
        return new Property(name, true, ValueType.TEXT);
    }

    public static Property internalURI(String name) {
        return new Property(name, true, ValueType.URI);
    }

    public static Property externalClosedChoise(String name, String ... choices) {
        return new Property(name, false, ValueType.CLOSED_CHOICE, choices);
    }

    public static Property externalDate(String name) {
        return new Property(name, false, ValueType.DATE);
    }

    public static Property externalInteger(String name) {
        return new Property(name, false, ValueType.INTEGER);
    }

    public static Property externalText(String name) {
        return new Property(name, false, ValueType.TEXT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueType {
        BOOLEAN,
        OPEN_CHOICE,
        CLOSED_CHOICE,
        DATE,
        INTEGER,
        LOCALE,
        MIME_TYPE,
        PROPER_NAME,
        RATIONAL,
        REAL,
        TEXT,
        URI,
        URL,
        XPATH;

    }
}

