/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStringEntityReferenceResolver
implements EntityReferenceResolver<String> {
    private Map<EntityType, List<Character>> separators = new HashMap<EntityType, List<Character>>(){
        {
            this.put(EntityType.DOCUMENT, Arrays.asList(Character.valueOf('.'), Character.valueOf(':')));
            this.put(EntityType.ATTACHMENT, Arrays.asList(Character.valueOf('@'), Character.valueOf('.'), Character.valueOf(':')));
            this.put(EntityType.SPACE, Arrays.asList(Character.valueOf(':')));
            this.put(EntityType.OBJECT, Arrays.asList(Character.valueOf('^'), Character.valueOf('.'), Character.valueOf(':')));
            this.put(EntityType.OBJECT_PROPERTY, Arrays.asList(Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('.'), Character.valueOf(':')));
        }
    };
    private Map<EntityType, List<EntityType>> entityTypes = new HashMap<EntityType, List<EntityType>>(){
        {
            this.put(EntityType.DOCUMENT, Arrays.asList(EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI));
            this.put(EntityType.ATTACHMENT, Arrays.asList(EntityType.ATTACHMENT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI));
            this.put(EntityType.SPACE, Arrays.asList(EntityType.SPACE, EntityType.WIKI));
            this.put(EntityType.OBJECT, Arrays.asList(EntityType.OBJECT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI));
            this.put(EntityType.OBJECT_PROPERTY, Arrays.asList(EntityType.OBJECT_PROPERTY, EntityType.OBJECT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI));
        }
    };

    protected abstract String getDefaultValue(EntityType var1, Object ... var2);

    @Override
    public EntityReference resolve(String entityReferenceRepresentation, EntityType type, Object ... parameters) {
        if (!this.separators.containsKey((Object)type)) {
            throw new RuntimeException("No parsing definition found for Entity Type [" + (Object)((Object)type) + "]");
        }
        StringBuilder representation = entityReferenceRepresentation == null ? new StringBuilder() : new StringBuilder(entityReferenceRepresentation);
        EntityReference reference = null;
        EntityReference lastReference = null;
        List<Character> separatorsForType = this.separators.get((Object)type);
        List<EntityType> entityTypesForType = this.entityTypes.get((Object)type);
        for (int i = 0; i < separatorsForType.size(); ++i) {
            String name;
            if (representation.length() > 0) {
                char separator = separatorsForType.get(i).charValue();
                name = this.lastIndexOf(representation, separator, entityTypesForType.get(i), parameters);
            } else {
                name = this.resolveDefaultValue(entityTypesForType.get(i), parameters);
            }
            if (name == null) continue;
            EntityReference newReference = new EntityReference(name, entityTypesForType.get(i));
            if (lastReference != null) {
                lastReference.setParent(newReference);
            }
            lastReference = newReference;
            if (reference != null) continue;
            reference = lastReference;
        }
        String name = representation.length() > 0 ? representation.toString() : this.resolveDefaultValue(entityTypesForType.get(separatorsForType.size()), parameters);
        if (name != null) {
            EntityReference newReference = new EntityReference(name, entityTypesForType.get(separatorsForType.size()));
            if (lastReference != null) {
                lastReference.setParent(newReference);
            }
            if (reference == null) {
                reference = newReference;
            }
        }
        return reference;
    }

    private String lastIndexOf(StringBuilder representation, char separator, EntityType entityType, Object ... parameters) {
        String name = null;
        boolean found = false;
        for (int j = representation.length() - 1; j > -1; --j) {
            char currentChar = representation.charAt(j);
            int nextChar = 0;
            if (j > 0) {
                nextChar = representation.charAt(j - 1);
            }
            if (nextChar != 92 && currentChar == separator) {
                name = j == representation.length() - 1 ? this.resolveDefaultValue(entityType, parameters) : representation.substring(j + 1, representation.length());
                representation.delete(j, representation.length());
                found = true;
                break;
            }
            if (nextChar != 92) continue;
            representation.delete(j - 1, j);
            --j;
        }
        if (!found) {
            name = representation.toString();
            representation.setLength(0);
        }
        return name;
    }

    private String resolveDefaultValue(EntityType type, Object ... parameters) {
        EntityReference referenceParameter;
        EntityReference extractedReference;
        String resolvedDefaultValue = null;
        if (parameters.length > 0 && parameters[0] instanceof EntityReference && (extractedReference = (referenceParameter = (EntityReference)parameters[0]).extractReference(type)) != null) {
            resolvedDefaultValue = extractedReference.getName();
        }
        if (resolvedDefaultValue == null) {
            resolvedDefaultValue = this.getDefaultValue(type, parameters);
        }
        return resolvedDefaultValue;
    }
}

