/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.scripting;

import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.script.service.ScriptService;

@Component(value="model")
public class ModelScriptService
implements ScriptService {
    private static final String DEFAULT_STRING_RESOLVER_HINT = "currentmixed";
    @Requirement
    private ComponentManager componentManager;

    public DocumentReference createDocumentReference(String wiki, String space, String page) {
        return this.createDocumentReference(wiki, space, page, "currentmixed/reference");
    }

    public DocumentReference createDocumentReference(String wiki, String space, String page, String hint) {
        DocumentReference documentReference;
        EntityReference reference = null;
        if (!StringUtils.isEmpty((String)wiki)) {
            reference = new EntityReference(wiki, EntityType.WIKI);
        }
        if (!StringUtils.isEmpty((String)space)) {
            reference = new EntityReference(space, EntityType.SPACE, reference);
        }
        if (!StringUtils.isEmpty((String)page)) {
            reference = new EntityReference(page, EntityType.DOCUMENT, reference);
        }
        try {
            documentReference = ((DocumentReferenceResolver)this.componentManager.lookup(DocumentReferenceResolver.class, hint)).resolve(reference, new Object[0]);
        }
        catch (ComponentLookupException e) {
            documentReference = null;
        }
        return documentReference;
    }

    public AttachmentReference createAttachmentReference(DocumentReference documentReference, String fileName) {
        return new AttachmentReference(fileName, documentReference);
    }

    public DocumentReference resolveDocument(String stringRepresentation) {
        return this.resolveDocument(stringRepresentation, DEFAULT_STRING_RESOLVER_HINT, new Object[0]);
    }

    public DocumentReference resolveDocument(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.lookup(EntityReferenceResolver.class, hint);
            return new DocumentReference(resolver.resolve(stringRepresentation, EntityType.DOCUMENT, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public AttachmentReference resolveAttachment(String stringRepresentation) {
        return this.resolveAttachment(stringRepresentation, DEFAULT_STRING_RESOLVER_HINT, new Object[0]);
    }

    public AttachmentReference resolveAttachment(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.lookup(EntityReferenceResolver.class, hint);
            return new AttachmentReference(resolver.resolve(stringRepresentation, EntityType.ATTACHMENT, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public String serialize(EntityReference reference) {
        return this.serialize(reference, "compact");
    }

    public String serialize(EntityReference reference, String hint) {
        String result;
        try {
            result = (String)((EntityReferenceSerializer)this.componentManager.lookup(EntityReferenceSerializer.class, hint)).serialize(reference, new Object[0]);
        }
        catch (ComponentLookupException e) {
            result = null;
        }
        return result;
    }
}

