/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.TagToken;

public class TagInfo {
    protected static final int HEAD_AND_BODY = 0;
    protected static final int HEAD = 1;
    protected static final int BODY = 2;
    protected static final int CONTENT_ALL = 0;
    protected static final int CONTENT_NONE = 1;
    protected static final int CONTENT_TEXT = 2;
    private String name;
    private int contentType;
    private Set mustCloseTags = new HashSet();
    private Set higherTags = new HashSet();
    private Set childTags = new HashSet();
    private Set permittedTags = new HashSet();
    private Set copyTags = new HashSet();
    private Set continueAfterTags = new HashSet();
    private int belongsTo = 2;
    private String requiredParent = null;
    private String fatalTag = null;
    private boolean deprecated = false;
    private boolean unique = false;
    private boolean ignorePermitted = false;

    public TagInfo(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.name = string;
        this.contentType = n;
        this.belongsTo = n2;
        this.deprecated = bl;
        this.unique = bl2;
        this.ignorePermitted = bl3;
    }

    public void defineFatalTags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            this.fatalTag = string2 = stringTokenizer.nextToken();
            this.higherTags.add(string2);
        }
    }

    public void defineRequiredEnclosingTags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            this.requiredParent = string2 = stringTokenizer.nextToken();
            this.higherTags.add(string2);
        }
    }

    public void defineForbiddenTags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.permittedTags.add(string2);
        }
    }

    public void defineAllowedChildrenTags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.childTags.add(string2);
        }
    }

    public void defineHigherLevelTags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.higherTags.add(string2);
        }
    }

    public void defineCloseBeforeCopyInsideTags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.copyTags.add(string2);
            this.mustCloseTags.add(string2);
        }
    }

    public void defineCloseInsideCopyAfterTags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.continueAfterTags.add(string2);
        }
    }

    public void defineCloseBeforeTags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.mustCloseTags.add(string2);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getContentType() {
        return this.contentType;
    }

    public Set getMustCloseTags() {
        return this.mustCloseTags;
    }

    public void setMustCloseTags(Set set) {
        this.mustCloseTags = set;
    }

    public Set getHigherTags() {
        return this.higherTags;
    }

    public void setHigherTags(Set set) {
        this.higherTags = set;
    }

    public Set getChildTags() {
        return this.childTags;
    }

    public void setChildTags(Set set) {
        this.childTags = set;
    }

    public Set getPermittedTags() {
        return this.permittedTags;
    }

    public void setPermittedTags(Set set) {
        this.permittedTags = set;
    }

    public Set getCopyTags() {
        return this.copyTags;
    }

    public void setCopyTags(Set set) {
        this.copyTags = set;
    }

    public Set getContinueAfterTags() {
        return this.continueAfterTags;
    }

    public void setContinueAfterTags(Set set) {
        this.continueAfterTags = set;
    }

    public String getRequiredParent() {
        return this.requiredParent;
    }

    public void setRequiredParent(String string) {
        this.requiredParent = string;
    }

    public int getBelongsTo() {
        return this.belongsTo;
    }

    public void setBelongsTo(int n) {
        this.belongsTo = n;
    }

    public String getFatalTag() {
        return this.fatalTag;
    }

    public void setFatalTag(String string) {
        this.fatalTag = string;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean bl) {
        this.deprecated = bl;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    public boolean isIgnorePermitted() {
        return this.ignorePermitted;
    }

    public boolean isEmptyTag() {
        return 1 == this.contentType;
    }

    public void setIgnorePermitted(boolean bl) {
        this.ignorePermitted = bl;
    }

    boolean allowsBody() {
        return 1 != this.contentType;
    }

    boolean isHigher(String string) {
        return this.higherTags.contains(string);
    }

    boolean isCopy(String string) {
        return this.copyTags.contains(string);
    }

    boolean hasCopyTags() {
        return !this.copyTags.isEmpty();
    }

    boolean isContinueAfter(String string) {
        return this.continueAfterTags.contains(string);
    }

    boolean hasPermittedTags() {
        return !this.permittedTags.isEmpty();
    }

    boolean isHeadTag() {
        return this.belongsTo == 1;
    }

    boolean isHeadAndBodyTag() {
        return this.belongsTo == 1 || this.belongsTo == 0;
    }

    boolean isMustCloseTag(TagInfo tagInfo) {
        if (tagInfo != null) {
            return this.mustCloseTags.contains(tagInfo.getName()) || tagInfo.contentType == 2;
        }
        return false;
    }

    boolean allowsItem(BaseToken baseToken) {
        TagToken tagToken;
        String string;
        if (this.contentType != 1 && baseToken instanceof TagToken && "script".equals(string = (tagToken = (TagToken)baseToken).getName())) {
            return true;
        }
        if (0 == this.contentType) {
            if (!this.childTags.isEmpty()) {
                return baseToken instanceof TagToken ? this.childTags.contains(((TagToken)baseToken).getName()) : false;
            }
            if (!this.permittedTags.isEmpty()) {
                return baseToken instanceof TagToken ? !this.permittedTags.contains(((TagToken)baseToken).getName()) : true;
            }
            return true;
        }
        if (2 == this.contentType) {
            return !(baseToken instanceof TagToken);
        }
        return false;
    }

    boolean allowsAnything() {
        return 0 == this.contentType && this.childTags.size() == 0;
    }
}

