/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.service.ServiceTestCase;
import java.util.Arrays;
import org.json.simple.JSONObject;

public class CajolingServiceTest
extends ServiceTestCase {
    public final void testUnsupportedInputContentType() throws Exception {
        this.registerUri("http://foo/bar.vb", "zoicks()", "text/vbscript");
        CajolingServiceTest.assertEquals((Object)"ERROR", (Object)this.requestGet("?url=http://foo/bar.vb&mime-type=text/javascript"));
    }

    public final void testNonMatchingInputContentType() throws Exception {
        this.registerUri("http://foo/bar.gif", "foo()", "text/javascript");
        CajolingServiceTest.assertEquals((Object)"ERROR", (Object)this.requestGet("?url=http://foo/bar.gif&mime-type=image/*"));
    }

    public final void testSupportedContentTypes() throws Exception {
        this.registerUri("http://foo/bar.js", "foo()", "text/javascript");
        this.registerUri("http://foo/bar.html", "<b>Hello</b>", "text/html");
        CajolingServiceTest.assertFalse((boolean)"ERROR".equals(this.requestGet("?url=http://foo/bar.js&mime-type=text/javascript")));
        CajolingServiceTest.assertFalse((boolean)"ERROR".equals(this.requestGet("?url=http://foo/bar.html&mime-type=text/html")));
        CajolingServiceTest.assertFalse((boolean)"ERROR".equals(this.requestGet("?url=http://foo/bar.html&input-mime-type=text/html&output-mime-type=text/javascript")));
        CajolingServiceTest.assertEquals((Object)"ERROR", (Object)this.requestGet("?url=http://foo/bar.js&input-mime-type=text/javascript&output-mime-type=text/html"));
    }

    public final void testErrorMessagesEscaped() throws Exception {
        this.registerUri("http://foo/bar.js", "with(){};", "text/javascript");
        CajolingServiceTest.assertEquals((String)"", (String)((String)this.requestGet("?url=http://foo/bar.js&mime-type=text/javascript")));
    }

    public final void testPost() throws Exception {
        byte[] byteData = new byte[]{71, 73, 70, 57, 56, 97};
        CajolingServiceTest.assertTrue((boolean)Arrays.equals((byte[])this.requestPost("?url=http://foo/bar.gif&mime-type=image/*", byteData, "image/gif", null), byteData));
    }

    public final void testUnexpectedMimeType() throws Exception {
        this.registerUri("http://foo/bar.gif", "foo()", "text/javascript");
        CajolingServiceTest.assertEquals((Object)"ERROR", (Object)this.requestGet("?url=http://foo/bar.gif&mime-type=image/*"));
    }

    public final void testEmptyContent() throws Exception {
        this.registerUri("http://foo/bar.html", "", "text/html");
        byte[] byteData = new byte[]{};
        JSONObject result = (JSONObject)this.json((String)this.requestPost("?url=http://foo/bar.html&input-mime-type=text/html&output-mime-type=application/json", byteData, "text/html", null));
        CajolingServiceTest.assertTrue((String)"Output missing 'html' key", (boolean)result.containsKey((Object)"html"));
        CajolingServiceTest.assertTrue((String)"Output missing 'javascript' key", (boolean)result.containsKey((Object)"js"));
        CajolingServiceTest.assertEquals((String)"", (String)((String)result.get((Object)"html")));
    }
}

