/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQNodeTypes;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLanguages
implements FAQNodeTypes {
    private static Log log = ExoLogger.getLogger(MultiLanguages.class);

    private static Node getLanguageNodeByLanguage(Node questionNode, String language) throws Exception {
        if (language.equals(questionNode.getProperty("exo:language").getString())) {
            return questionNode;
        }
        NodeIterator nodeIterator = questionNode.getNode(Utils.LANGUAGE_HOME).getNodes();
        Node languageNode = null;
        while (nodeIterator.hasNext()) {
            languageNode = nodeIterator.nextNode();
            if (!languageNode.getProperty("exo:language").getString().equals(language)) continue;
            return languageNode;
        }
        return null;
    }

    public static void addLanguage(Node questionNode, QuestionLanguage language) throws Exception {
        if (!questionNode.isNodeType("mix:faqi18n")) {
            questionNode.addMixin("mix:faqi18n");
        }
        Node languageHome = null;
        try {
            languageHome = questionNode.getNode(Utils.LANGUAGE_HOME);
        }
        catch (Exception e) {
            languageHome = questionNode.addNode(Utils.LANGUAGE_HOME, "exo:questionLanguageHome");
        }
        Node langNode = null;
        try {
            langNode = languageHome.getNode(language.getId());
        }
        catch (Exception e) {
            langNode = languageHome.addNode(language.getId(), "exo:faqLanguage");
        }
        langNode.setProperty("exo:language", language.getLanguage());
        langNode.setProperty("exo:name", language.getDetail());
        langNode.setProperty("exo:title", language.getQuestion());
        langNode.setProperty("exo:questionId", questionNode.getName());
        langNode.setProperty("exo:categoryId", questionNode.getProperty("exo:categoryId").getString());
        if (langNode.isNew()) {
            questionNode.getSession().save();
        } else {
            questionNode.save();
        }
    }

    public static void deleteAnswerQuestionLang(Node questionNode, String answerId, String language) throws Exception {
        Node answerNode;
        if (language != null && language.length() > 0) {
            Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
            answerNode = languageNode.getNode(Utils.ANSWER_HOME).getNode(answerId);
        } else {
            answerNode = questionNode.getNode(Utils.ANSWER_HOME).getNode(answerId);
        }
        answerNode.remove();
        questionNode.save();
    }

    public static void deleteCommentQuestionLang(Node questionNode, String commentId, String language) throws Exception {
        Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
        Node commnetNode = languageNode.getNode(Utils.COMMENT_HOME).getNode(commentId);
        commnetNode.remove();
        questionNode.save();
    }

    public static QuestionLanguage getQuestionLanguageByLanguage(Node questionNode, String language) throws Exception {
        Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
        return MultiLanguages.getQuestionLanguage(languageNode);
    }

    private static QuestionLanguage getQuestionLanguage(Node questionNode) throws Exception {
        QuestionLanguage questionLanguage = new QuestionLanguage();
        PropertyReader reader = new PropertyReader(questionNode);
        questionLanguage.setState(QuestionLanguage.VIEW);
        questionLanguage.setId(questionNode.getName());
        questionLanguage.setLanguage(reader.string("exo:language", ""));
        questionLanguage.setQuestion(reader.string("exo:title", ""));
        questionLanguage.setDetail(reader.string("exo:name", ""));
        Comment[] comments = MultiLanguages.getComment(questionNode);
        Answer[] answers = MultiLanguages.getAnswers(questionNode);
        questionLanguage.setComments(comments);
        questionLanguage.setAnswers(answers);
        return questionLanguage;
    }

    private static Comment[] getComment(Node questionNode) throws Exception {
        try {
            if (!questionNode.hasNode(Utils.COMMENT_HOME)) {
                return new Comment[0];
            }
            NodeIterator nodeIterator = questionNode.getNode(Utils.COMMENT_HOME).getNodes();
            Comment[] comments = new Comment[(int)nodeIterator.getSize()];
            Node commentNode = null;
            int i = 0;
            while (nodeIterator.hasNext()) {
                commentNode = nodeIterator.nextNode();
                comments[i] = MultiLanguages.getCommentByNode(commentNode);
                ++i;
            }
            return comments;
        }
        catch (Exception e) {
            return new Comment[0];
        }
    }

    private static Comment getCommentByNode(Node commentNode) throws Exception {
        Comment comment = new Comment();
        comment.setId(commentNode.getName());
        PropertyReader reader = new PropertyReader(commentNode);
        comment.setComments(reader.string("exo:comments", ""));
        comment.setCommentBy(reader.string("exo:commentBy", ""));
        comment.setDateComment(commentNode.getProperty("exo:dateComment").getDate().getTime());
        comment.setFullName(reader.string("exo:fullName", ""));
        comment.setPostId(reader.string("exo:postId", ""));
        return comment;
    }

    private static Answer[] getAnswers(Node questionNode) throws Exception {
        try {
            if (!questionNode.hasNode(Utils.ANSWER_HOME)) {
                return new Answer[0];
            }
            NodeIterator nodeIterator = questionNode.getNode(Utils.ANSWER_HOME).getNodes();
            ArrayList<Answer> answers = new ArrayList<Answer>();
            String language = questionNode.getProperty("exo:language").getString();
            while (nodeIterator.hasNext()) {
                try {
                    Answer ans = MultiLanguages.getAnswerByNode(nodeIterator.nextNode());
                    ans.setLanguage(language);
                    answers.add(ans);
                }
                catch (Exception e) {}
            }
            return answers.toArray(new Answer[0]);
        }
        catch (Exception e) {
            log.error((Object)"Fail to get answers: ", (Throwable)e);
            return new Answer[0];
        }
    }

    private static Answer getAnswerByNode(Node answerNode) throws Exception {
        PropertyReader reader = new PropertyReader(answerNode);
        Answer answer = new Answer();
        answer.setId(answerNode.getName());
        answer.setResponses(reader.string("exo:responses", ""));
        answer.setResponseBy(reader.string("exo:responseBy", ""));
        answer.setFullName(reader.string("exo:fullName", ""));
        answer.setDateResponse(answerNode.getProperty("exo:dateResponse").getDate().getTime());
        answer.setUsersVoteAnswer(reader.strings("exo:usersVoteAnswer", new String[0]));
        answer.setMarkVotes(reader.l("exo:MarkVotes"));
        answer.setApprovedAnswers(reader.bool("exo:approveResponses", true));
        answer.setActivateAnswers(reader.bool("exo:activateResponses", true));
        answer.setPostId(reader.string("exo:postId", ""));
        String path = answerNode.getPath();
        answer.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        return answer;
    }

    public static Comment getCommentById(Node questionNode, String commentId, String language) throws Exception {
        try {
            Node commentNode;
            if (language != null && language.length() > 0) {
                Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
                commentNode = languageNode.getNode(Utils.COMMENT_HOME).getNode(commentId);
            } else {
                commentNode = questionNode.getNode(Utils.COMMENT_HOME).getNode(commentId);
            }
            Comment comment = new Comment();
            PropertyReader reader = new PropertyReader(commentNode);
            comment.setId(reader.string("exo:id", ""));
            comment.setComments(reader.string("exo:comments", ""));
            comment.setCommentBy(reader.string("exo:commentBy", ""));
            comment.setFullName(reader.string("exo:fullName", ""));
            comment.setDateComment(reader.date("exo:dateComment"));
            comment.setPostId(reader.string("exo:postId", ""));
            return comment;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Answer getAnswerById(Node questionNode, String answerid, String language) throws Exception {
        Answer answer = new Answer();
        try {
            Node answerNode;
            if (language != null && language.length() > 0) {
                Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
                answerNode = languageNode.getNode(Utils.ANSWER_HOME).getNode(answerid);
            } else {
                answerNode = questionNode.getNode(Utils.ANSWER_HOME).getNode(answerid);
            }
            PropertyReader reader = new PropertyReader(answerNode);
            answer.setId(reader.string("exo:id", ""));
            String path = answerNode.getPath();
            answer.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
            answer.setResponses(reader.string("exo:responses", ""));
            answer.setResponseBy(reader.string("exo:responseBy", ""));
            answer.setFullName(reader.string("exo:fullName", ""));
            answer.setDateResponse(reader.date("exo:dateResponse"));
            answer.setUsersVoteAnswer(reader.strings("exo:usersVoteAnswer", new String[0]));
            answer.setMarkVotes(reader.l("exo:MarkVotes"));
            answer.setApprovedAnswers(reader.bool("exo:approveResponses", true));
            answer.setActivateAnswers(reader.bool("exo:activateResponses", true));
            answer.setPostId(reader.string("exo:postId", ""));
            answer.setLanguage(reader.string("exo:responseLanguage", ""));
            return answer;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void saveAnswer(Node questionNode, Answer answer, String language) throws Exception {
        Node answerNode;
        Node answerHome;
        String defaultLang = questionNode.getProperty("exo:language").getString();
        if (language != null && language.length() > 0 && !language.equals(defaultLang)) {
            Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
            if (!languageNode.isNodeType("mix:faqi18n")) {
                languageNode.addMixin("mix:faqi18n");
            }
            try {
                answerHome = languageNode.getNode(Utils.ANSWER_HOME);
            }
            catch (Exception e) {
                answerHome = languageNode.addNode(Utils.ANSWER_HOME, "exo:answerHome");
            }
            answer.setLanguage(language);
        } else {
            try {
                answerHome = questionNode.getNode(Utils.ANSWER_HOME);
            }
            catch (Exception e) {
                answerHome = questionNode.addNode(Utils.ANSWER_HOME, "exo:answerHome");
            }
            answer.setLanguage(questionNode.getProperty("exo:language").getString());
        }
        try {
            answerNode = answerHome.getNode(answer.getId());
        }
        catch (Exception e) {
            answerNode = answerHome.addNode(answer.getId(), "exo:answer");
        }
        answerNode.setProperty("exo:responses", answer.getResponses());
        answerNode.setProperty("exo:responseBy", answer.getResponseBy());
        answerNode.setProperty("exo:fullName", answer.getFullName());
        answerNode.setProperty("exo:usersVoteAnswer", answer.getUsersVoteAnswer());
        answerNode.setProperty("exo:MarkVotes", answer.getMarkVotes());
        Date answerDate = null;
        if (answer.isNew()) {
            Calendar calendar = null;
            calendar = GregorianCalendar.getInstance();
            answerDate = new Date();
            calendar.setTime(answerDate);
            answerNode.setProperty("exo:dateResponse", calendar);
            answerNode.setProperty("exo:id", answer.getId());
            answerNode.setProperty("exo:questionId", questionNode.getName());
            answerNode.setProperty("exo:responseLanguage", language);
            answerNode.setProperty("exo:categoryId", questionNode.getProperty("exo:categoryId").getString());
            answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers());
            answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers());
        } else {
            if (answerNode.hasProperty("exo:dateResponse")) {
                answerDate = answerNode.getProperty("exo:dateResponse").getDate().getTime();
            }
            if (new PropertyReader(answerNode).bool("exo:approveResponses", false).booleanValue() != answer.getApprovedAnswers()) {
                answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers());
            }
            if (new PropertyReader(answerNode).bool("exo:activateResponses", false).booleanValue() != answer.getActivateAnswers()) {
                answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers());
            }
        }
        if (answer.getPostId() != null && answer.getPostId().length() > 0) {
            answerNode.setProperty("exo:postId", answer.getPostId());
        }
        if (questionNode.isNew()) {
            questionNode.getSession().save();
        } else {
            questionNode.save();
        }
    }

    public static void saveAnswer(Node quesNode, QuestionLanguage questionLanguage) throws Exception {
        Node answerNode;
        Node quesLangNode;
        try {
            quesLangNode = quesNode.getNode(Utils.LANGUAGE_HOME).getNode(questionLanguage.getId());
        }
        catch (Exception e) {
            quesLangNode = quesNode.getNode(Utils.LANGUAGE_HOME).addNode(questionLanguage.getId(), "exo:faqLanguage");
            quesNode.getSession().save();
        }
        if (!quesLangNode.isNodeType("mix:faqi18n")) {
            quesLangNode.addMixin("mix:faqi18n");
        }
        Node answerHome = null;
        Answer[] answers = questionLanguage.getAnswers();
        try {
            answerHome = quesLangNode.getNode(Utils.ANSWER_HOME);
        }
        catch (Exception e) {
            answerHome = quesLangNode.addNode(Utils.ANSWER_HOME, "exo:answerHome");
        }
        if (!answerHome.isNew()) {
            ArrayList<String> listNewAnswersId = new ArrayList<String>();
            for (int i = 0; i < answers.length; ++i) {
                listNewAnswersId.add(answers[i].getId());
            }
            NodeIterator nodeIterator = answerHome.getNodes();
            while (nodeIterator.hasNext()) {
                answerNode = nodeIterator.nextNode();
                if (listNewAnswersId.contains(answerNode.getName())) continue;
                answerNode.remove();
            }
        }
        for (Answer answer : answers) {
            answerNode = null;
            try {
                answerNode = answerHome.getNode(answer.getId());
            }
            catch (Exception e) {
                answerNode = answerHome.addNode(answer.getId(), "exo:answer");
                answerNode.setProperty("exo:id", answer.getId());
            }
            Date answerDate = null;
            if (answerNode.isNew()) {
                Calendar calendar = null;
                calendar = null;
                calendar = GregorianCalendar.getInstance();
                answerDate = new Date();
                calendar.setTime(answerDate);
                answerNode.setProperty("exo:dateResponse", calendar);
                answerNode.setProperty("exo:questionId", quesNode.getName());
                answerNode.setProperty("exo:categoryId", quesNode.getProperty("exo:categoryId").getString());
            } else if (answerNode.hasProperty("exo:dateResponse")) {
                answerDate = answerNode.getProperty("exo:dateResponse").getDate().getTime();
            }
            String language = answer.getLanguage();
            if (language == null || language.length() == 0) {
                language = questionLanguage.getLanguage();
            }
            answerNode.setProperty("exo:responses", answer.getResponses());
            answerNode.setProperty("exo:responseBy", answer.getResponseBy());
            answerNode.setProperty("exo:fullName", answer.getFullName());
            answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers());
            answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers());
            answerNode.setProperty("exo:usersVoteAnswer", answer.getUsersVoteAnswer());
            answerNode.setProperty("exo:MarkVotes", answer.getMarkVotes());
            answerNode.setProperty("exo:responseLanguage", language);
            if (answer.getPostId() != null && answer.getPostId().length() > 0) {
                answerNode.setProperty("exo:postId", answer.getPostId());
            }
            if (answerNode.isNew()) {
                quesNode.getSession().save();
                continue;
            }
            quesNode.save();
        }
    }

    public static void saveComment(Node questionNode, Comment comment, String language) throws Exception {
        Node commentNode;
        Node commentHome;
        String lang;
        if (language != null && language.length() > 0) {
            Node languageNode = MultiLanguages.getLanguageNodeByLanguage(questionNode, language);
            lang = language;
            if (!languageNode.isNodeType("mix:faqi18n")) {
                languageNode.addMixin("mix:faqi18n");
            }
            try {
                commentHome = languageNode.getNode(Utils.COMMENT_HOME);
            }
            catch (Exception e) {
                commentHome = languageNode.addNode(Utils.COMMENT_HOME, "exo:commentHome");
            }
        } else {
            try {
                commentHome = questionNode.getNode(Utils.COMMENT_HOME);
            }
            catch (Exception e) {
                commentHome = questionNode.addNode(Utils.COMMENT_HOME, "exo:commentHome");
            }
            lang = questionNode.getProperty("exo:language").getString();
        }
        try {
            commentNode = commentHome.getNode(comment.getId());
        }
        catch (Exception e) {
            commentNode = commentHome.addNode(comment.getId(), "exo:comment");
            commentNode.setProperty("exo:id", comment.getId());
        }
        commentNode.setProperty("exo:comments", comment.getComments());
        commentNode.setProperty("exo:commentBy", comment.getCommentBy());
        commentNode.setProperty("exo:fullName", comment.getFullName());
        commentNode.setProperty("exo:categoryId", questionNode.getProperty("exo:categoryId").getString());
        commentNode.setProperty("exo:questionId", questionNode.getName());
        commentNode.setProperty("exo:commentLanguage", lang);
        if (comment.getPostId() != null && comment.getPostId().length() > 0) {
            commentNode.setProperty("exo:postId", comment.getPostId());
        }
        Date commentTime = null;
        if (commentNode.isNew()) {
            Calendar calendar = null;
            calendar = GregorianCalendar.getInstance();
            commentTime = new Date();
            calendar.setTime(commentTime);
            commentNode.setProperty("exo:dateComment", calendar);
        }
        questionNode.save();
    }

    protected Value[] booleanToValues(Node node, Boolean[] bools) throws Exception {
        if (bools == null) {
            return new Value[]{node.getSession().getValueFactory().createValue(true)};
        }
        Value[] values = new Value[bools.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = node.getSession().getValueFactory().createValue(bools[i].booleanValue());
        }
        return values;
    }

    public static void removeLanguage(Node questionNode, List<String> listLanguage) {
        try {
            if (!questionNode.hasNode(Utils.LANGUAGE_HOME)) {
                return;
            }
            Node languageNode = questionNode.getNode(Utils.LANGUAGE_HOME);
            NodeIterator nodeIterator = languageNode.getNodes();
            Node node = null;
            while (nodeIterator.hasNext()) {
                node = nodeIterator.nextNode();
                if (listLanguage.contains(node.getProperty("exo:language").getString())) continue;
                node.remove();
            }
            questionNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)"Fail to remove language from a list of language: ", (Throwable)e);
        }
    }

    public static void removeLanguage(Node questionNode, QuestionLanguage lang) {
        try {
            if (!questionNode.hasNode(Utils.LANGUAGE_HOME)) {
                return;
            }
            Node languageNode = questionNode.getNode(Utils.LANGUAGE_HOME);
            languageNode.getNode(lang.getId()).remove();
            questionNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Fail to remove language from a question language: ", (Throwable)e);
        }
    }

    public static void voteAnswer(Node answerNode, String userName, boolean isUp) throws Exception {
        boolean isVoted = false;
        long mark = 0L;
        List<String> users = new ArrayList<String>();
        if (answerNode.hasProperty("exo:usersVoteAnswer") && answerNode.hasProperty("exo:MarkVotes")) {
            PropertyReader reader = new PropertyReader(answerNode);
            users = reader.list("exo:usersVoteAnswer", new ArrayList());
            mark = reader.l("exo:MarkVotes");
            int i = 0;
            for (String user : users) {
                if (user.indexOf(userName) > -1) {
                    String[] values = user.split("/");
                    if (values[1].equals("1")) {
                        if (!isUp) {
                            mark -= 2L;
                            users.add(i, userName + "/-1");
                        }
                    } else if (isUp) {
                        mark += 2L;
                        users.add(i, userName + "/1");
                    }
                    isVoted = true;
                    break;
                }
                ++i;
            }
        }
        if (isVoted) {
            answerNode.setProperty("exo:usersVoteAnswer", users.toArray(new String[0]));
            answerNode.setProperty("exo:MarkVotes", mark);
        } else {
            ArrayList<String> newUsers = users;
            if (isUp) {
                ++mark;
                newUsers.add(userName + "/1");
            } else {
                --mark;
                newUsers.add(userName + "/-1");
            }
            answerNode.setProperty("exo:usersVoteAnswer", newUsers.toArray(new String[0]));
            answerNode.setProperty("exo:MarkVotes", mark);
        }
        answerNode.save();
    }

    public static void voteQuestion(Node questionNode, String userName, int number) throws Exception {
        if (questionNode.hasProperty("exo:markVote") && questionNode.hasProperty("exo:usersVote")) {
            double mark = questionNode.getProperty("exo:markVote").getDouble();
            ArrayList<String> currentUsers = new ArrayList<String>();
            currentUsers.addAll(new PropertyReader(questionNode).list("exo:usersVote", new ArrayList()));
            double currentMark = (mark * (double)currentUsers.size() + (double)number) / (double)(currentUsers.size() + 1);
            currentUsers.add(userName + "/" + number);
            questionNode.setProperty("exo:markVote", currentMark);
            questionNode.setProperty("exo:usersVote", currentUsers.toArray(new String[0]));
        } else {
            double mark = number;
            questionNode.setProperty("exo:markVote", mark);
            questionNode.setProperty("exo:usersVote", new String[]{userName + "/" + number});
        }
        questionNode.save();
    }

    public static void unVoteQuestion(Node questionNode, String userName) throws Exception {
        PropertyReader reader = new PropertyReader(questionNode);
        List userList = reader.list("exo:usersVote", new ArrayList());
        ArrayList<String> newList = new ArrayList<String>();
        double mark = 0.0;
        for (String user : userList) {
            if (user.indexOf(userName + "/") == 0) {
                int number = Integer.parseInt(user.substring(user.indexOf("/") + 1));
                mark = reader.d("exo:markVote");
                if (userList.size() > 1) {
                    mark = (mark * (double)userList.size() - (double)number) / (double)(userList.size() - 1);
                    continue;
                }
                mark = 0.0;
                continue;
            }
            newList.add(user);
        }
        questionNode.setProperty("exo:markVote", mark);
        questionNode.setProperty("exo:usersVote", newList.toArray(new String[newList.size()]));
        questionNode.save();
    }
}

