/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.PortalStatistic;
import org.exoplatform.portal.application.PortalStatisticService;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalStatisticLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final String ATTRIBUTE_NAME = "PortalStatistic";

    public void onInit(Application app) {
    }

    public void onStartRequest(Application app, WebuiRequestContext rcontext) throws Exception {
        app.setAttribute(ATTRIBUTE_NAME, (Object)System.currentTimeMillis());
    }

    public void onFailRequest(Application app, WebuiRequestContext rcontext, RequestFailure failureType) throws Exception {
    }

    public void onEndRequest(Application app, WebuiRequestContext rcontext) throws Exception {
        PortalStatisticService service = (PortalStatisticService)PortalContainer.getInstance().getComponentInstanceOfType(PortalStatisticService.class);
        String portalOwner = ((PortalRequestContext)rcontext).getPortalOwner();
        if (portalOwner != null) {
            PortalStatistic appStatistic = service.getPortalStatistic(portalOwner);
            long startTime = Long.valueOf(app.getAttribute(ATTRIBUTE_NAME).toString());
            appStatistic.logTime(System.currentTimeMillis() - startTime);
        }
    }

    public void onDestroy(Application app) {
    }
}

