/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.Constants;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.res.StringManager;

public class AjpAprProcessor
implements ActionHook {
    protected static Log log = LogFactory.getLog(AjpAprProcessor.class);
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.ajp");
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected int packetSize;
    protected AjpMessage requestHeaderMessage = null;
    protected AjpMessage responseHeaderMessage = null;
    protected AjpMessage bodyMessage = null;
    protected MessageBytes bodyBytes = MessageBytes.newInstance();
    protected boolean started = false;
    protected boolean error = false;
    protected long socket;
    protected char[] hostNameC = new char[0];
    protected AprEndpoint endpoint;
    protected MessageBytes tmpMB = MessageBytes.newInstance();
    protected MessageBytes certificates = MessageBytes.newInstance();
    protected boolean endOfStream = false;
    protected boolean empty = true;
    protected boolean first = true;
    protected boolean replay = false;
    protected boolean finished = false;
    protected ByteBuffer outputBuffer = null;
    protected ByteBuffer inputBuffer = null;
    protected final ByteBuffer getBodyMessageBuffer;
    protected static final ByteBuffer pongMessageBuffer;
    protected static final byte[] endMessageArray;
    protected static final ByteBuffer flushMessageBuffer;
    protected boolean tomcatAuthentication = true;
    protected String requiredSecret = null;

    public AjpAprProcessor(int packetSize, AprEndpoint endpoint) {
        this.endpoint = endpoint;
        this.request = new Request();
        this.request.setInputBuffer(new SocketInputBuffer());
        this.response = new Response();
        this.response.setHook(this);
        this.response.setOutputBuffer(new SocketOutputBuffer());
        this.request.setResponse(this.response);
        this.packetSize = packetSize;
        this.requestHeaderMessage = new AjpMessage(packetSize);
        this.responseHeaderMessage = new AjpMessage(packetSize);
        this.bodyMessage = new AjpMessage(packetSize);
        AjpMessage getBodyMessage = new AjpMessage(16);
        getBodyMessage.reset();
        getBodyMessage.appendByte(6);
        getBodyMessage.appendInt(8186 + packetSize - 8192);
        getBodyMessage.end();
        this.getBodyMessageBuffer = ByteBuffer.allocateDirect(getBodyMessage.getLen());
        this.getBodyMessageBuffer.put(getBodyMessage.getBuffer(), 0, getBodyMessage.getLen());
        this.inputBuffer = ByteBuffer.allocateDirect(packetSize * 2);
        this.inputBuffer.limit(0);
        this.outputBuffer = ByteBuffer.allocateDirect(packetSize * 2);
        int foo = HexUtils.DEC[0];
        HttpMessages.getMessage(200);
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean process(long socket) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.socket = socket;
        Socket.setrbb(this.socket, this.inputBuffer);
        Socket.setsbb(this.socket, this.outputBuffer);
        this.error = false;
        boolean openSocket = true;
        boolean keptAlive = false;
        while (this.started && !this.error) {
            try {
                if (!this.readMessage(this.requestHeaderMessage, true, keptAlive)) {
                    rp.setStage(7);
                    break;
                }
                byte type = this.requestHeaderMessage.getByte();
                if (type == 10) {
                    if (Socket.sendb(socket, pongMessageBuffer, 0, pongMessageBuffer.position()) >= 0) continue;
                    this.error = true;
                    continue;
                }
                if (type != 2) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Unexpected message: " + type));
                    continue;
                }
                keptAlive = true;
                this.request.setStartTime(System.currentTimeMillis());
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Throwable t) {
                log.debug((Object)sm.getString("ajpprocessor.header.error"), t);
                this.response.setStatus(400);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            rp.setStage(2);
            try {
                this.prepareRequest();
            }
            catch (Throwable t) {
                log.debug((Object)sm.getString("ajpprocessor.request.prepare"), t);
                this.response.setStatus(400);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            if (!this.error) {
                try {
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("ajpprocessor.request.process"), t);
                    this.response.setStatus(500);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (!this.finished) {
                try {
                    this.finish();
                }
                catch (Throwable t) {
                    this.error = true;
                }
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            rp.setStage(6);
            this.recycle();
        }
        if (!this.error) {
            this.endpoint.getPoller().add(socket);
        } else {
            openSocket = false;
        }
        rp.setStage(7);
        this.recycle();
        return openSocket;
    }

    public void action(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.ACTION_COMMIT) {
            if (this.response.isCommitted()) {
                return;
            }
            try {
                this.prepareResponse();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACTION_CLIENT_FLUSH) {
            if (!this.response.isCommitted()) {
                try {
                    this.prepareResponse();
                }
                catch (IOException e) {
                    this.error = true;
                    return;
                }
            }
            try {
                this.flush();
                if (Socket.sendb(this.socket, flushMessageBuffer, 0, flushMessageBuffer.position()) < 0) {
                    this.error = true;
                }
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACTION_CLOSE) {
            try {
                this.finish();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACTION_START) {
            this.started = true;
        } else if (actionCode == ActionCode.ACTION_STOP) {
            this.started = false;
        } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
            if (!this.certificates.isNull()) {
                ByteChunk certData = this.certificates.getByteChunk();
                X509Certificate[] jsseCerts = null;
                ByteArrayInputStream bais = new ByteArrayInputStream(certData.getBytes(), certData.getStart(), certData.getLength());
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    while (bais.available() > 0) {
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                        if (jsseCerts == null) {
                            jsseCerts = new X509Certificate[]{cert};
                            continue;
                        }
                        X509Certificate[] temp = new X509Certificate[jsseCerts.length + 1];
                        System.arraycopy(jsseCerts, 0, temp, 0, jsseCerts.length);
                        temp[jsseCerts.length] = cert;
                        jsseCerts = temp;
                    }
                }
                catch (CertificateException e) {
                    log.error((Object)sm.getString("ajpprocessor.certs.fail"), (Throwable)e);
                    return;
                }
                this.request.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
            }
        } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
            if (this.request.remoteHost().isNull()) {
                try {
                    this.request.remoteHost().setString(InetAddress.getByName(this.request.remoteAddr().toString()).getHostName());
                }
                catch (IOException iex) {}
            }
        } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE) {
            this.request.localAddr().setString(this.request.localName().toString());
        } else if (actionCode == ActionCode.ACTION_REQ_SET_BODY_REPLAY) {
            ByteChunk bc = (ByteChunk)param;
            int length = bc.getLength();
            this.bodyBytes.setBytes(bc.getBytes(), bc.getStart(), length);
            this.request.setContentLength(length);
            this.first = false;
            this.empty = false;
            this.replay = true;
        }
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void prepareRequest() {
        ByteChunk uriBC;
        byte attributeCode;
        boolean isSSL;
        byte methodCode = this.requestHeaderMessage.getByte();
        if (methodCode != -1) {
            String methodName = org.apache.coyote.ajp.Constants.methodTransArray[methodCode - 1];
            this.request.method().setString(methodName);
        }
        this.requestHeaderMessage.getBytes(this.request.protocol());
        this.requestHeaderMessage.getBytes(this.request.requestURI());
        this.requestHeaderMessage.getBytes(this.request.remoteAddr());
        this.requestHeaderMessage.getBytes(this.request.remoteHost());
        this.requestHeaderMessage.getBytes(this.request.localName());
        this.request.setLocalPort(this.requestHeaderMessage.getInt());
        boolean bl = isSSL = this.requestHeaderMessage.getByte() != 0;
        if (isSSL) {
            this.request.scheme().setString("https");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        int hCount = this.requestHeaderMessage.getInt();
        for (int i = 0; i < hCount; ++i) {
            String hName = null;
            int isc = this.requestHeaderMessage.peekInt();
            int hId = isc & 0xFF;
            MessageBytes vMB = null;
            if (40960 == (isc &= 0xFF00)) {
                this.requestHeaderMessage.getInt();
                hName = org.apache.coyote.ajp.Constants.headerTransArray[hId - 1];
                vMB = headers.addValue(hName);
            } else {
                hId = -1;
                this.requestHeaderMessage.getBytes(this.tmpMB);
                ByteChunk bc = this.tmpMB.getByteChunk();
                vMB = headers.addValue(bc.getBuffer(), bc.getStart(), bc.getLength());
            }
            this.requestHeaderMessage.getBytes(vMB);
            if (hId == 8 || hId == -1 && this.tmpMB.equalsIgnoreCase("Content-Length")) {
                long cl = vMB.getLong();
                if (cl >= Integer.MAX_VALUE) continue;
                this.request.setContentLength((int)cl);
                continue;
            }
            if (hId != 7 && (hId != -1 || !this.tmpMB.equalsIgnoreCase("Content-Type"))) continue;
            ByteChunk bchunk = vMB.getByteChunk();
            this.request.contentType().setBytes(bchunk.getBytes(), bchunk.getOffset(), bchunk.getLength());
        }
        boolean secret = false;
        while ((attributeCode = this.requestHeaderMessage.getByte()) != -1) {
            switch (attributeCode) {
                case 10: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String n = this.tmpMB.toString();
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String v = this.tmpMB.toString();
                    if (n.equals("AJP_REMOTE_PORT")) {
                        try {
                            this.request.setRemotePort(Integer.parseInt(v));
                        }
                        catch (NumberFormatException nfe) {}
                        break;
                    }
                    this.request.setAttribute(n, v);
                    break;
                }
                case 1: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    break;
                }
                case 2: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    break;
                }
                case 3: {
                    if (this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.tmpMB);
                        break;
                    }
                    this.requestHeaderMessage.getBytes(this.request.getRemoteUser());
                    break;
                }
                case 4: {
                    if (this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.tmpMB);
                        break;
                    }
                    this.requestHeaderMessage.getBytes(this.request.getAuthType());
                    break;
                }
                case 5: {
                    this.requestHeaderMessage.getBytes(this.request.queryString());
                    break;
                }
                case 6: {
                    this.requestHeaderMessage.getBytes(this.request.instanceId());
                    break;
                }
                case 7: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.certificates);
                    break;
                }
                case 8: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.cipher_suite", this.tmpMB.toString());
                    break;
                }
                case 9: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.ssl_session", this.tmpMB.toString());
                    break;
                }
                case 11: {
                    this.request.setAttribute("javax.servlet.request.key_size", new Integer(this.requestHeaderMessage.getInt()));
                    break;
                }
                case 13: {
                    this.requestHeaderMessage.getBytes(this.request.method());
                    break;
                }
                case 12: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    if (this.requiredSecret == null) break;
                    secret = true;
                    if (this.tmpMB.equals(this.requiredSecret)) break;
                    this.response.setStatus(403);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                    break;
                }
            }
        }
        if (this.requiredSecret != null && !secret) {
            this.response.setStatus(403);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        MessageBytes valueMB = this.request.getMimeHeaders().getValue("host");
        this.parseHost(valueMB);
    }

    public void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB != null && valueMB.isNull()) {
            this.request.setServerPort(this.request.getLocalPort());
            try {
                this.request.serverName().duplicate(this.request.localName());
            }
            catch (IOException e) {
                this.response.setStatus(400);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.request.scheme().equalsIgnoreCase("https")) {
                this.request.setServerPort(443);
            } else {
                this.request.setServerPort(80);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    protected void prepareResponse() throws IOException {
        long contentLength;
        String contentLanguage;
        this.response.setCommitted(true);
        this.responseHeaderMessage.reset();
        this.responseHeaderMessage.appendByte(4);
        this.responseHeaderMessage.appendInt(this.response.getStatus());
        String message = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader(this.response.getMessage())) {
            message = this.response.getMessage();
        }
        if (message == null) {
            message = HttpMessages.getMessage(this.response.getStatus());
        }
        if (message == null) {
            message = Integer.toString(this.response.getStatus());
        }
        this.tmpMB.setString(message);
        this.responseHeaderMessage.appendBytes(this.tmpMB);
        MimeHeaders headers = this.response.getMimeHeaders();
        String contentType = this.response.getContentType();
        if (contentType != null) {
            headers.setValue("Content-Type").setString(contentType);
        }
        if ((contentLanguage = this.response.getContentLanguage()) != null) {
            headers.setValue("Content-Language").setString(contentLanguage);
        }
        if ((contentLength = this.response.getContentLengthLong()) >= 0L) {
            headers.setValue("Content-Length").setLong(contentLength);
        }
        int numHeaders = headers.size();
        this.responseHeaderMessage.appendInt(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            MessageBytes hN = headers.getName(i);
            int hC = org.apache.coyote.ajp.Constants.getResponseAjpIndex(hN.toString());
            if (hC > 0) {
                this.responseHeaderMessage.appendInt(hC);
            } else {
                this.responseHeaderMessage.appendBytes(hN);
            }
            MessageBytes hV = headers.getValue(i);
            this.responseHeaderMessage.appendBytes(hV);
        }
        this.responseHeaderMessage.end();
        this.outputBuffer.put(this.responseHeaderMessage.getBuffer(), 0, this.responseHeaderMessage.getLen());
    }

    protected void finish() throws IOException {
        if (!this.response.isCommitted()) {
            try {
                this.prepareResponse();
            }
            catch (IOException e) {
                this.error = true;
            }
        }
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.outputBuffer.position() + endMessageArray.length > this.outputBuffer.capacity()) {
            this.flush();
        }
        this.outputBuffer.put(endMessageArray);
        this.flush();
    }

    protected boolean read(int n) throws IOException {
        if (this.inputBuffer.capacity() - this.inputBuffer.limit() <= n - this.inputBuffer.remaining()) {
            this.inputBuffer.compact();
            this.inputBuffer.limit(this.inputBuffer.position());
            this.inputBuffer.position(0);
        }
        while (this.inputBuffer.remaining() < n) {
            int nRead = Socket.recvbb(this.socket, this.inputBuffer.limit(), this.inputBuffer.capacity() - this.inputBuffer.limit());
            if (nRead > 0) {
                this.inputBuffer.limit(this.inputBuffer.limit() + nRead);
                continue;
            }
            throw new IOException(sm.getString("ajpprotocol.failedread"));
        }
        return true;
    }

    protected boolean readt(int n, boolean useAvailableData) throws IOException {
        if (useAvailableData && this.inputBuffer.remaining() == 0) {
            return false;
        }
        if (this.inputBuffer.capacity() - this.inputBuffer.limit() <= n - this.inputBuffer.remaining()) {
            this.inputBuffer.compact();
            this.inputBuffer.limit(this.inputBuffer.position());
            this.inputBuffer.position(0);
        }
        while (this.inputBuffer.remaining() < n) {
            int nRead = Socket.recvbb(this.socket, this.inputBuffer.limit(), this.inputBuffer.capacity() - this.inputBuffer.limit());
            if (nRead > 0) {
                this.inputBuffer.limit(this.inputBuffer.limit() + nRead);
                continue;
            }
            if (-nRead == 120005 || -nRead == 120001) {
                return false;
            }
            throw new IOException(sm.getString("ajpprotocol.failedread"));
        }
        return true;
    }

    public boolean receive() throws IOException {
        this.first = false;
        this.bodyMessage.reset();
        this.readMessage(this.bodyMessage, false, false);
        if (this.bodyMessage.getLen() == 0) {
            return false;
        }
        int blen = this.bodyMessage.peekInt();
        if (blen == 0) {
            return false;
        }
        this.bodyMessage.getBytes(this.bodyBytes);
        this.empty = false;
        return true;
    }

    private boolean refillReadBuffer() throws IOException {
        if (this.replay) {
            this.endOfStream = true;
        }
        if (this.endOfStream) {
            return false;
        }
        Socket.sendb(this.socket, this.getBodyMessageBuffer, 0, this.getBodyMessageBuffer.position());
        boolean moreData = this.receive();
        if (!moreData) {
            this.endOfStream = true;
        }
        return moreData;
    }

    protected boolean readMessage(AjpMessage message, boolean first, boolean useAvailableData) throws IOException {
        byte[] buf = message.getBuffer();
        int headerLength = message.getHeaderLength();
        if (first) {
            if (!this.readt(headerLength, useAvailableData)) {
                return false;
            }
        } else {
            this.read(headerLength);
        }
        this.inputBuffer.get(message.getBuffer(), 0, headerLength);
        message.processHeader();
        this.read(message.getLen());
        this.inputBuffer.get(message.getBuffer(), headerLength, message.getLen());
        return true;
    }

    public void recycle() {
        this.first = true;
        this.endOfStream = false;
        this.empty = true;
        this.replay = false;
        this.finished = false;
        this.request.recycle();
        this.response.recycle();
        this.certificates.recycle();
        this.inputBuffer.clear();
        this.inputBuffer.limit(0);
        this.outputBuffer.clear();
    }

    protected void flush() throws IOException {
        if (this.outputBuffer.position() > 0) {
            if (Socket.sendbb(this.socket, 0, this.outputBuffer.position()) < 0) {
                throw new IOException(sm.getString("ajpprocessor.failedsend"));
            }
            this.outputBuffer.clear();
        }
    }

    static {
        AjpMessage pongMessage = new AjpMessage(16);
        pongMessage.reset();
        pongMessage.appendByte(9);
        pongMessage.end();
        pongMessageBuffer = ByteBuffer.allocateDirect(pongMessage.getLen());
        pongMessageBuffer.put(pongMessage.getBuffer(), 0, pongMessage.getLen());
        AjpMessage endMessage = new AjpMessage(16);
        endMessage.reset();
        endMessage.appendByte(5);
        endMessage.appendByte(1);
        endMessage.end();
        endMessageArray = new byte[endMessage.getLen()];
        System.arraycopy(endMessage.getBuffer(), 0, endMessageArray, 0, endMessage.getLen());
        AjpMessage flushMessage = new AjpMessage(16);
        flushMessage.reset();
        flushMessage.appendByte(3);
        flushMessage.appendInt(0);
        flushMessage.appendByte(0);
        flushMessage.end();
        flushMessageBuffer = ByteBuffer.allocateDirect(flushMessage.getLen());
        flushMessageBuffer.put(flushMessage.getBuffer(), 0, flushMessage.getLen());
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            if (!AjpAprProcessor.this.response.isCommitted()) {
                try {
                    AjpAprProcessor.this.prepareResponse();
                }
                catch (IOException e) {
                    AjpAprProcessor.this.error = true;
                }
            }
            int len = chunk.getLength();
            int chunkSize = 8184 + AjpAprProcessor.this.packetSize - 8192;
            int off = 0;
            while (len > 0) {
                int thisTime = len;
                if (thisTime > chunkSize) {
                    thisTime = chunkSize;
                }
                len -= thisTime;
                if (AjpAprProcessor.this.outputBuffer.position() + thisTime + 4 + 4 > AjpAprProcessor.this.outputBuffer.capacity()) {
                    AjpAprProcessor.this.flush();
                }
                AjpAprProcessor.this.outputBuffer.put((byte)65);
                AjpAprProcessor.this.outputBuffer.put((byte)66);
                AjpAprProcessor.this.outputBuffer.putShort((short)(thisTime + 4));
                AjpAprProcessor.this.outputBuffer.put((byte)3);
                AjpAprProcessor.this.outputBuffer.putShort((short)thisTime);
                AjpAprProcessor.this.outputBuffer.put(chunk.getBytes(), chunk.getOffset() + off, thisTime);
                AjpAprProcessor.this.outputBuffer.put((byte)0);
                off += thisTime;
            }
            return chunk.getLength();
        }
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (AjpAprProcessor.this.endOfStream) {
                return -1;
            }
            if (AjpAprProcessor.this.first && req.getContentLengthLong() > 0L) {
                if (!AjpAprProcessor.this.receive()) {
                    return 0;
                }
            } else if (AjpAprProcessor.this.empty && !AjpAprProcessor.this.refillReadBuffer()) {
                return -1;
            }
            ByteChunk bc = AjpAprProcessor.this.bodyBytes.getByteChunk();
            chunk.setBytes(bc.getBuffer(), bc.getStart(), bc.getLength());
            AjpAprProcessor.this.empty = true;
            return chunk.getLength();
        }
    }
}

