/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.impl.JCRDataStorage;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.ks.common.jcr.SessionManager;

public class ForumPageList
extends JCRPageList {
    private boolean isQuery_ = false;
    private String value_;
    private SessionManager sessionManager;
    private NodeIterator iter_ = null;
    private List listValue_ = null;

    public ForumPageList(int pageSize, int size) {
        super(pageSize);
        this.setAvailablePage(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForumPageList(NodeIterator iter, int pageSize, String value, boolean isQuery) throws Exception {
        super(pageSize);
        this.value_ = value;
        this.isQuery_ = isQuery;
        this.sessionManager = ForumServiceUtils.getSessionManager();
        if (iter == null) {
            this.sessionManager.openSession();
            this.iter_ = iter = this.setQuery(this.isQuery_, this.value_);
        }
        if (iter != null) {
            this.setAvailablePage((int)iter.getSize());
        }
    }

    public ForumPageList(List listResult) {
        super(listResult.size());
        this.isQuery_ = false;
        this.listValue_ = listResult;
        this.sessionManager = ForumServiceUtils.getSessionManager();
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (this.iter_ == null) {
            this.iter_ = this.setQuery(this.isQuery_, this.value_);
            this.setAvailablePage((int)this.iter_.getSize());
            if (page == 0) {
                this.currentPage_ = 0;
            } else {
                this.checkAndSetPage(page);
            }
            page = this.currentPage_;
        }
        long pageSize = 0L;
        if (page > 0) {
            long position = 0L;
            pageSize = this.getPageSize();
            if (page == 1) {
                position = 0L;
            } else {
                position = (long)(page - 1) * pageSize;
                this.iter_.skip(position);
            }
        } else {
            pageSize = this.iter_.getSize();
        }
        this.currentListPage_ = new ArrayList();
        int i = 0;
        while ((long)i < pageSize && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            if (currentNode.isNodeType("exo:post")) {
                this.currentListPage_.add(this.getPost(currentNode));
            } else if (currentNode.isNodeType(Utils.TYPE_TOPIC)) {
                this.currentListPage_.add(this.getTopic(currentNode));
            } else if (currentNode.isNodeType(Utils.USER_PROFILES_TYPE)) {
                this.currentListPage_.add(this.getUserProfile(currentNode));
            } else if (currentNode.isNodeType("exo:privateMessage")) {
                this.currentListPage_.add(this.getPrivateMessage(currentNode));
            }
            ++i;
        }
        this.iter_ = null;
        if (this.sessionManager.getCurrentSession() != null && this.sessionManager.getCurrentSession().isLive()) {
            this.sessionManager.closeSession();
        }
    }

    protected void populateCurrentPage(String valueString) throws Exception {
        NodeIterator nodeIterator = this.setQuery(this.isQuery_, this.value_);
        if (this.iter_ == null) {
            this.iter_ = this.setQuery(this.isQuery_, this.value_);
        }
        int pos = 0;
        int i = 0;
        while ((long)i < nodeIterator.getSize()) {
            if (this.getUserProfile(nodeIterator.nextNode()).getUserId().equals(valueString)) {
                pos = i + 1;
                break;
            }
            ++i;
        }
        int pageSize = this.getPageSize();
        int page = 1;
        if (pos < pageSize) {
            page = 1;
        } else {
            page = pos / pageSize;
            if (pos % pageSize > 0) {
                ++page;
            }
        }
        this.pageSelected = page;
        this.iter_.skip((long)((page - 1) * pageSize));
        this.currentListPage_ = new ArrayList();
        for (int i2 = 0; i2 < pageSize && this.iter_.hasNext(); ++i2) {
            Node currentNode = this.iter_.nextNode();
            if (!currentNode.isNodeType(Utils.USER_PROFILES_TYPE)) continue;
            this.currentListPage_.add(this.getUserProfile(currentNode));
        }
        this.iter_ = null;
        if (this.sessionManager.getCurrentSession() != null && this.sessionManager.getCurrentSession().isLive()) {
            this.sessionManager.closeSession();
        }
    }

    protected void populateCurrentPageSearch(int page, List list, boolean isWatch, boolean isSearchUser) throws Exception {
        int pageSize = this.getPageSize();
        int position = 0;
        position = page == 1 ? 0 : (page - 1) * pageSize;
        int endIndex = pageSize * page;
        if (!isSearchUser) {
            this.currentListPage_ = !isWatch ? new ArrayList() : new ArrayList();
        } else {
            this.currentListPage_ = new CopyOnWriteArrayList();
            list = this.listValue_;
        }
        int n = endIndex = endIndex < list.size() ? endIndex : list.size();
        if (endIndex > position) {
            this.currentListPage_.addAll(list.subList(position, endIndex));
        }
    }

    private NodeIterator setQuery(boolean isQuery, String value) throws Exception {
        NodeIterator iter;
        Session session = this.sessionManager.getCurrentSession();
        if (session == null || !session.isLive()) {
            this.sessionManager.openSession();
            session = this.sessionManager.getCurrentSession();
        }
        if (isQuery) {
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(value, "xpath");
            QueryResult result = query.execute();
            iter = result.getNodes();
        } else {
            Node node = (Node)session.getItem(value);
            iter = node.getNodes();
        }
        return iter;
    }

    public Post getPost(Node postNode) throws Exception {
        Post postNew = new Post();
        PropertyReader reader = new PropertyReader(postNode);
        postNew.setId(postNode.getName());
        postNew.setPath(postNode.getPath());
        postNew.setOwner(reader.string("exo:owner"));
        postNew.setCreatedDate(reader.date("exo:createdDate"));
        postNew.setModifiedBy(reader.string("exo:modifiedBy"));
        postNew.setModifiedDate(reader.date("exo:modifiedDate"));
        postNew.setEditReason(reader.string("exo:editReason"));
        postNew.setName(reader.string("exo:name"));
        postNew.setMessage(reader.string("exo:message"));
        postNew.setRemoteAddr(reader.string("exo:remoteAddr"));
        postNew.setIcon(reader.string("exo:icon"));
        postNew.setLink(reader.string("exo:link"));
        postNew.setIsApproved(reader.bool("exo:isApproved"));
        postNew.setIsHidden(reader.bool("exo:isHidden"));
        postNew.setIsWaiting(reader.bool("exo:isWaiting"));
        postNew.setIsActiveByTopic(reader.bool("exo:isActiveByTopic"));
        postNew.setUserPrivate(reader.strings("exo:userPrivate"));
        postNew.setNumberAttach(reader.l("exo:numberAttach"));
        if (postNew.getNumberAttach() > 0L) {
            postNew.setAttachments(JCRDataStorage.getAttachmentsByNode(postNode));
        }
        return postNew;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Topic getTopic(Node topicNode) throws Exception {
        if (topicNode == null) {
            return null;
        }
        Topic topicNew = new Topic();
        PropertyReader reader = new PropertyReader(topicNode);
        topicNew.setId(topicNode.getName());
        topicNew.setPath(topicNode.getPath());
        topicNew.setIcon(reader.string("exo:icon"));
        topicNew.setTopicType(reader.string("exo:topicType", " "));
        topicNew.setTopicName(reader.string("exo:name"));
        topicNew.setOwner(reader.string("exo:owner"));
        topicNew.setCreatedDate(reader.date("exo:createdDate"));
        topicNew.setDescription(reader.string("exo:description"));
        topicNew.setLastPostBy(reader.string("exo:lastPostBy"));
        topicNew.setLastPostDate(reader.date("exo:lastPostDate"));
        topicNew.setIsSticky(reader.bool("exo:isSticky"));
        if (topicNode.getParent().getProperty("exo:isLock").getBoolean()) {
            topicNew.setIsLock(true);
        } else {
            topicNew.setIsLock(topicNode.getProperty("exo:isLock").getBoolean());
        }
        topicNew.setIsClosed(reader.bool("exo:isClosed"));
        topicNew.setIsApproved(reader.bool("exo:isApproved"));
        topicNew.setIsActive(reader.bool("exo:isActive"));
        topicNew.setIsWaiting(reader.bool("exo:isWaiting"));
        topicNew.setIsActiveByForum(reader.bool("exo:isActiveByForum"));
        topicNew.setIsPoll(reader.bool("exo:isPoll"));
        topicNew.setPostCount(reader.l("exo:postCount"));
        topicNew.setViewCount(reader.l("exo:viewCount"));
        topicNew.setNumberAttachment(reader.l("exo:numberAttachments"));
        topicNew.setUserVoteRating(reader.strings("exo:userVoteRating"));
        topicNew.setVoteRating(reader.d("exo:voteRating"));
        topicNew.setModifiedBy(reader.string("exo:modifiedBy"));
        topicNew.setModifiedDate(reader.date("exo:modifiedDate"));
        topicNew.setIsModeratePost(reader.bool("exo:isModeratePost"));
        topicNew.setIsNotifyWhenAddPost(reader.string("exo:isNotifyWhenAddPost", null));
        topicNew.setLink(reader.string("exo:link"));
        topicNew.setTagId(reader.strings("exo:tagId"));
        topicNew.setCanView(reader.strings("exo:canView", new String[0]));
        topicNew.setCanPost(reader.strings("exo:canPost", new String[0]));
        if (topicNode.isNodeType("exo:forumWatching")) {
            topicNew.setEmailNotification(reader.strings("exo:emailWatching", new String[0]));
        }
        try {
            if (topicNew.getNumberAttachment() <= 0L) return topicNew;
        }
        catch (Exception e) {
            // empty catch block
        }
        return topicNew;
    }

    private UserProfile getUserProfile(Node profileNode) throws Exception {
        UserProfile userProfile = new UserProfile();
        userProfile.setUserId(profileNode.getName());
        PropertyReader reader = new PropertyReader(profileNode);
        userProfile.setScreenName(reader.string("exo:screenName", reader.string("exo:fullName", profileNode.getName())));
        userProfile.setFullName(reader.string("exo:fullName"));
        userProfile.setFirstName(reader.string("exo:firstName"));
        userProfile.setLastName(reader.string("exo:lastName"));
        userProfile.setEmail(reader.string("exo:email"));
        userProfile.setUserRole(reader.l("exo:userRole"));
        userProfile.setUserTitle(reader.string("exo:userTitle", ""));
        userProfile.setSignature(reader.string("exo:signature"));
        userProfile.setTotalPost(reader.l("exo:totalPost"));
        userProfile.setTotalTopic(reader.l("exo:totalTopic"));
        userProfile.setBookmark(reader.strings("exo:bookmark"));
        userProfile.setLastLoginDate(reader.date("exo:lastLoginDate"));
        userProfile.setJoinedDate(reader.date("exo:joinedDate"));
        userProfile.setLastPostDate(reader.date("exo:lastPostDate"));
        userProfile.setIsDisplaySignature(reader.bool("exo:isDisplaySignature"));
        userProfile.setIsDisplayAvatar(reader.bool("exo:isDisplayAvatar"));
        userProfile.setShortDateFormat(reader.string("exo:shortDateformat", userProfile.getShortDateFormat()));
        userProfile.setLongDateFormat(reader.string("exo:longDateformat", userProfile.getLongDateFormat()));
        userProfile.setTimeFormat(reader.string("exo:timeFormat", userProfile.getTimeFormat()));
        userProfile.setMaxPostInPage(reader.l("exo:maxPost", 10L));
        userProfile.setMaxTopicInPage(reader.l("exo:maxTopic", 10L));
        userProfile.setIsShowForumJump(reader.bool("exo:isShowForumJump", true));
        userProfile.setModerateForums(reader.strings("exo:moderateForums", new String[0]));
        userProfile.setModerateCategory(reader.strings("exo:moderateCategory", new String[0]));
        userProfile.setNewMessage(reader.l("exo:newMessage"));
        userProfile.setTimeZone(reader.d("exo:timeZone"));
        userProfile.setIsBanned(reader.bool("exo:isBanned"));
        userProfile.setBanUntil(reader.l("exo:banUntil"));
        userProfile.setBanReason(reader.string("exo:banReason", ""));
        userProfile.setBanCounter(Integer.parseInt(reader.string("exo:banCounter", "0")));
        userProfile.setBanReasonSummary(reader.strings("exo:banReasonSummary", new String[0]));
        userProfile.setCreatedDateBan(reader.date("exo:createdDateBan"));
        return userProfile;
    }

    private ForumPrivateMessage getPrivateMessage(Node messageNode) throws Exception {
        ForumPrivateMessage message = new ForumPrivateMessage();
        message.setId(messageNode.getName());
        PropertyReader reader = new PropertyReader(messageNode);
        message.setFrom(reader.string("exo:from"));
        message.setSendTo(reader.string("exo:sendTo"));
        message.setName(reader.string("exo:name"));
        message.setMessage(reader.string("exo:message"));
        message.setReceivedDate(reader.date("exo:receivedDate"));
        message.setIsUnread(reader.bool("exo:isUnread"));
        message.setType(reader.string("exo:type"));
        return message;
    }

    protected void populateCurrentPageList(int page, List list) throws Exception {
        int pageSize = this.getPageSize();
        int position = 0;
        position = page == 1 ? 0 : (page - 1) * pageSize;
        pageSize *= page;
        this.currentListPage_ = new ArrayList();
        for (int i = position; i < pageSize && i < list.size(); ++i) {
            this.currentListPage_.add(list.get(i));
        }
    }

    public List getAll() throws Exception {
        this.currentPage_ = 0;
        this.populateCurrentPage(this.currentPage_);
        this.pageSelected = 0;
        return this.currentListPage_;
    }
}

