/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.jar;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;

public class JarEntryInfo
implements Comparable<JarEntryInfo> {
    private final JarEntry entry;
    private final List<String> names;

    public JarEntryInfo(JarEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        String entryName = entry.getName();
        ArrayList<String> atoms = new ArrayList<String>();
        atoms.add("/");
        int previous = -1;
        while (true) {
            int current;
            if ((current = entryName.indexOf(47, previous + 1)) == -1) {
                current = entryName.length();
            }
            if (current >= entryName.length() - 1) {
                if (current - previous <= 1) break;
                atoms.add(entryName.substring(previous + 1, current));
                break;
            }
            if (current - previous > 1) {
                atoms.add(entryName.substring(previous + 1, current));
            }
            previous = current;
        }
        this.entry = entry;
        this.names = Collections.unmodifiableList(atoms);
    }

    public JarEntry getEntry() {
        return this.entry;
    }

    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    public int size() {
        return this.names.size();
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getName(int index) {
        return this.names.get(index);
    }

    public boolean isChildOf(JarEntryInfo parent) throws IllegalArgumentException {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (!parent.isDirectory()) {
            return false;
        }
        if (parent.size() + 1 != this.names.size()) {
            return false;
        }
        return ((Object)parent.names).equals(parent.names.subList(0, this.names.size() - 1));
    }

    public boolean isDescendantOf(JarEntryInfo ancestor) throws IllegalArgumentException {
        if (ancestor == null) {
            throw new IllegalArgumentException();
        }
        if (!ancestor.isDirectory()) {
            return false;
        }
        if (ancestor.names.size() >= this.names.size()) {
            return false;
        }
        return ((Object)ancestor.names).equals(this.names.subList(0, ancestor.size()));
    }

    public URL toURL(URL jarURL) throws IllegalArgumentException, IllegalStateException, MalformedURLException {
        if (jarURL == null) {
            throw new IllegalArgumentException("No null jarURL");
        }
        if (this.isDirectory()) {
            throw new IllegalStateException("Cannot create dir URL");
        }
        StringBuffer tmp = new StringBuffer(jarURL.toString()).append("!/");
        for (int i = 0; i < this.names.size(); ++i) {
            String atom = this.names.get(i);
            tmp.append(i > 0 ? "/" : "").append(atom);
        }
        return new URL("jar", "", tmp.toString());
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < this.names.size(); ++i) {
            String atom = this.names.get(i);
            tmp.append(i > 0 ? "/" : "").append(atom);
        }
        if (this.entry.isDirectory()) {
            tmp.append("/");
        }
        return tmp.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JarEntryInfo) {
            return this.compareTo((JarEntryInfo)obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(JarEntryInfo obj) {
        JarEntryInfo that = obj;
        Iterator<String> i1 = this.getNames().iterator();
        Iterator<String> i2 = that.getNames().iterator();
        while (i1.hasNext()) {
            String o;
            String s1 = o = i1.next();
            if (i2.hasNext()) {
                String s2 = i2.next();
                int res = s1.compareTo(s2);
                if (res == 0) continue;
                return res;
            }
            return 1;
        }
        if (i2.hasNext()) {
            return -1;
        }
        return 0;
    }
}

