/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl.tika;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParsingReader;
import org.apache.tika.sax.WriteOutContentHandler;
import org.exoplatform.commons.utils.QName;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.document.AdvancedDocumentReader;
import org.exoplatform.services.document.DCMetaData;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.HandlerNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaDocumentReader
implements AdvancedDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.document.impl.tika.TikaDocumentReader");
    private final int MAX_READED_SIZE = 10240;
    private final String mimeType;
    private final Parser parser;

    public TikaDocumentReader(Parser tikaParser, String mimeType) throws HandlerNotFoundException {
        this.parser = tikaParser;
        this.mimeType = mimeType;
    }

    public Reader getContentAsReader(final InputStream is, final String encoding) throws IOException, DocumentReadException {
        try {
            return (Reader)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Reader>(){

                @Override
                public Reader run() throws Exception {
                    Metadata metadata = new Metadata();
                    metadata.set("Content-Type", TikaDocumentReader.this.mimeType);
                    metadata.set("Content-Encoding", encoding);
                    ParseContext context = new ParseContext();
                    context.set(Parser.class, (Object)TikaDocumentReader.this.parser);
                    return new ParsingReader(TikaDocumentReader.this.parser, is, metadata, context);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public Reader getContentAsReader(final InputStream is) throws IOException, DocumentReadException {
        try {
            return (Reader)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Reader>(){

                @Override
                public Reader run() throws Exception {
                    Metadata metadata = new Metadata();
                    metadata.set("Content-Type", TikaDocumentReader.this.mimeType);
                    ParseContext context = new ParseContext();
                    context.set(Parser.class, (Object)TikaDocumentReader.this.parser);
                    return new ParsingReader(TikaDocumentReader.this.parser, is, metadata, context);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public String getContentAsText(final InputStream is) throws IOException, DocumentReadException {
        if (is.available() == 0) {
            return "";
        }
        try {
            return (String)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public String run() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public String getContentAsText(final InputStream is, final String encoding) throws IOException, DocumentReadException {
        if (is.available() == 0) {
            return "";
        }
        try {
            return (String)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public String run() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public String[] getMimeTypes() {
        return new String[]{this.mimeType};
    }

    public Properties getProperties(final InputStream is) throws IOException, DocumentReadException {
        if (is.available() == 0) {
            return new Properties();
        }
        try {
            return (Properties)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Properties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Properties run() throws Exception {
                    try {
                        Metadata metadata = new Metadata();
                        metadata.set("Content-Type", TikaDocumentReader.this.mimeType);
                        WriteOutContentHandler handler = new WriteOutContentHandler(10240);
                        ParseContext context = new ParseContext();
                        context.set(Parser.class, (Object)TikaDocumentReader.this.parser);
                        try {
                            TikaDocumentReader.this.parser.parse(is, (ContentHandler)handler, metadata, context);
                        }
                        catch (SAXException e) {
                            throw new DocumentReadException(e.getMessage(), e);
                        }
                        catch (TikaException e) {
                            throw new DocumentReadException(e.getMessage(), e);
                        }
                        Properties props = new Properties();
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.CONTRIBUTOR, new String[]{"contributor", "Last-Author"});
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.COVERAGE, "coverage");
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.CREATOR, new String[]{"Author", "creator"});
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.DATE, new String[]{"date", "Last-Save-Date", "Creation-Date"});
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.DESCRIPTION, new String[]{"description", "Comments"});
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.FORMAT, "format");
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.IDENTIFIER, "identifier");
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.LANGUAGE, "language");
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.PUBLISHER, "publisher");
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.RELATION, "relation");
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.RESOURCE, "source");
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.RIGHTS, "rights");
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.SUBJECT, new String[]{"subject", "Keywords"});
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.TITLE, "title");
                        TikaDocumentReader.this.convertProperty(metadata, props, DCMetaData.TYPE, "type");
                        Properties properties = props;
                        return properties;
                    }
                    finally {
                        block10: {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                if (!LOG.isTraceEnabled()) break block10;
                                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                            }
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new DocumentReadException("Can not get properties: " + cause.getMessage(), cause);
        }
    }

    private void convertProperty(Metadata metadata, Properties props, QName jcrDCProp, String tikaDCProp) {
        String value = metadata.get(tikaDCProp);
        if (value != null) {
            props.put(jcrDCProp, value);
        }
    }

    private void convertProperty(Metadata metadata, Properties props, QName jcrDCProp, String[] tikaPropertyNames) {
        for (String propertyName : tikaPropertyNames) {
            String value = metadata.get(propertyName);
            if (value == null) continue;
            props.put(jcrDCProp, value);
            return;
        }
    }
}

