/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.AbstractRepositorySuspender;
import org.exoplatform.services.jcr.impl.InspectionLog;
import org.exoplatform.services.jcr.impl.InspectionLogWriter;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainerChecker;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="RepositoryCheckController")})
public class RepositoryCheckController
extends AbstractRepositorySuspender
implements Startable {
    protected static Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositorySuspendController");
    protected static final String FILE_NAME = "report";
    private File inspectionLogFile = null;
    private final ManageableRepository repository;

    public RepositoryCheckController(ManageableRepository repository) {
        super(repository);
        this.repository = repository;
    }

    @Managed
    @ManagedDescription(value="Check repository data consistency. DB data, value storage and lucene index will be checked.")
    public String checkRepositoryDataConsistency() {
        return this.checkRepositoryDataConsistency(new DataStorage[]{DataStorage.DB, DataStorage.VALUE_STORAGE, DataStorage.LUCENE_INDEX});
    }

    @Managed
    @ManagedDescription(value="Check repository database consistency.")
    public String checkRepositoryDataBaseConsistency() {
        return this.checkRepositoryDataConsistency(new DataStorage[]{DataStorage.DB});
    }

    @Managed
    @ManagedDescription(value="Check repository value storage consistency.")
    public String checkRepositoryValueStorageConsistency() {
        return this.checkRepositoryDataConsistency(new DataStorage[]{DataStorage.VALUE_STORAGE});
    }

    @Managed
    @ManagedDescription(value="Check repository search index consistency.")
    public String checkRepositorySearchIndexConsistency() {
        return this.checkRepositoryDataConsistency(new DataStorage[]{DataStorage.LUCENE_INDEX});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String checkRepositoryDataConsistency(DataStorage[] checkData) {
        this.inspectionLogFile = null;
        try {
            block78: {
                block73: {
                    block69: {
                        block77: {
                            block72: {
                                block68: {
                                    block76: {
                                        block71: {
                                            block67: {
                                                block75: {
                                                    block65: {
                                                        block66: {
                                                            if (this.getRepositoryState() == 3) {
                                                                return "Can not check data consistency. Repository is already suspended.";
                                                            }
                                                            reportWriter = null;
                                                            try {
                                                                try {
                                                                    this.suspendRepository();
                                                                }
                                                                catch (RepositoryException e) {
                                                                    var4_7 = "Can not check data consistency. Repository was not suspended. Error: " + e.getMessage();
                                                                    var11_9 = null;
                                                                    if (reportWriter != null) {
                                                                        try {
                                                                            reportWriter.flush();
                                                                            reportWriter.close();
                                                                        }
                                                                        catch (IOException e) {
                                                                            RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                                                        }
                                                                    }
                                                                    try {
                                                                        this.resumeRepository();
                                                                    }
                                                                    catch (RepositoryException e) {
                                                                        RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                                                                    }
                                                                    if (this.getRepositoryState() == 1) return var4_7;
                                                                    RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                                                                    return var4_7;
                                                                }
                                                                this.inspectionLogFile = new File("report-" + this.repository.getConfiguration().getName() + "-" + new SimpleDateFormat("dd-MMM-yy-HH-mm").format(new Date()) + ".txt");
                                                                if (!PrivilegedFileHelper.exists((File)this.inspectionLogFile) && !PrivilegedFileHelper.createNewFile((File)this.inspectionLogFile)) {
                                                                    RepositoryCheckController.LOG.error((Object)("Inspection log file was not created. " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)));
                                                                    e = "Can not check data consistency. Inspection log file was not created. " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                                                                    var11_10 = null;
                                                                    if (reportWriter == null) break block65;
                                                                    break block66;
                                                                }
                                                                reportWriter = new BufferedWriter(new OutputStreamWriter(PrivilegedFileHelper.fileOutputStream((File)this.inspectionLogFile)));
                                                                report = new InspectionLogWriter(reportWriter);
                                                                block46: for (DataStorage cd : checkData) {
                                                                    switch (1.$SwitchMap$org$exoplatform$services$jcr$impl$RepositoryCheckController$DataStorage[cd.ordinal()]) {
                                                                        case 1: {
                                                                            try {
                                                                                this.checkDB(report);
                                                                                continue block46;
                                                                            }
                                                                            catch (RepositoryException e) {
                                                                                report.logException("RepositoryException occures during DB consistency check.", (Exception)e);
                                                                                var9_42 = "RepositoryException occures during DB consistency check. Error: " + e.getMessage() + ". See log here: " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                                                                                var11_11 = null;
                                                                                if (reportWriter != null) {
                                                                                    ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl54:
                                                                                    // 1 sources

                                                                                    reportWriter.flush();
                                                                                    reportWriter.close();
                                                                                    ** GOTO lbl59
lbl57:
                                                                                    // 1 sources

                                                                                    catch (IOException e) {
                                                                                        RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                                                                    }
                                                                                }
lbl59:
                                                                                // 4 sources

                                                                                ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl60:
                                                                                // 1 sources

                                                                                this.resumeRepository();
                                                                                ** GOTO lbl64
lbl62:
                                                                                // 1 sources

                                                                                catch (RepositoryException e) {
                                                                                    RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                                                                                }
lbl64:
                                                                                // 2 sources

                                                                                if (this.getRepositoryState() == 1) return var9_42;
                                                                                RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                                                                                return var9_42;
                                                                            }
                                                                            catch (IOException e) {
                                                                                report.logException("IOException occures during DB consistency check.", e);
                                                                                var9_43 = "IOException occures during DB consistency check. Error: " + e.getMessage() + ". See log here: " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                                                                                var11_12 = null;
                                                                                if (reportWriter != null) {
                                                                                    ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl74:
                                                                                    // 1 sources

                                                                                    reportWriter.flush();
                                                                                    reportWriter.close();
                                                                                    ** GOTO lbl79
lbl77:
                                                                                    // 1 sources

                                                                                    catch (IOException e) {
                                                                                        RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                                                                    }
                                                                                }
lbl79:
                                                                                // 4 sources

                                                                                ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl80:
                                                                                // 1 sources

                                                                                this.resumeRepository();
                                                                                ** GOTO lbl84
lbl82:
                                                                                // 1 sources

                                                                                catch (RepositoryException e) {
                                                                                    RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                                                                                }
lbl84:
                                                                                // 2 sources

                                                                                if (this.getRepositoryState() == 1) return var9_43;
                                                                                RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                                                                                return var9_43;
                                                                            }
                                                                        }
                                                                        case 2: {
                                                                            try {
                                                                                this.checkVS(report);
                                                                                continue block46;
                                                                            }
                                                                            catch (RepositoryException e) {
                                                                                report.logException("RepositoryException occures during ValueStorage consistency check.", (Exception)e);
                                                                                var9_44 = "RepositoryException occures during ValueStorage consistency check. Error: " + e.getMessage() + ". See log here: " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                                                                                var11_13 = null;
                                                                                if (reportWriter != null) {
                                                                                    ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl98:
                                                                                    // 1 sources

                                                                                    reportWriter.flush();
                                                                                    reportWriter.close();
                                                                                    ** GOTO lbl103
lbl101:
                                                                                    // 1 sources

                                                                                    catch (IOException e) {
                                                                                        RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                                                                    }
                                                                                }
lbl103:
                                                                                // 4 sources

                                                                                ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl104:
                                                                                // 1 sources

                                                                                this.resumeRepository();
                                                                                ** GOTO lbl108
lbl106:
                                                                                // 1 sources

                                                                                catch (RepositoryException e) {
                                                                                    RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                                                                                }
lbl108:
                                                                                // 2 sources

                                                                                if (this.getRepositoryState() == 1) return var9_44;
                                                                                RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                                                                                return var9_44;
                                                                            }
                                                                            catch (IOException e) {
                                                                                report.logException("IOException occures during ValueStorage consistency check.", e);
                                                                                var9_45 = "IOException occures during ValueStorage consistency check. Error: " + e.getMessage() + ". See log here: " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                                                                                var11_14 = null;
                                                                                if (reportWriter != null) {
                                                                                    ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl118:
                                                                                    // 1 sources

                                                                                    reportWriter.flush();
                                                                                    reportWriter.close();
                                                                                    ** GOTO lbl123
lbl121:
                                                                                    // 1 sources

                                                                                    catch (IOException e) {
                                                                                        RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                                                                    }
                                                                                }
lbl123:
                                                                                // 4 sources

                                                                                ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl124:
                                                                                // 1 sources

                                                                                this.resumeRepository();
                                                                                ** GOTO lbl128
lbl126:
                                                                                // 1 sources

                                                                                catch (RepositoryException e) {
                                                                                    RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                                                                                }
lbl128:
                                                                                // 2 sources

                                                                                if (this.getRepositoryState() == 1) return var9_45;
                                                                                RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                                                                                return var9_45;
                                                                            }
                                                                        }
                                                                        case 3: {
                                                                            try {
                                                                                this.checkLuceneIndex(report);
                                                                                continue block46;
                                                                            }
                                                                            catch (RepositoryException e) {
                                                                                report.logException("RepositoryException occures during SearchIndex consistency check.", (Exception)e);
                                                                                var9_46 = "RepositoryException occures during SearchIndex consistency check. Error: " + e.getMessage() + ". See log here: " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                                                                                var11_15 = null;
                                                                                if (reportWriter != null) {
                                                                                    ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl142:
                                                                                    // 1 sources

                                                                                    reportWriter.flush();
                                                                                    reportWriter.close();
                                                                                    ** GOTO lbl147
lbl145:
                                                                                    // 1 sources

                                                                                    catch (IOException e) {
                                                                                        RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                                                                    }
                                                                                }
lbl147:
                                                                                // 4 sources

                                                                                ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl148:
                                                                                // 1 sources

                                                                                this.resumeRepository();
                                                                                ** GOTO lbl152
lbl150:
                                                                                // 1 sources

                                                                                catch (RepositoryException e) {
                                                                                    RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                                                                                }
lbl152:
                                                                                // 2 sources

                                                                                if (this.getRepositoryState() == 1) return var9_46;
                                                                                RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                                                                                return var9_46;
                                                                            }
                                                                            catch (IOException e) {
                                                                                report.logException("IOException occures during SearchIndex consistency check.", e);
                                                                                var9_47 = "IOException occures during SearchIndex consistency check. Error: " + e.getMessage() + ". See log here: " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                                                                                var11_16 = null;
                                                                                if (reportWriter != null) {
                                                                                    ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl162:
                                                                                    // 1 sources

                                                                                    reportWriter.flush();
                                                                                    reportWriter.close();
                                                                                    ** GOTO lbl167
lbl165:
                                                                                    // 1 sources

                                                                                    catch (IOException e) {
                                                                                        RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                                                                    }
                                                                                }
lbl167:
                                                                                // 4 sources

                                                                                ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl168:
                                                                                // 1 sources

                                                                                this.resumeRepository();
                                                                                ** GOTO lbl172
lbl170:
                                                                                // 1 sources

                                                                                catch (RepositoryException e) {
                                                                                    RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                                                                                }
lbl172:
                                                                                // 2 sources

                                                                                if (this.getRepositoryState() == 1) return var9_47;
                                                                                RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                                                                                return var9_47;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                if (report.hasInconsistency()) {
                                                                    report.logComment("Repository data is NOT consistent.");
                                                                    var4_8 = "Repository data is inconsistent. See full report by path " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                                                                    break block67;
                                                                }
                                                                if (report.hasWarnings()) {
                                                                    report.logComment("Repository data is consistent, except some warnings.");
                                                                    var4_8 = "Repository data is consistent, except some warnings. See full report by path " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                                                                    break block68;
                                                                }
                                                                report.logComment("Repository data is consistent");
                                                                var4_8 = "Repository data is consistent. See full report by path " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                                                                break block69;
                                                            }
                                                            catch (Throwable var10_48) {
                                                                block74: {
                                                                    block70: {
                                                                        var11_20 = null;
                                                                        if (reportWriter != null) {
                                                                            ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl195:
                                                                            // 1 sources

                                                                            reportWriter.flush();
                                                                            reportWriter.close();
                                                                            break block70;
lbl198:
                                                                            // 1 sources

                                                                            catch (IOException e) {
                                                                                RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                                                            }
                                                                        }
                                                                    }
                                                                    ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl202:
                                                                    // 1 sources

                                                                    this.resumeRepository();
                                                                    break block74;
lbl204:
                                                                    // 1 sources

                                                                    catch (RepositoryException e) {
                                                                        RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                                                                    }
                                                                }
                                                                if (this.getRepositoryState() == 1) throw var10_48;
                                                                RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                                                                throw var10_48;
                                                            }
                                                        }
                                                        ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl212:
                                                        // 1 sources

                                                        reportWriter.flush();
                                                        reportWriter.close();
                                                        break block65;
lbl215:
                                                        // 1 sources

                                                        catch (IOException e) {
                                                            RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                                        }
                                                    }
                                                    ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl219:
                                                    // 1 sources

                                                    this.resumeRepository();
                                                    break block75;
lbl221:
                                                    // 1 sources

                                                    catch (RepositoryException e) {
                                                        RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                                                    }
                                                }
                                                if (this.getRepositoryState() == 1) return e;
                                                RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                                                return e;
                                            }
                                            var11_17 = null;
                                            if (reportWriter != null) {
                                                ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl231:
                                                // 1 sources

                                                reportWriter.flush();
                                                reportWriter.close();
                                                break block71;
lbl234:
                                                // 1 sources

                                                catch (IOException e) {
                                                    RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                                }
                                            }
                                        }
                                        ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl238:
                                        // 1 sources

                                        this.resumeRepository();
                                        break block76;
lbl240:
                                        // 1 sources

                                        catch (RepositoryException e) {
                                            RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                                        }
                                    }
                                    if (this.getRepositoryState() == 1) return var4_8;
                                    RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                                    return var4_8;
                                }
                                var11_18 = null;
                                if (reportWriter != null) {
                                    ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl250:
                                    // 1 sources

                                    reportWriter.flush();
                                    reportWriter.close();
                                    break block72;
lbl253:
                                    // 1 sources

                                    catch (IOException e) {
                                        RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                                    }
                                }
                            }
                            ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl257:
                            // 1 sources

                            this.resumeRepository();
                            break block77;
lbl259:
                            // 1 sources

                            catch (RepositoryException e) {
                                RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                            }
                        }
                        if (this.getRepositoryState() == 1) return var4_8;
                        RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
                        return var4_8;
                    }
                    var11_19 = null;
                    if (reportWriter != null) {
                        ** try [egrp 6[TRYBLOCK] [19 : 837->848)] { 
lbl269:
                        // 1 sources

                        reportWriter.flush();
                        reportWriter.close();
                        break block73;
lbl272:
                        // 1 sources

                        catch (IOException e) {
                            RepositoryCheckController.LOG.error((Object)("Can not close file " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile)), e);
                        }
                    }
                }
                ** try [egrp 7[TRYBLOCK] [20 : 885->892)] { 
lbl276:
                // 1 sources

                this.resumeRepository();
                break block78;
lbl278:
                // 1 sources

                catch (RepositoryException e) {
                    RepositoryCheckController.LOG.error((Object)("Can not resume repository. Error: " + e.getMessage()), e);
                }
            }
            if (this.getRepositoryState() == 1) return var4_8;
            RepositoryCheckController.LOG.error((Object)"Repository was not resumed and now it is OFFLINE");
            return var4_8;
        }
        catch (Throwable e) {
            RepositoryCheckController.LOG.error((Object)e.getMessage(), e);
            v0 = new StringBuilder().append("Exception thrown during repository data validation: ").append(e);
            if (this.inspectionLogFile != null) {
                v1 = " See log by path " + PrivilegedFileHelper.getAbsolutePath((File)this.inspectionLogFile);
                return v0.append(v1).toString();
            }
            v1 = "";
            return v0.append(v1).toString();
        }
    }

    private void checkDB(InspectionLog inspectionLog) throws RepositoryException, IOException, RepositoryConfigurationException {
        String[] wsNames;
        for (String wsName : wsNames = this.repository.getWorkspaceNames()) {
            inspectionLog.logComment("Check DB consistency. Workspace " + wsName);
            JDBCWorkspaceDataContainer dataContainer = (JDBCWorkspaceDataContainer)this.repository.getWorkspaceContainer(wsName).getComponent(JDBCWorkspaceDataContainer.class);
            JDBCWorkspaceDataContainerChecker.checkDB(dataContainer, inspectionLog);
        }
    }

    private void checkVS(InspectionLog inspectionLog) throws RepositoryException, IOException {
        String[] wsNames;
        for (String wsName : wsNames = this.repository.getWorkspaceNames()) {
            inspectionLog.logComment("Check ValueStorage consistency. Workspace " + wsName);
            JDBCWorkspaceDataContainer dataContainer = (JDBCWorkspaceDataContainer)this.repository.getWorkspaceContainer(wsName).getComponent(JDBCWorkspaceDataContainer.class);
            ValueStoragePluginProvider vsPlugin = (ValueStoragePluginProvider)this.repository.getWorkspaceContainer(wsName).getComponent(ValueStoragePluginProvider.class);
            JDBCWorkspaceDataContainerChecker.checkValueStorage(dataContainer, vsPlugin, inspectionLog);
        }
    }

    private void checkLuceneIndex(InspectionLog inspectionLog) throws RepositoryException, IOException {
        String[] wsNames = this.repository.getWorkspaceNames();
        String systemWS = this.repository.getConfiguration().getSystemWorkspaceName();
        for (String wsName : wsNames) {
            inspectionLog.logComment("Check SearchIndex consistency. Workspace " + wsName);
            SearchManager searchManager = (SearchManager)this.repository.getWorkspaceContainer(wsName).getComponent(SearchManager.class);
            searchManager.checkIndex(inspectionLog, systemWS.equals(wsName));
        }
    }

    protected File getLastLogFile() {
        return this.inspectionLogFile;
    }

    public void start() {
    }

    public void stop() {
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$exoplatform$services$jcr$impl$RepositoryCheckController$DataStorage;

        static {
            $SwitchMap$org$exoplatform$services$jcr$impl$RepositoryCheckController$DataStorage = new int[DataStorage.values().length];
            try {
                1.$SwitchMap$org$exoplatform$services$jcr$impl$RepositoryCheckController$DataStorage[DataStorage.DB.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$exoplatform$services$jcr$impl$RepositoryCheckController$DataStorage[DataStorage.VALUE_STORAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$exoplatform$services$jcr$impl$RepositoryCheckController$DataStorage[DataStorage.LUCENE_INDEX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DataStorage {
        DB,
        VALUE_STORAGE,
        LUCENE_INDEX;

    }
}

