/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

@Serialized
public class EmailAddressValidator
implements Validator {
    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        UIComponent uiComponent = (UIComponent)uiInput;
        UIForm uiForm = (UIForm)uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getId() + ".label." + uiInput.getName();
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        Object[] args = new Object[]{label};
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        String s = (String)uiInput.getValue();
        int atIndex = s.indexOf(64);
        if (atIndex == -1) {
            throw new MessageException(new ApplicationMessage("EmailAddressValidator.msg.Invalid-input", args, 1));
        }
        String localPart = s.substring(0, atIndex);
        String domainName = s.substring(atIndex + 1);
        if (!this.validateLocalPart(localPart.toCharArray()) || !this.validateDomainName(domainName.toCharArray())) {
            throw new MessageException(new ApplicationMessage("EmailAddressValidator.msg.Invalid-input", args, 1));
        }
    }

    private boolean validateLocalPart(char[] localPart) {
        if (!this.isAlphabet(localPart[0]) || !this.isAlphabetOrDigit(localPart[localPart.length - 1])) {
            return false;
        }
        for (int i = 1; i < localPart.length - 1; ++i) {
            char c = localPart[i];
            char next = localPart[i + 1];
            if (this.isAlphabetOrDigit(c) || this.isLocalPartSymbol(c) && this.isAlphabetOrDigit(next)) continue;
            return false;
        }
        return true;
    }

    private boolean validateDomainName(char[] domainName) {
        if (!this.isAlphabet(domainName[0]) || !this.isAlphabetOrDigit(domainName[domainName.length - 1])) {
            return false;
        }
        boolean foundValidLastDot = false;
        for (int i = 1; i < domainName.length - 1; ++i) {
            char c = domainName[i];
            char next = domainName[i + 1];
            if (c == '.') {
                foundValidLastDot = true;
            } else if (!this.isAlphabet(c)) {
                foundValidLastDot = false;
            }
            if (this.isAlphabetOrDigit(c) || this.isDomainNameSymbol(c) && this.isAlphabetOrDigit(next)) continue;
            return false;
        }
        return foundValidLastDot;
    }

    private boolean isAlphabet(char c) {
        return c >= 'a' && c <= 'z';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isAlphabetOrDigit(char c) {
        return this.isAlphabet(c) || this.isDigit(c);
    }

    private boolean isLocalPartSymbol(char c) {
        return c == '_' || c == '.';
    }

    private boolean isDomainNameSymbol(char c) {
        return c == '-' || c == '.';
    }
}

