/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLHybrid
extends RowStoreAVL
implements PersistentStore {
    final Session session;
    DataFileCacheSession cache;
    private int maxMemoryRowCount;
    private int memoryRowCount;
    private boolean useCache;
    private boolean isCached;
    private final boolean isTempTable;
    int rowIdSequence = 0;

    public RowStoreAVLHybrid(Session session, PersistentStoreCollection persistentStoreCollection, TableBase tableBase) {
        this(session, persistentStoreCollection, tableBase, true);
        this.cache = session.sessionData.getResultCache();
        if (this.cache != null) {
            this.isCached = true;
        }
    }

    public RowStoreAVLHybrid(Session session, PersistentStoreCollection persistentStoreCollection, TableBase tableBase, boolean bl) {
        this.session = session;
        this.manager = persistentStoreCollection;
        this.table = tableBase;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.isTempTable = tableBase.getTableType() == 3;
        this.useCache = bl;
        if (this.maxMemoryRowCount == 0) {
            this.useCache = false;
        }
        if (tableBase.getTableType() == 9) {
            this.timestamp = session.getActionTimestamp();
        }
        this.resetAccessorKeys(tableBase.getIndexList());
        persistentStoreCollection.setStore(tableBase, this);
    }

    @Override
    public boolean isMemory() {
        return !this.isCached;
    }

    @Override
    public synchronized int getAccessCount() {
        return this.isCached ? this.cache.getAccessCount() : 0;
    }

    @Override
    public void set(CachedObject cachedObject) {
    }

    @Override
    public CachedObject get(int n) {
        try {
            if (this.isCached) {
                return this.cache.get(n, (PersistentStore)this, false);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public CachedObject getKeep(int n) {
        try {
            if (this.isCached) {
                return this.cache.get(n, (PersistentStore)this, true);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public CachedObject get(int n, boolean bl) {
        try {
            if (this.isCached) {
                return this.cache.get(n, (PersistentStore)this, bl);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        try {
            if (this.isCached) {
                return this.cache.get(cachedObject, (PersistentStore)this, bl);
            }
            return cachedObject;
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public int getStorageSize(int n) {
        try {
            if (this.isCached) {
                return this.cache.get(n, (PersistentStore)this, false).getStorageSize();
            }
            return 0;
        }
        catch (HsqlException hsqlException) {
            return 0;
        }
    }

    @Override
    public void add(CachedObject cachedObject) {
        if (this.isCached) {
            int n = cachedObject.getRealSize(this.cache.rowOut);
            n = this.cache.rowOut.getStorageSize(n);
            cachedObject.setStorageSize(n);
            this.cache.add(cachedObject);
        }
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        try {
            if (this.isCached) {
                return new RowAVLDisk(this.table, rowInputInterface);
            }
        }
        catch (HsqlException hsqlException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    @Override
    public CachedObject getNewInstance(int n) {
        return null;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object) {
        int n = this.rowIdSequence++;
        if (this.isCached) {
            RowAVLDisk rowAVLDisk = new RowAVLDisk(this.table, (Object[])object);
            this.add(rowAVLDisk);
            if (this.isTempTable) {
                RowAction.addInsertAction(session, (Table)this.table, rowAVLDisk);
            }
            return rowAVLDisk;
        }
        ++this.memoryRowCount;
        if (this.useCache && this.memoryRowCount > this.maxMemoryRowCount) {
            this.changeToDiskTable();
            return this.getNewCachedObject(session, object);
        }
        RowAVL rowAVL = new RowAVL(this.table, (Object[])object, n);
        if (this.isTempTable) {
            RowAction rowAction;
            rowAVL.rowAction = rowAction = new RowAction(session, this.table, 1, rowAVL, null);
        }
        return rowAVL;
    }

    @Override
    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int n) {
        if (this.isCached) {
            this.cache.remove(n, this);
        }
    }

    @Override
    public void removePersistence(int n) {
    }

    @Override
    public void release(int n) {
        if (this.isCached) {
            this.cache.release(n);
        }
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                row = (Row)this.get(row, true);
                ((RowAVL)row).setNewNodes();
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
        throw Error.runtimeError(201, "RowStoreAVLHybrid");
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        if (this.isCached) {
            --this.cache.storeCount;
            if (this.cache.storeCount == 0) {
                this.cache.clear();
            }
            this.cache = null;
            this.isCached = false;
        }
        this.manager.setStore(this.table, null);
    }

    @Override
    public void setAccessor(Index index, CachedObject cachedObject) {
        Index index2 = index;
        this.accessorList[index2.getPosition()] = cachedObject;
    }

    @Override
    public void setAccessor(Index index, int n) {
    }

    @Override
    public synchronized void resetAccessorKeys(Index[] indexArray) {
        if (this.indexList.length == 0 || this.indexList[0] == null || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        super.resetAccessorKeys(indexArray);
    }

    public void changeToDiskTable() {
        this.cache = this.session.sessionData.getResultCache();
        if (this.cache != null) {
            RowIterator rowIterator = this.table.rowIterator(this);
            ArrayUtil.fillArray(this.accessorList, null);
            this.isCached = true;
            ++this.cache.storeCount;
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                Row row2 = (Row)this.getNewCachedObject(this.session, row.getData());
                this.indexRow(null, row2);
                row.destroy();
            }
        }
        this.maxMemoryRowCount = Integer.MAX_VALUE;
    }
}

