/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.test;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ks.test.ConfigurationUnit;
import org.exoplatform.ks.test.ConfiguredBy;
import org.exoplatform.ks.test.ContainerBuilder;
import org.exoplatform.ks.test.ContainerScope;
import org.testng.annotations.BeforeClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExoContainerTestCase {
    @BeforeClass
    public void startContainer() throws Exception {
        this.beforeContainerStart();
        this.initExoContainer();
        this.afterContainerStart();
    }

    protected void afterContainerStart() {
    }

    protected void beforeContainerStart() {
    }

    private void initExoContainer() throws ClassNotFoundException {
        HashSet<String> rootConfigPaths = new HashSet<String>();
        rootConfigPaths.add("conf/root-configuration.xml");
        HashSet<String> portalConfigPaths = new HashSet<String>();
        portalConfigPaths.add("conf/portal-configuration.xml");
        portalConfigPaths.add("conf/" + this.getClass().getSimpleName() + ".xml");
        EnumMap<ContainerScope, HashSet<String>> configs = new EnumMap<ContainerScope, HashSet<String>>(ContainerScope.class);
        configs.put(ContainerScope.ROOT, rootConfigPaths);
        configs.put(ContainerScope.PORTAL, portalConfigPaths);
        ConfiguredBy cfBy = this.getClass().getAnnotation(ConfiguredBy.class);
        if (cfBy != null) {
            for (ConfigurationUnit src : cfBy.value()) {
                ((Set)configs.get((Object)src.scope())).add(src.path());
            }
        }
        ContainerBuilder builder = new ContainerBuilder();
        Set rootConfs = (Set)configs.get((Object)ContainerScope.ROOT);
        for (String rootConf : rootConfs) {
            builder.withRoot(rootConf);
        }
        Set portalConfs = (Set)configs.get((Object)ContainerScope.PORTAL);
        for (String portalConf : portalConfs) {
            builder.withPortal(portalConf);
        }
        builder.build();
    }

    protected <T, I extends T> void registerComponent(Class<T> key, I instance) {
        ExoContainerContext.getCurrentContainer().registerComponentInstance(key, instance);
    }

    protected <T, U extends T> U getComponent(Class<T> key) {
        PortalContainer container = PortalContainer.getInstance();
        return (U)container.getComponentInstanceOfType(key);
    }

    protected <T, I extends T> void replaceComponent(Class<T> key, I instance) {
        ExoContainerContext.getCurrentContainer().unregisterComponent(key);
        this.registerComponent(key, instance);
    }
}

