/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.test.jcr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ks.test.AbstractExoContainerTestCase;
import org.exoplatform.ks.test.ConfigurationUnit;
import org.exoplatform.ks.test.ConfiguredBy;
import org.exoplatform.ks.test.ContainerScope;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.testng.AssertJUnit;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/jcr/jcr-configuration.xml")})
public abstract class AbstractJCRTestCase
extends AbstractExoContainerTestCase {
    private String tempDir;

    public void beforeContainerStart() {
        this.initTempDir();
    }

    public void initTempDir() {
        this.tempDir = "target/temp" + System.nanoTime() + this.getClass().getCanonicalName();
        System.setProperty("test.tmpdir", this.tempDir);
    }

    ManageableRepository getRepo() {
        try {
            RepositoryService repos = (RepositoryService)this.getComponent(RepositoryService.class);
            ManageableRepository repo = repos.getDefaultRepository();
            return repo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getWorkspace() {
        return this.getRepo().getConfiguration().getDefaultWorkspaceName();
    }

    protected String getRepository() {
        return this.getRepo().getConfiguration().getName();
    }

    protected void assertNodeExists(String path) {
        Session session = null;
        try {
            session = this.getSession();
            boolean exists = session.getRootNode().hasNode(path);
            if (!exists) {
                AssertJUnit.fail((String)("no node exists at " + path));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to assert node exists", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected void assertNodeNotExists(String path) {
        Session session = null;
        try {
            session = this.getSession();
            boolean exists = session.getRootNode().hasNode(path);
            if (exists) {
                AssertJUnit.fail((String)("node exists at " + path));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to assert node exists", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected Node getNode(String path) {
        Session session = null;
        try {
            session = this.getSession();
            Node node = session.getRootNode().getNode(path);
            return node;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load node exists", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected Session getSession() throws Exception {
        try {
            Session session = this.getRepo().getSystemSession(this.getWorkspace());
            return session;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to initiate JCR session on " + this.getWorkspace(), e);
        }
    }

    protected Node addNode(String path) {
        return this.addNode(path, null);
    }

    protected Node addNode(String path, String nodetype) {
        Session session = null;
        try {
            String[] sections;
            session = this.getSession();
            Node parent = session.getRootNode();
            for (String section : sections = path.split("/")) {
                if (section.length() > 0 && !parent.hasNode(section)) {
                    if (nodetype != null && path.endsWith(section)) {
                        parent.addNode(section, nodetype);
                    } else {
                        parent.addNode(section);
                    }
                }
                parent = parent.getNode(section);
            }
            session.save();
            Node node = parent;
            return node;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to add node" + path, e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected Node addFile(String path) {
        Session session = null;
        try {
            String[] sections;
            session = this.getSession();
            Node parent = session.getRootNode();
            for (String section : sections = path.split("/")) {
                if (section.length() > 0 && !parent.hasNode(section)) {
                    if (path.endsWith(section)) {
                        Node ntfile = parent.addNode(section, "nt:file");
                        Node nodeContent = ntfile.addNode("jcr:content", "nt:resource");
                        nodeContent.setProperty("jcr:mimeType", "text/plain");
                        nodeContent.setProperty("jcr:data", (InputStream)new ByteArrayInputStream("stuff".getBytes()));
                        nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
                    } else {
                        parent.addNode(section);
                    }
                }
                parent = parent.getNode(section);
            }
            session.save();
            return parent;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to add node" + path, e);
        }
    }

    protected void deleteNode(String path) {
        Session session = null;
        try {
            session = this.getSession();
            Node parent = session.getRootNode();
            Node target = parent.getNode(path);
            target.remove();
            session.save();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to remove node" + path, e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected void assertPropertyExists(Node node, String property) {
        try {
            AssertJUnit.assertTrue((String)("Node misses property " + property), (boolean)node.hasProperty(property));
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertBinaryPropertyNotEmpty(Node node, String property) {
        this.assertPropertyExists(node, property);
        try {
            String str;
            InputStream is = node.getProperty(property).getStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuffer buff = new StringBuffer();
            while ((str = reader.readLine()) != null) {
                buff.append(str);
            }
            reader.close();
            AssertJUnit.assertTrue((String)("property " + property + " was empty"), (buff.length() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertPropertyEquals(String expected, Node node, String property) {
        try {
            AssertJUnit.assertEquals((String)expected, (String)node.getProperty(property).getString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertPropertyEquals(boolean expected, Node node, String property) {
        try {
            AssertJUnit.assertEquals((boolean)expected, (boolean)node.getProperty(property).getBoolean());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

