/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.ks.forum;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.services.rest.CacheControl;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.webservice.ks.forum.BanIP;
import org.exoplatform.webservice.ks.forum.BeanToJsons;
import org.exoplatform.webservice.ks.forum.MessageBean;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;

public class ForumWebservice
implements ResourceContainer {
    protected static final String JSON_CONTENT_TYPE = "application/json";
    private String strQuery;
    private List<Object> ipsToJson = new ArrayList<Object>();

    @HTTPMethod(value="GET")
    @URITemplate(value="/ks/forum/getmessage/{maxcount}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getMessage(@URIParam(value="maxcount") String maxcount) throws Exception {
        int counter = 0;
        try {
            counter = Integer.parseInt(maxcount);
        }
        catch (Exception e) {
            // empty catch block
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        List list = forumService.getNewPosts(counter);
        ArrayList<Object> lastMessages = new ArrayList<Object>();
        if (!list.isEmpty()) {
            for (Post post : list) {
                lastMessages.add(new MessageBean(post));
            }
        }
        return Response.Builder.ok((Object)new BeanToJsons(lastMessages), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/ks/forum/filter/{strIP}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response filterIps(@URIParam(value="strIP") String str) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals("all")) {
            this.ipsToJson.clear();
            List banIps = forumService.getBanList();
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else if (!str.equals(this.strQuery)) {
            this.ipsToJson.clear();
            List banIps = forumService.getBanList();
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
            this.strQuery = str;
        }
        return Response.Builder.ok((Object)new BeanToJsons(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/ks/forum/filterIpBanforum/{strForumId}/{strIP}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response filterIpBanForum(@URIParam(value="strForumId") String forumId, @URIParam(value="strIP") String str) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals("all")) {
            this.ipsToJson.clear();
            List banIps = forumService.getForumBanList(forumId);
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else if (!str.equals(this.strQuery)) {
            this.ipsToJson.clear();
            List banIps = forumService.getForumBanList(forumId);
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
            this.strQuery = str;
        }
        return Response.Builder.ok((Object)new BeanToJsons(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cacheControl).build();
    }
}

