/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.CacheControl;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.xmpp.bean.ConfigRoomBean;
import org.exoplatform.services.xmpp.bean.FormBean;
import org.exoplatform.services.xmpp.bean.FullRoomInfoBean;
import org.exoplatform.services.xmpp.bean.HostedRoomBean;
import org.exoplatform.services.xmpp.bean.InitInfoBean;
import org.exoplatform.services.xmpp.bean.InterlocutorListBean;
import org.exoplatform.services.xmpp.bean.MessageBean;
import org.exoplatform.services.xmpp.bean.MessageListBean;
import org.exoplatform.services.xmpp.connection.XMPPSession;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.services.xmpp.connection.impl.XMPPSessionImpl;
import org.exoplatform.services.xmpp.ext.transport.AIMTransport;
import org.exoplatform.services.xmpp.ext.transport.GtalkTransport;
import org.exoplatform.services.xmpp.ext.transport.ICQTransport;
import org.exoplatform.services.xmpp.ext.transport.MSNTransport;
import org.exoplatform.services.xmpp.ext.transport.YahooTransport;
import org.exoplatform.services.xmpp.history.HistoricalMessage;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;
import org.exoplatform.services.xmpp.userinfo.UserInfoService;
import org.exoplatform.services.xmpp.util.CheckUtils;
import org.exoplatform.services.xmpp.util.PresenceUtil;
import org.exoplatform.services.xmpp.util.TransformUtils;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;
import org.exoplatform.ws.frameworks.json.transformer.Json2BeanInputTransformer;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTXMPPService
implements ResourceContainer {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private final Log log = ExoLogger.getLogger((String)"lr.RESTXMPPService");
    private final XMPPMessenger messenger;
    private final UserInfoService organization;
    private final ContinuationServiceDelegate delegate;
    private final HistoryImpl history;
    private static final CacheControl cc = new CacheControl();

    public RESTXMPPService(XMPPMessenger messenger, UserInfoService organization, ContinuationServiceDelegate delegate, HistoryImpl history) {
        this.messenger = messenger;
        this.organization = organization;
        this.delegate = delegate;
        this.history = history;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/createroom/{username}/{room}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response createRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @QueryParam(value="nickname") String nickname) {
        if (!CheckUtils.isNodeValide(room)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Room name can't contain these characters: " + CheckUtils.notAllowedCharacters()));
            }
            return Response.Builder.badRequest().errorMessage("Room name can't contain these characters: " + CheckUtils.notAllowedCharacters()).build();
        }
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.createRoom(room, nickname);
                FormBean formBean = session.getConfigFormRoom(room);
                return Response.Builder.ok((Object)formBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (Exception e) {
                e.printStackTrace();
                return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"XMPPSesion is null");
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/muc/configroom/{username}/{room}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response configRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, ConfigRoomBean configRoom) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                if (session.getMultiUserChat(room) != null) {
                    session.configRoom(room, configRoom);
                }
                return Response.Builder.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"XMPPSesion is null");
            }
            return Response.Builder.withStatus((int)500).errorMessage("XMPPSesion is null!").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/getroomconfig/{username}/{room}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRoomConfigForm(@URIParam(value="username") String username, @URIParam(value="room") String room) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                FormBean formBean = session.getConfigFormRoom(room);
                if (formBean != null) {
                    return Response.Builder.ok((Object)formBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/getroominfo/{username}/{room}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRoomInfo(@URIParam(value="username") String username, @URIParam(value="room") String room) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                FullRoomInfoBean infoBean = session.getRoomInfo(room);
                if (infoBean != null) {
                    return Response.Builder.ok((Object)infoBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/joinedrooms/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getJoinedRooms(@URIParam(value="username") String username) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                ArrayList<FullRoomInfoBean> joinedRooms = new ArrayList<FullRoomInfoBean>();
                List<String> list = session.getJoinedRooms();
                for (String room : list) {
                    joinedRooms.add(session.getRoomInfo(room));
                }
                InitInfoBean bean = new InitInfoBean();
                bean.setJoinedRooms(joinedRooms);
                return Response.Builder.ok((Object)bean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/rooms/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getRooms(@URIParam(value="username") String username) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                XMPPConnection connection = session.getConnection();
                Collection collectionMUCService = MultiUserChat.getServiceNames((XMPPConnection)connection);
                String mucService = collectionMUCService.toArray()[0].toString();
                ArrayList<HostedRoomBean> rooms = new ArrayList<HostedRoomBean>();
                Collection hostedRooms = MultiUserChat.getHostedRooms((XMPPConnection)connection, (String)mucService);
                for (HostedRoom hostedRoom : hostedRooms) {
                    HostedRoomBean roomBean = new HostedRoomBean();
                    RoomInfo roomInfo = MultiUserChat.getRoomInfo((XMPPConnection)connection, (String)hostedRoom.getJid());
                    if (roomInfo != null) {
                        roomBean = new HostedRoomBean(roomInfo);
                    }
                    roomBean.setJid(hostedRoom.getJid());
                    roomBean.setName(hostedRoom.getName());
                    rooms.add(roomBean);
                }
                InitInfoBean infoBean = new InitInfoBean();
                infoBean.setHostedRooms(rooms);
                return Response.Builder.ok((Object)infoBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/decline/{username}/{inviter}/{room}/")
    public Response declineToRoom(@URIParam(value="username") String username, @URIParam(value="inviter") String inviter, @URIParam(value="room") String room, @QueryParam(value="reason") String reason) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.declineRoom(room, inviter, reason);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"XMPPSesion is null");
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/destroy/{username}/{room}/")
    public Response destroyRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @QueryParam(value="reason") String reason, @QueryParam(value="altroom") String altRoom) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.destroyRoom(room, reason, altRoom).booleanValue()) {
                    return Response.Builder.ok().cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)400).errorMessage("Chat is null").cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"XMPPSesion is null");
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/invite/{username}/{invitee}/{room}/")
    public Response inviteToRoom(@URIParam(value="username") String username, @URIParam(value="invitee") String invitee, @URIParam(value="room") String room, @QueryParam(value="raeson") String reason) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.inviteToRoom(room, invitee, reason).booleanValue()) {
                    return Response.Builder.ok().cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).cacheControl(cc).errorMessage("XMPPSsession null!").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/join/{username}/{room}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response joinRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @QueryParam(value="nickname") String nickname, @QueryParam(value="password") String password) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.joinRoom(room, nickname, password);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSession is null").cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/leaveroom/{username}/{room}/")
    public Response leftRoom(@URIParam(value="username") String username, @URIParam(value="room") String room) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                if (session.leaveRoom(room).booleanValue()) {
                    return Response.Builder.ok().cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)400).cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSession is null").cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/changenickname/{username}/{room}/{nickname}/")
    public Response changeNickname(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="nickname") String nickname) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.changeNickname(room, nickname);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.withStatus((int)400).errorMessage("XMPPSession is null").cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/changestatus/{username}/{room}/{mode}/")
    public Response changeAvailabilityStatusInRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="mode") String mode, @QueryParam(value="status") String status) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.changeAvailabilityStatusInRoom(room, status, mode);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.notFound().errorMessage("XMPPSession is null").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/changesubject/{username}/{room}/{subject}/")
    public Response changeSubject(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="subject") String subject) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.changeSubject(room, subject);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        return Response.Builder.notFound().errorMessage("XMPPSession is null").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/managerole/{username}/{room}/{nickname}/")
    public Response manageRoleRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="nickname") String nickname, @QueryParam(value="role") String role, @QueryParam(value="command") String command) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.manageRole(room, nickname, role, command);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Sesion is null");
        }
        return Response.Builder.withStatus((int)404).errorMessage("Session is null").cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/manageaffiliation/{username}/{room}/{name}/")
    public Response manageAffilationRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="name") String nickname, @QueryParam(value="affiliation") String affiliation, @QueryParam(value="command") String command) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.manageAffiliation(room, nickname, affiliation, command);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Sesion is null");
        }
        return Response.Builder.withStatus((int)404).errorMessage("Session is null").cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/kick/{username}/{room}/{nickname}/")
    public Response kickUserFromRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="nickname") String nickname, @QueryParam(value="reason") String reason) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.kickUser(room, nickname, reason);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Sesion is null");
        }
        return Response.Builder.withStatus((int)404).errorMessage("Session is null").cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/muc/ban/{username}/{room}/{name}/")
    public Response banUserFromRoom(@URIParam(value="username") String username, @URIParam(value="room") String room, @URIParam(value="name") String nickname, @QueryParam(value="reason") String reason) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            try {
                session.banUser(room, nickname, reason);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            catch (XMPPException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                XMPPError error = e.getXMPPError();
                return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"XMPPSesion is null");
        }
        return Response.Builder.withStatus((int)404).errorMessage("Session is null").cacheControl(cc).build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/addtransport/")
    public Response addTransport(@QueryParam(value="username") String username, @QueryParam(value="remoteusername") String remoteUser, @QueryParam(value="remotepassword") String remotePassword, @QueryParam(value="transport") String transport) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                String serviceName = session.getConnection().getServiceName();
                if (transport.equalsIgnoreCase("yahoo")) {
                    YahooTransport yahooTransport = new YahooTransport(serviceName);
                    session.addTransport(yahooTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("icq")) {
                    ICQTransport icqTransport = new ICQTransport(serviceName);
                    session.addTransport(icqTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("msn")) {
                    MSNTransport msnTransport = new MSNTransport(serviceName);
                    session.addTransport(msnTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("aim")) {
                    AIMTransport aimTransport = new AIMTransport(serviceName);
                    session.addTransport(aimTransport, remoteUser, remotePassword, true);
                } else if (transport.equalsIgnoreCase("gtalk")) {
                    GtalkTransport gtalkTransport = new GtalkTransport(serviceName);
                    session.addTransport(gtalkTransport, remoteUser, remotePassword, true);
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Wrong transport name!");
                }
                return Response.Builder.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"XMPPSesion is null");
            }
            return Response.Builder.withStatus((int)403).errorMessage("XMPPSession is null").build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)400).errorMessage(e.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/add/{username}/{adduser}/")
    public Response addBoddyToRoster(@URIParam(value="username") String username, @URIParam(value="adduser") String adduser, @QueryParam(value="nickname") String nickname, @QueryParam(value="group") String group) {
        XMPPSession session = this.messenger.getSession(username);
        try {
            if (session != null) {
                if (nickname == null) {
                    nickname = adduser;
                }
                session.addBuddy(adduser, nickname, group);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"XMPPSession is null");
            }
            return Response.Builder.withStatus((int)500).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/update/{username}/{upduser}/")
    public Response updateBoddy(@URIParam(value="username") String username, @URIParam(value="upduser") String upduser, @QueryParam(value="nickname") String nickname, @QueryParam(value="group") String group) {
        XMPPSession session = this.messenger.getSession(username);
        try {
            if (session != null) {
                if (nickname == null) {
                    nickname = upduser;
                }
                session.updateBuddy(upduser, nickname, group);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)500).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/group/{username}/{group}/")
    public Response createGroup(@URIParam(value="username") String username, @URIParam(value="group") String group) {
        XMPPSessionImpl session = (XMPPSessionImpl)this.messenger.getSession(username);
        if (session != null) {
            session.createGroup(group);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        return Response.Builder.withStatus((int)500).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/askforsubscription/{username}/{askuser}/")
    public Response askForSubscription(@URIParam(value="username") String username, @URIParam(value="askuser") String askuser, @QueryParam(value="nickname") String nickname) {
        XMPPSession session = this.messenger.getSession(username);
        try {
            if (session != null) {
                if (session.getBuddy(askuser) == null) {
                    return Response.Builder.withStatus((int)400).errorMessage("Not found contact").build();
                }
                if (nickname == null) {
                    nickname = askuser;
                }
                session.askForSubscription(askuser, nickname);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"XMPPSesion is null");
            }
            return Response.Builder.withStatus((int)500).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/rosterclean/{username}/")
    public Response cleanBuddylist(@URIParam(value="username") String username) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.cleanBuddiesList();
                return Response.Builder.ok().cacheControl(cc).build();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"XMPPSesion is null");
            }
            return Response.Builder.withStatus((int)500).errorMessage("XMPPSesion is null").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getmessages/{usernameto}/{usernamefrom}/{isGroupChat}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getAllHistory(@URIParam(value="usernameto") String usernameto, @URIParam(value="usernamefrom") String usernamefrom, @URIParam(value="isGroupChat") Boolean isGroupChat) {
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                list = session.getAllHistory(usernameto, usernamefrom, isGroupChat);
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (!list.isEmpty()) {
                    for (HistoricalMessage historicalMessage : list) {
                        listBean.add(TransformUtils.messageToBean(historicalMessage));
                    }
                }
                return Response.Builder.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getmessages/{usernameto}/{usernamefrom}/{isGroupChat}/{dateformat}/{from}/{to}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getHistoryBetweenDate(@URIParam(value="usernameto") String usernameto, @URIParam(value="usernamefrom") String usernamefrom, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="dateformat") String dateformat, @URIParam(value="from") String from, @URIParam(value="to") String to) {
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
                Date dateFrom = dateFormat.parse(from);
                Date dateTo = dateFormat.parse(to);
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (dateFrom.before(dateTo)) {
                    list = session.getHistoryBetweenDate(usernameto, usernamefrom, isGroupChat, dateFrom, dateTo);
                    if (!list.isEmpty()) {
                        for (HistoricalMessage historicalMessage : list) {
                            listBean.add(TransformUtils.messageToBean(historicalMessage));
                        }
                    }
                    return Response.Builder.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)409).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getmessages/{usernameto}/{usernamefrom}/{isGroupChat}/{dateformat}/{from}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getHistoryFromDateToNow(@URIParam(value="usernameto") String usernameto, @URIParam(value="usernamefrom") String usernamefrom, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="dateformat") String dateformat, @URIParam(value="from") String from) {
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                List<Object> list = new ArrayList();
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
                Date dateFrom = dateFormat.parse(from);
                ArrayList<MessageBean> listBean = new ArrayList<MessageBean>();
                if (dateFrom.before(Calendar.getInstance().getTime())) {
                    list = session.getHistoryFromDateToNow(usernameto, usernamefrom, isGroupChat, dateFrom);
                    if (!list.isEmpty()) {
                        for (HistoricalMessage historicalMessage : list) {
                            listBean.add(TransformUtils.messageToBean(historicalMessage));
                        }
                    }
                    return Response.Builder.ok((Object)new MessageListBean(listBean), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)409).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/getinterlocutors/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getInterlocutors(@URIParam(value="username") String username) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                return Response.Builder.ok((Object)new InterlocutorListBean(session.getInterlocutors(username)), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/file/getmessages/{usernameto}/{usernamefrom}/{isGroupChat}/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getAllHistoryFile(@URIParam(value="usernameto") String usernameto, @URIParam(value="usernamefrom") String usernamefrom, @URIParam(value="isGroupChat") Boolean isGroupChat) {
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                ArrayList<HistoricalMessage> list = new ArrayList();
                list = session.getAllHistory(usernameto, usernamefrom, isGroupChat);
                InputStream inputStream = this.historyBeanToStream(list);
                return Response.Builder.ok((Object)inputStream, (String)DEFAULT_CONTENT_TYPE).header("Content-disposition", "attachment; filename=" + usernameto + "-" + usernamefrom + ".txt").cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/file/getmessages/{usernameto}/{usernamefrom}/{isGroupChat}/{dateformat}/{from}/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getHistoryFromDateToNowFile(@URIParam(value="usernameto") String usernameto, @URIParam(value="usernamefrom") String usernamefrom, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="dateformat") String dateformat, @URIParam(value="from") String from) {
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                ArrayList<HistoricalMessage> list = new ArrayList();
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
                Date dateFrom = dateFormat.parse(from);
                if (dateFrom.before(Calendar.getInstance().getTime())) {
                    list = session.getHistoryFromDateToNow(usernameto, usernamefrom, isGroupChat, dateFrom);
                    InputStream inputStream = this.historyBeanToStream(list);
                    return Response.Builder.ok((Object)inputStream, (String)DEFAULT_CONTENT_TYPE).header("Content-disposition", "attachment; filename=" + usernameto + "-" + usernamefrom + "(" + from + ").txt").cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)409).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/file/getmessages/{usernameto}/{usernamefrom}/{isGroupChat}/{dateformat}/{from}/{to}/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getHistoryBetweenDateFile(@URIParam(value="usernameto") String usernameto, @URIParam(value="usernamefrom") String usernamefrom, @URIParam(value="isGroupChat") Boolean isGroupChat, @URIParam(value="dateformat") String dateformat, @URIParam(value="from") String from, @URIParam(value="to") String to) {
        try {
            XMPPSession session = this.messenger.getSession(usernameto);
            if (session != null) {
                Date dateTo;
                ArrayList<HistoricalMessage> list = new ArrayList();
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateformat);
                Date dateFrom = dateFormat.parse(from);
                if (dateFrom.before(dateTo = dateFormat.parse(to))) {
                    list = session.getHistoryBetweenDate(usernameto, usernamefrom, isGroupChat, dateFrom, dateTo);
                    InputStream inputStream = this.historyBeanToStream(list);
                    return Response.Builder.ok((Object)inputStream, (String)DEFAULT_CONTENT_TYPE).header("Content-disposition", "attachment; filename=" + usernameto + "-" + usernamefrom + "(" + from + "-" + to + ").txt").cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)409).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    private InputStream historyBeanToStream(List<HistoricalMessage> history) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (!history.isEmpty()) {
                for (HistoricalMessage historicalMessage : history) {
                    String buffer = new String();
                    buffer = buffer.concat(StringUtils.parseBareAddress((String)historicalMessage.getFrom()) + "(" + historicalMessage.getDateSend().toString() + ") : " + historicalMessage.getBody() + "\n");
                    outputStream.write(buffer.getBytes());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return inputStream;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/getsearchform/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getSearchUsersForm(@URIParam(value="username") String username, @QueryParam(value="searchservice") String searchService) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                Form form = session.getSearchForm(searchService);
                return Response.Builder.ok((Object)TransformUtils.formToFormBean(form), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).cacheControl(cc).errorMessage("session null!").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/getuserinfo/{username}/{needinfo}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUserInfo(@URIParam(value="username") String username, @URIParam(value="needinfo") String needinfo) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                return Response.Builder.ok((Object)session.getUserInfo(needinfo), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.badRequest().errorMessage(e.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/login2/{forcache}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response login2(@URIParam(value="forcache") String forcache) {
        try {
            ConversationState curentState = ConversationState.getCurrent();
            String username = curentState.getIdentity().getUserId();
            if (this.log.isDebugEnabled()) {
                this.log.info((Object)("Userid for login : " + username));
            }
            String password = this.organization.getOrganizationService().getUserHandler().findUserByName(username).getPassword();
            this.messenger.login(username, password, this.organization, this.delegate, this.history);
            XMPPSession session = this.messenger.getSession(username);
            XMPPConnection connection = session.getConnection();
            String mainServiceName = session.getConnection().getServiceName();
            List<String> services = session.getSearchServices();
            Form form = session.getSearchForm(services.get(0));
            Roster buddyList = session.getConnection().getRoster();
            session.removeAllTransport();
            Collection collectionMUCService = MultiUserChat.getServiceNames((XMPPConnection)connection);
            String mucService = collectionMUCService.toArray()[0].toString();
            Collection hostedRooms = MultiUserChat.getHostedRooms((XMPPConnection)connection, (String)mucService);
            ArrayList<HostedRoomBean> rooms = new ArrayList<HostedRoomBean>();
            for (HostedRoom hostedRoom : hostedRooms) {
                HostedRoomBean roomBean = new HostedRoomBean();
                roomBean.setJid(hostedRoom.getJid());
                roomBean.setName(hostedRoom.getName());
                rooms.add(roomBean);
            }
            InitInfoBean initInfoBean = new InitInfoBean();
            initInfoBean.setForm(TransformUtils.formToFormBean(form));
            initInfoBean.setMainServiceName(mainServiceName);
            initInfoBean.setMucServicesNames(collectionMUCService);
            initInfoBean.setRoster(TransformUtils.rosterToRosterBean(buddyList));
            initInfoBean.setSearchServicesNames(services);
            initInfoBean.setHostedRooms(rooms);
            return Response.Builder.ok((Object)initInfoBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).header("Set-Cookie", "userTicket=" + UUID.randomUUID().toString()).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/logout/{username}/")
    public Response logout(@URIParam(value="username") String _username) {
        try {
            XMPPSession session = this.messenger.getSession(_username);
            if (session != null) {
                session.removeAllTransport();
            }
            this.messenger.logout(_username);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/history/messagereceive/{username}/{messageid}/")
    public Response messageReceive(@URIParam(value="username") String username, @URIParam(value="messageid") String messageId) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.messageReceive(messageId);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)500).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/roster/del/{username}/{removeboddy}/")
    public Response removeBuddy(@URIParam(value="username") String username, @URIParam(value="removeboddy") String removeboddy) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                if (session.removeBuddy(removeboddy)) {
                    return Response.Builder.ok().cacheControl(cc).build();
                }
                return Response.Builder.withStatus((int)404).errorMessage("Buddy not found").build();
            }
            return Response.Builder.withStatus((int)403).errorMessage("Sesion is null").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/removetransport/{username}/{transport}/")
    public Response removeTransport(@URIParam(value="username") String username, @URIParam(value="transport") String _transport) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                String serviceName = session.getConnection().getServiceName();
                if (_transport.equalsIgnoreCase("yahoo")) {
                    YahooTransport yahooTransport = new YahooTransport(serviceName);
                    session.removeTransport(yahooTransport);
                } else if (_transport.equalsIgnoreCase("icq")) {
                    ICQTransport icqTransport = new ICQTransport(serviceName);
                    session.removeTransport(icqTransport);
                } else if (_transport.equalsIgnoreCase("msn")) {
                    MSNTransport msnTransport = new MSNTransport(serviceName);
                    session.removeTransport(msnTransport);
                } else if (_transport.equalsIgnoreCase("aim")) {
                    AIMTransport aimTransport = new AIMTransport(serviceName);
                    session.removeTransport(aimTransport);
                } else if (_transport.equalsIgnoreCase("gtalk")) {
                    GtalkTransport gtalkTransport = new GtalkTransport(serviceName);
                    session.removeTransport(gtalkTransport);
                }
                return Response.Builder.ok().cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).errorMessage("sesion is null").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/searchuser/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response searchUsers(@URIParam(value="username") String username, @QueryParam(value="search") String search, @QueryParam(value="username") Boolean byUsername, @QueryParam(value="name") Boolean byName, @QueryParam(value="email") Boolean byEmail, @QueryParam(value="searchservice") String searchService) {
        try {
            XMPPSession session;
            if (byUsername == null) {
                byUsername = new Boolean(false);
            }
            if (byName == null) {
                byName = new Boolean(false);
            }
            if (byEmail == null) {
                byEmail = new Boolean(false);
            }
            if ((session = this.messenger.getSession(username)) != null) {
                ReportedData reportedData = session.searchUser(search, byUsername, byName, byEmail, searchService);
                return Response.Builder.ok((Object)TransformUtils.reportedSateToSearchResultsBean(reportedData), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)403).errorMessage("session null").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/sendmessage/{username}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response sendMessage(@URIParam(value="username") String username, MessageBean messageBean) {
        try {
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                String from = session.getUsername().split("/")[0];
                Message message = new Message(messageBean.getTo(), Message.Type.chat);
                message.setFrom(from);
                message.setBody(messageBean.getBody());
                session.sendMessage(message);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)400).errorMessage("XMPPSesion is null!").build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/xmpp/muc/sendmessage/{username}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response sendMUCMessage(@URIParam(value="username") String username, MessageBean messageBean) {
        try {
            String room = messageBean.getTo();
            String body = messageBean.getBody();
            XMPPSession session = this.messenger.getSession(username);
            if (session != null) {
                session.sendMessageToMUC(room, body);
                return Response.Builder.ok().cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)500).build();
        }
        catch (XMPPException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            XMPPError error = e.getXMPPError();
            return Response.Builder.withStatus((int)error.getCode()).errorMessage(error.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/sendstatus/{username}/{status}/")
    public Response setUserStatus(@URIParam(value="username") String username, @URIParam(value="status") String status) {
        XMPPSession session = this.messenger.getSession(username);
        Presence presence = PresenceUtil.getPresence(status);
        if (presence == null) {
            return Response.Builder.withStatus((int)403).errorMessage("Get unknow status.").build();
        }
        session.sendPresence(presence);
        return Response.Builder.ok().cacheControl(cc).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/subscribeuser/{username}/{subsuser}/")
    public Response subscribeUser(@URIParam(value="username") String _username, @URIParam(value="subsuser") String _subsuser) {
        XMPPSession session = this.messenger.getSession(_username);
        if (session != null) {
            session.subscribeUser(_subsuser);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("XMPPSession is null").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/unsubscribeuser/{username}/{unsubsuser}/")
    public Response unsubscribeUser(@URIParam(value="username") String username, @URIParam(value="unsubsuser") String unsubsuser) {
        XMPPSession session = this.messenger.getSession(username);
        if (session != null) {
            session.unsubscribeUser(unsubsuser);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Session is null").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/fileexchange/accept/{username}/{uuid}/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response acceptFile(@URIParam(value="username") String username, @URIParam(value="uuid") String uuid) {
        try {
            XMPPSessionImpl session = (XMPPSessionImpl)this.messenger.getSession(username);
            if (session != null) {
                FileTransferRequest request = session.getFileTransferRequest(uuid);
                IncomingFileTransfer fileTransfer = request.accept();
                return Response.Builder.ok((Object)fileTransfer.recieveFile(), (String)DEFAULT_CONTENT_TYPE).header("Content-disposition", "attachment; filename=\"" + fileTransfer.getFileName() + "\"").contentLenght(fileTransfer.getFileSize()).cacheControl(cc).build();
            }
            return Response.Builder.withStatus((int)500).errorMessage("XMPPSession is null").build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Response.Builder.withStatus((int)400).errorMessage(e.getMessage()).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/xmpp/fileexchange/reject/{username}/{uuid}/")
    public Response rejectFile(@URIParam(value="username") String username, @URIParam(value="uuid") String uuid) {
        XMPPSessionImpl session = (XMPPSessionImpl)this.messenger.getSession(username);
        if (session != null) {
            session.rejectFile(uuid);
            return Response.Builder.ok().cacheControl(cc).build();
        }
        return Response.Builder.withStatus((int)500).errorMessage("Session is null").build();
    }

    static {
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

