/**
 * @author uocnguyen
 */
function UIAddContactPopupWindow() {
  this.handler = false;
}

UIAddContactPopupWindow.prototype.init = function(rootNode, UIMainChatWindow) {
  var DOMUtil = eXo.core.DOMUtil;
  this.rootNode = rootNode;
  this.UIMainChatWindow = UIMainChatWindow;
  var tmpNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'table', 'UIGrid');
  this.contactListContainerNode = tmpNode.getElementsByTagName('tbody')[0];
  this.toggleSelectAllNode = DOMUtil.findFirstDescendantByClass(tmpNode, 'input', 'ToggleSelect');
  this.LocalTemplateEngine = this.UIMainChatWindow.LocalTemplateEngine;
  this.filterFieldNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'input', 'SearchField');
  this.addContactButtonNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'a', 'AddContactButton');
  var doSearchContactWrapper = function() {
    eXo.communication.chat.webui.UIAddContactPopupWindow.doSearchContact();
  }
  if (window.addEventListener) {
    this.filterFieldNode.addEventListener('keyup', doSearchContactWrapper, false);
  } else {
    this.filterFieldNode.attachEvent('onkeyup', doSearchContactWrapper, false);
  }
};

UIAddContactPopupWindow.prototype.doSearchContact = function() {
  eXo.communication.chat.webui.UIMainChatWindow.orgFuzzySearchUser(this.filterFieldNode.value + '*', 0, 10);
  //eXo.communication.chat.webui.UIMainChatWindow.orgSearchUser(this.filterFieldNode.value);
};

UIAddContactPopupWindow.prototype.updateContactList = function(contactList) {
  if (!this.contactListContainerNode) {
    return;
  }
  this.contactListContainerNode.innerHTML = '<tr style="height: 0px;"></tr>';
  var currentActiveUser = eXo.communication.chat.webui.UIMainChatWindow.userNames['xmpp'];
  for (var i=0; i<contactList.length; i++) {
    var contact = contactList[i];
    contact.enabled4Add = true;
    if (currentActiveUser == contact['userName']) {
      continue;
    }
    if (this.handler &&
        this.handler.contactUpdateFilter) {
      this.handler.contactUpdateFilter(contact);
    }
    this.contactListContainerNode.appendChild(this.createContactNode(contact));
  }
};

/**
 * This filter will used default for main buddy list.
 * @param {Object} contact
 */
UIAddContactPopupWindow.prototype.filter4MainBuddyList = function(contact) {
  var currentContactList = eXo.communication.chat.webui.UIMainChatWindow.buddyListControlObj.buddyList || [];
  for (var contactId in currentContactList) {
    var contactInfo = currentContactList[contactId];
    if (!(contactInfo instanceof Object) ||
        !contactInfo.buddyInfo) {
      continue;
    }
    var userName = contactInfo.buddyInfo.user;
    var shortUserName = userName.substring(0, userName.indexOf('@'));
    if (shortUserName == contact['userName'] ||
        userName == contact['userName']) {
      contact.enabled4Add = false;
      break;
    }
  }
  return contact;
};

/**
 * 
 * @param {Object} contactInfo
 */
UIAddContactPopupWindow.prototype.createContactNode = function(contactInfo) {
  var DOMUtil = eXo.core.DOMUtil;
  var uiContactRowNode = document.createElement('tr');
  uiContactRowNode.className = 'UIContactRow';
  var tdTmpNode = document.createElement('td');
  
  var selectBoxNode = document.createElement('input');
  selectBoxNode.type = 'checkbox';
  selectBoxNode.className = 'CheckBox';
  if (!contactInfo.enabled4Add) {
    selectBoxNode.disabled = 'true';
    selectBoxNode.checked = 'true';
  }
  selectBoxNode.name = contactInfo['userName'];
  tdTmpNode.appendChild(selectBoxNode);
  uiContactRowNode.appendChild(tdTmpNode.cloneNode(true));
  
  tdTmpNode.innerHTML = '<span/>';
  
  tdTmpNode.innerHTML = contactInfo['firstName'];
  uiContactRowNode.appendChild(tdTmpNode.cloneNode(true));
  tdTmpNode.innerHTML = contactInfo['lastName'];
  uiContactRowNode.appendChild(tdTmpNode.cloneNode(true));
  tdTmpNode.innerHTML = contactInfo['userName'];
  uiContactRowNode.appendChild(tdTmpNode.cloneNode(true));
  
  return uiContactRowNode;
};

UIAddContactPopupWindow.prototype.addContactAction = function() {
  var DOMUtil = eXo.core.DOMUtil;
  var uiGridNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'table', 'UIGrid');
  var contactNodeList = DOMUtil.findDescendantsByClass(uiGridNode, 'input', 'CheckBox');
  var contactList = [];
  for (var i=0; i<contactNodeList.length; i++) {
    if (contactNodeList[i].checked && contactNodeList[i].name) {
      contactList.push(contactNodeList[i].name);
    }
  }
  if (this.handler &&
      this.handler.addContactActionCallback) {
    this.handler.addContactActionCallback(contactList);
  } else {
    eXo.communication.chat.webui.UIMainChatWindow.addContacts(contactList);
  }
  this.setVisible(false);
};

UIAddContactPopupWindow.prototype.toggleSelectAllContact = function() {
  var DOMUtil = eXo.core.DOMUtil;
  var uiGridNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'table', 'UIGrid');
  var selectMode = false;
  if (!uiGridNode.getAttribute('select') ||
      uiGridNode.getAttribute('select') == 'none') {
    selectMode = true;
  }
  
  var checkboxList = DOMUtil.findDescendantsByClass(this.contactListContainerNode, 'input', 'CheckBox');
  for (var i=0; i<checkboxList.length; i++) {
    var checkBoxTmp = checkboxList[i];
    if (!checkBoxTmp.disabled) {
      checkBoxTmp.checked = selectMode;
    }
  }
  if (selectMode) {
    uiGridNode.setAttribute('select', 'all');
  } else {
    uiGridNode.setAttribute('select', 'none');
  }
};

UIAddContactPopupWindow.prototype.setVisible = function(visible, handler){
  if (visible) {
    eXo.communication.chat.webui.UIMainChatWindow.orgSearchUser();
    this.filterFieldNode.value = '';
    this.toggleSelectAllNode.checked = false;
    if (this.rootNode.style.display != 'block') {
      this.rootNode.style.display = 'block';
    }
    this.filterFieldNode.focus();
    this.handler = handler;
  } else {
    if (this.rootNode.style.display != 'none') {
      this.rootNode.style.display = 'none';
    }
    this.handler = null;
  }
};

eXo.communication.chat.webui.UIAddContactPopupWindow = new UIAddContactPopupWindow();
