/**
 * @author Uoc Nguyen
 */

/**
 *
 * @param {Object} tabId
 */
function UITabControl(tabId, isGroupChat, UIMainChatWindow) {
  this.MAX_TAB_TITLE_LEN = 25;
  this.MAX_MSG_TITLE_LEN = 30;
  this.CSS_CLASS = {
    uiTab : 'ChatTab',
    tabName : 'TabName',
    closeTabButton : 'CloseTabButton',
    uiTabContent : 'ChatTabContent',
    uiGroupChatTabContent : 'GroupChatTabContent',
    chatSession : 'ChatSession',
    messagesContainer : 'MessagesContainer',
    userMessage : 'UserMessage',
    guestMessage : 'GuestMessage',
    chatIconStatus : 'IconStatus ChatIcon',
    chatTime : 'CenterTime',
    contextChat : 'ContextChat',
    messageBox : 'MsgBox',
    sendMessageButton : 'SendButton',
    nicksGroupChat : 'NicksGroupChat'
  }
  this.UIMainChatWindow = UIMainChatWindow;
  this.localTemplateEngine = eXo.communication.chat.core.LocalTemplateEngine;
  this.tabId = tabId;
  this.isGroupChat = isGroupChat;
  this.initUI();
  if (this.isGroupChat) {
    this.buddyListControlObj = new eXo.communication.chat.webui.component.BuddyListControl(
                                this.buddyListNode, this.buddyItemActionCallback, this.UIMainChatWindow);
  }
};

UITabControl.prototype.buddyItemActionCallback = function(event) {
  event = event || window.event;
  console.warn('menu action and click action processing');
};

// ===== Functions below available only for when isGrouChat is true
UITabControl.prototype.updateBuddyList = function(roster, isUsingXMethod) {
  if (!this.isGroupChat) return;
  var mainServiceName = eXo.communication.chat.webui.UIMainChatWindow.serverInfo.mainServiceName;
  if (isUsingXMethod) {
    console.warn('###################################');
    console.warn('X method used');
    console.warn('###################################');
    this.buddyListControlObj.xUpdate(roster);
  } else {
    this.buddyListControlObj.update(roster);
  }
};

UITabControl.prototype.updateRoster = function(user4Remove) {
  if (!this.isGroupChat) return;
  console.warn('Remove ' + user4Remove + ' from buddy list.');
  this.buddyListControlObj.removeBuddy(user4Remove);
};

UITabControl.prototype.inviteToJoinRoom = function() {
  eXo.communication.chat.webui.UIAddContactPopupWindow.setVisible(true, this);
};

UITabControl.prototype.contactUpdateFilter = function(contact) {
  // TODO: implement contact update filter for group chat contact list
};

UITabControl.prototype.addContactActionCallback = function(contactList) {
  var UIMainChatWindow = eXo.communication.chat.webui.UIMainChatWindow;
  var roomName = this.tabId.targetPerson;
  roomName = roomName.substr(0, roomName.indexOf('@'));
  for (var i=0; i<contactList.length; i++) {
    UIMainChatWindow.jabberInviteJoinRoom(contactList[i], roomName);
  }
};
// =/= 
UITabControl.prototype.initUI = function(buddyId) {
  var DOMUtil = eXo.core.DOMUtil;
  this.uiTabNode = this.localTemplateEngine.getTemplateByClassName(this.CSS_CLASS.uiTab);
  // Customize new UITab node
  var tabNameNode = DOMUtil.findFirstDescendantByClass(this.uiTabNode, 'div', this.CSS_CLASS.tabName);
  if (this.tabId.targetPerson.length > this.MAX_TAB_TITLE_LEN) {
    tabNameNode.innerHTML = this.tabId.targetPerson.substr(0, this.MAX_TAB_TITLE_LEN - 3) + '...';
  } else {
    tabNameNode.innerHTML = this.tabId.targetPerson;
  }
  tabNameNode.setAttribute('tabcontentid', this.tabId.id);
  tabNameNode.className = tabNameNode.className + ' ' + this.tabId.id;
  tabNameNode.onclick = this.focusTabWrapper;
  this.uiTabNode.style.display = 'block';

  var closeTabButtonNode = DOMUtil.findFirstDescendantByClass(this.uiTabNode, 'div', this.CSS_CLASS.closeTabButton);
  closeTabButtonNode.onclick = this.closeTabWrapper;

  var tabContentCSSClass = this.CSS_CLASS.uiTabContent;
  if (this.isGroupChat) {
    tabContentCSSClass = this.CSS_CLASS.uiGroupChatTabContent;
  }
  this.uiTabContentNode = this.localTemplateEngine.getTemplateByClassName(tabContentCSSClass);
  // Customize new UITabContent node
  var chatSessionNode = DOMUtil.findFirstDescendantByClass(this.uiTabContentNode, 'div', this.CSS_CLASS.chatSession);
  chatSessionNode.className = chatSessionNode.className + ' ' + this.tabId.id;
  var msgBoxNode = DOMUtil.findFirstDescendantByClass(this.uiTabContentNode, 'textarea', this.CSS_CLASS.messageBox);
  msgBoxNode.onkeypress = this.msgBoxKBHandler;
  this.msgTypingBox = msgBoxNode;
  var sendButtonNode = DOMUtil.findFirstDescendantByClass(this.uiTabContentNode, 'div', this.CSS_CLASS.sendMessageButton);
  sendButtonNode.onclick = this.sendMessageWrapper;
  this.uiTabContentNode.style.display = 'block';
  this.messageBoxNode = DOMUtil.findFirstDescendantByClass(this.uiTabContentNode, 'div', this.CSS_CLASS.messagesContainer);
  
  this.buddyListNode = DOMUtil.findFirstDescendantByClass(this.uiTabContentNode, 'div', this.CSS_CLASS.nicksGroupChat);
}

UITabControl.prototype.writeMsg = function(buddyId ,msg) {
  var buddyIdTmp = buddyId;
  if (this.isGroupChat &&
      buddyId.indexOf('/') != -1 &&
      buddyId.substr(buddyId.lastIndexOf('/') + 1, buddyId.length) == this.tabId.owner) {
    return;
  }
  var DOMUtil = eXo.core.DOMUtil;
  var msgNode = this.lastMsgNode;
  if (buddyId.indexOf('/') != -1) {
    if (this.isGroupChat) {
      buddyIdTmp = buddyId.substr(buddyId.lastIndexOf('/') + 1, buddyId.length);
      buddyId = buddyIdTmp;
    } else {
      buddyIdTmp = buddyId.substr(0, buddyId.indexOf('/'));
    }
  }
  if (buddyIdTmp.indexOf('@') != -1) {
    buddyIdTmp = buddyIdTmp.substr(0, buddyIdTmp.indexOf('@'));
  }
  if (this.lastBuddyId != buddyIdTmp) {
    msgNode = this.createNewMsgNode(buddyIdTmp);
      
    var msgTitleNode = DOMUtil.findFirstDescendantByClass(msgNode, 'div', this.CSS_CLASS.chatIconStatus);
    if (buddyIdTmp.length > this.MAX_MSG_TITLE_LEN) {
      msgTitleNode.innerHTML = buddyIdTmp.substr(0, this.MAX_MSG_TITLE_LEN - 3) + '...';
    } else {
      msgTitleNode.innerHTML = buddyIdTmp;
    }
    
    var chatTimeNode = DOMUtil.findFirstDescendantByClass(msgNode, 'div', this.CSS_CLASS.chatTime);
    var timeStamp = msg['dataSend'];
    if (!timeStamp) {
      timeStamp = (new Date()).toLocaleTimeString();
    }
    chatTimeNode.innerHTML = timeStamp;
    
    this.messageBoxNode.appendChild(msgNode);
  }
  var contextChatNode = DOMUtil.findFirstDescendantByClass(msgNode, 'div', this.CSS_CLASS.contextChat);
  var msgTmpNode = document.createElement('div');
  msgTmpNode.innerHTML = eXo.core.HTMLUtil.entitiesEncode(msg);


  contextChatNode.appendChild(msgTmpNode);

  var max = this.messageBoxNode.scrollHeight - this.messageBoxNode.offsetHeight;
  this.scrollMessageBox();
  this.lastBuddyId = buddyIdTmp;
  this.lastMsgNode = msgNode;
};

UITabControl.prototype.scrollMessageBox = function() {
  this.messageBoxNode.scrollTop = this.messageBoxNode.scrollHeight - this.messageBoxNode.offsetHeight;
};

UITabControl.prototype.createNewMsgNode = function(buddyId) {
  var DOMUtil = eXo.core.DOMUtil;
  var messageNode = false;
  if (buddyId == this.tabId.owner) {
    messageNode = this.localTemplateEngine.getTemplateByClassName(this.CSS_CLASS.userMessage);
  } else {
    messageNode = this.localTemplateEngine.getTemplateByClassName(this.CSS_CLASS.guestMessage);
  }
  return messageNode;
};

/**
 * This method will do: become keyboard handler for input text box
 * @param {Event} event
 */
UITabControl.prototype.msgBoxKBHandler = function(event) {
  event = event ? event : window.event;
  if (event.keyCode == 13) {
    eXo.communication.chat.webui.UIChatWindow.sendMsgFromActiveTab();
    return false;
  }
  return true;
};

/**
 *
 * @param {Object} event
 */
UITabControl.prototype.sendMessageWrapper = function(event) {
  eXo.communication.chat.webui.UIChatWindow.sendMsgFromActiveTab();
};

UITabControl.prototype.sendMessage = function() {
  this.writeMsg(this.tabId.owner, this.msgTypingBox.value);
  this.msgTypingBox.value = '';
};

UITabControl.prototype.focusTabWrapper = function() {
  return eXo.communication.chat.webui.UIChatWindow.focusTab(this.getAttribute('tabcontentid'), true);
};

UITabControl.prototype.closeTabWrapper = function() {
  var tabNameNode = eXo.core.DOMUtil.findPreviousElementByTagName(this, 'div');
  if (tabNameNode) {
    return eXo.communication.chat.webui.UIChatWindow.closeTab(tabNameNode.getAttribute('tabcontentid'));
  }
};

UITabControl.prototype.setVisible = function(visible) {
  var DOMUtil = eXo.core.DOMUtil;
  if (visible) {
    var normalTabNode = DOMUtil.findFirstDescendantByClass(this.uiTabNode, 'div', 'NormalTab');
    if (normalTabNode) {
      normalTabNode.className = 'SelectedTab';
    }
    if (this.uiTabContentNode.style.display != 'block') {
      this.uiTabContentNode.style.display = 'block';
    }
    this.scrollMessageBox();
  } else {
    var selectedTabNode = DOMUtil.findFirstDescendantByClass(this.uiTabNode, 'div', 'SelectedTab');
    if (selectedTabNode) {
      selectedTabNode.className = 'NormalTab';
    }
    if (this.uiTabContentNode.style.display != 'none') {
      this.uiTabContentNode.style.display = 'none';
    }
  }
};

/**
 * 
 */
function UIChatWindow() {
  this.flags = {debug: false};
  this.UIMainChatWindow = eXo.communication.chat.webui.UIMainChatWindow;
  this.LocalTemplateEngine = eXo.communication.chat.core.LocalTemplateEngine;
}

UIChatWindow.prototype.init = function(rootNode, UIMainChatWindow) {
  this.rootNode = rootNode;
  this.UIMainChatWindow = UIMainChatWindow;
//  var cloneNodeObject = this.rootNode.cloneNode(true);
//  document.body.appendChild(cloneNodeObject);
//  eXo.core.DOMUtil.removeElement(this.rootNode);
//  this.rootNode = cloneNodeObject;
  var resizeArea = eXo.core.DOMUtil.findFirstDescendantByClass(this.rootNode, "div", "ResizeArea") ;
  resizeArea.onmousedown = eXo.desktop.UIWindow.startResizeWindowEvt;
};

UIChatWindow.prototype.initSession = function() {
  if(!this.tabControlList) {
    this.tabControlList = new Object();
    this.UIMainChatWindow = eXo.communication.chat.webui.UIMainChatWindow;
    var DOMUtil = eXo.core.DOMUtil;
    this.tabsContainerNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'TabsContainer');
    this.uiTabContentContainerNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'div', 'UITabContentContainer');
  }
  this.owner = this.UIMainChatWindow.userNames[eXo.communication.chat.core.XMPPCommunicator.TRANSPORT_XMPP]; 
};

UIChatWindow.prototype.destroySession = function() {
  this.tabsContainerNode.innerHTML = '';
  this.uiTabContentContainerNode.innerHTML = '';
  this.tabControlList = null;
  this.rootNode.style.display = 'none';
};

UIChatWindow.prototype.destroy = function() {};

UIChatWindow.prototype.createNewTab = function(targetPerson, isGroupChat) {
  var tabId = this.getTabId(targetPerson);
  this.getUITabControl(tabId, isGroupChat);
  if (this.rootNode.style.display != 'block') {
    this.rootNode.style.display = 'block';
  }
  this.focusTab(tabId.id, true);
};

UIChatWindow.prototype.updateRoster = function(userName, roomName) {
  var uiTabControl = this.tabControlList[this.getTabId(roomName).id];
  if (uiTabControl) {
    uiTabControl.updateRoster(userName);
  }
};

UIChatWindow.prototype.updatePresence = function(presences, isUsingXMethod) {
  for (var item in this.tabControlList) {
    var uiTabControl = this.tabControlList[item];
    if (uiTabControl &&
        uiTabControl instanceof UITabControl) {
      uiTabControl.updateBuddyList(presences, isUsingXMethod);
    }
  }
};

/**
 *
 * @param {String} targetPerson
 * @param {String} msg
 */
UIChatWindow.prototype.displayMessage = function(targetPerson, msg, isGroupChat) {
  if (this.rootNode.style.display == 'none') {
    this.rootNode.style.display = 'block';
  }
  var tabId = this.getTabId(targetPerson);
  var uiTabControlObj = this.getUITabControl(tabId, isGroupChat);
  if (msg) {
    uiTabControlObj.writeMsg(targetPerson, msg);
  }
  if (!msg || !this.activeTabId) {
    this.focusTab(tabId.id, true);
  }
};

/**
 *
 * @param {String} targetPerson
 */
UIChatWindow.prototype.getTabId = function(targetPerson) {
  if (targetPerson.indexOf('/') != -1) {
    targetPerson = targetPerson.substring(0, targetPerson.indexOf('/'));
  }
  var owner = this.owner;
  var targetPerson = targetPerson;
  return {owner : owner, targetPerson : targetPerson, id : ((owner + '_' + targetPerson).toLowerCase())};
};

/**
 *
 * @param {Object} tabId
 *
 * @return {UITabControl}
 */
UIChatWindow.prototype.getUITabControl = function(tabId, isGroupChat) {
  if (!tabId.owner) {
    if (this.flags['debug']) {
      console.error('Get UITabControl object with invalid tabId');
    }
    return null;
  }
  var uiTabControlObj = this.tabControlList[tabId.id];

  if (!(uiTabControlObj instanceof UITabControl)) {
    uiTabControlObj = new UITabControl(tabId, isGroupChat, this.UIMainChatWindow);
    this.tabsContainerNode.appendChild(uiTabControlObj.uiTabNode);
    this.uiTabContentContainerNode.appendChild(uiTabControlObj.uiTabContentNode);
    this.tabControlList[tabId.id] = uiTabControlObj;
    if (this.activeTabId) {
      this.focusTab(this.activeTabId, true);
    } else {
      this.focusTab(tabId.id, true);
    }
  }
  return uiTabControlObj;
};

/**
 *
 * @param {String} id
 */
UIChatWindow.prototype.focusTab = function(id, alsoFocusTextbox) {
  // Focus new Tab
  var targetTab = false;
  for (var item in this.tabControlList) {
    if (this.tabControlList[item] instanceof UITabControl) {
      if (item != id) {
        this.tabControlList[item].setVisible(false);
      } else {
        targetTab = this.tabControlList[item];
      }
    }
  }
  if (targetTab) {
    targetTab.setVisible(true);
    if (this.rootNode.style.display != 'block') {
      this.rootNode.style.display = 'block';
    }
    this.activeTabId = targetTab.tabId.id;
    if (alsoFocusTextbox) {
      targetTab.msgTypingBox.focus();
    }
  }
};

/**
 *
 * @param {String} id
 */
UIChatWindow.prototype.closeTab = function(id) {
  var previousTabId = false;
  var tabRemoved = false;
  var cnt = 0;
  for (var item in this.tabControlList) {
    var uiTabObj = this.tabControlList[item];
    if (uiTabObj instanceof UITabControl) {
      if (item == id) {
        eXo.core.DOMUtil.removeElement(uiTabObj.uiTabNode);
        eXo.core.DOMUtil.removeElement(uiTabObj.uiTabContentNode);
        this.tabControlList[id] = null;
        tabRemoved = true;
        continue;
      }
      if (cnt > 0 && previousTabId && tabRemoved) {
        break;
      }
      previousTabId = item;
      cnt ++;
    }
  }
  // Focus previousTab if exist
  if (this.tabControlList[previousTabId]) {
    this.focusTab(previousTabId);
  } else {
    // Hide Tabed Window when no tab remain
    this.rootNode.style.display = 'none';
  }
};

UIChatWindow.prototype.closeWindow = function() {
  this.rootNode.style.display = 'none';
};

UIChatWindow.prototype.sendMsgFromActiveTab = function() {
  var activeTabControl = this.tabControlList[this.activeTabId];
  if (activeTabControl instanceof UITabControl) {
    if (activeTabControl.isGroupChat) {
      this.UIMainChatWindow.jabberSendRoomMessage(activeTabControl.tabId.targetPerson, activeTabControl.msgTypingBox.value);
    } else {
      this.UIMainChatWindow.jabberSendMessage(activeTabControl.tabId.targetPerson, activeTabControl.msgTypingBox.value);
    }
    activeTabControl.sendMessage();
  }
};

UIChatWindow.prototype.inviteToJoinRoom = function() {
  var activeTabControl = this.tabControlList[this.activeTabId];
  if (activeTabControl instanceof UITabControl) {
    activeTabControl.inviteToJoinRoom();
  }
};

UIChatWindow.prototype.leaveRoomChat = function() {
  var activeTabControl = this.tabControlList[this.activeTabId];
  if (activeTabControl instanceof UITabControl) {
    var roomName = activeTabControl.tabId.targetPerson;
    roomName = roomName.substr(0, roomName.indexOf('@'));
    this.UIMainChatWindow.jabberLeaveFromRoom(roomName);
    this.closeTab(activeTabControl.tabId.id);
  }
};

eXo.communication.chat.webui.UIChatWindow = new UIChatWindow();
