/**
 * @author Uoc Nguyen Ba
 */
function UICreateNewRoomPopupWindow() {
}

UICreateNewRoomPopupWindow.prototype.init = function(rootNode, UIMainChatWindow) {
  this.rootNode = rootNode;
  this.UIMainChatWindow = UIMainChatWindow;
  var fieldList = this.rootNode.getElementsByTagName('input');
  for (var i=0; i<fieldList.length; i++) {
    if (fieldList[i].name == 'roomName') {
      this.roomNameField = fieldList[i];
      continue;
    }
    if (fieldList[i].name == 'roomDesc') {
      this.roomDescField = fieldList[i];
      continue;
    }
  }
};

UICreateNewRoomPopupWindow.prototype.setVisible = function(visible) {
  if (this.UIMainChatWindow.userStatus == this.UIMainChatWindow.OFFLINE_STATUS) {
    return;
  }
  if (visible) {
    if (this.rootNode.style.display != 'block') {
      this.rootNode.style.display = 'block'; 
    }
    this.roomNameField.focus();
  } else {
    if (this.rootNode.style.display != 'none') {
      this.rootNode.style.display = 'none'; 
    }
    this.roomNameField.value = '';
    this.roomDescField.value = '';
  }
};

UICreateNewRoomPopupWindow.prototype.createNewRoomAction = function() {
  var roomName = this.roomNameField.value;
  var roomDesc = this.roomDescField.value;
  this.setVisible(false);
  
  this.UIMainChatWindow.createRoomChat({name:roomName, desc:roomDesc});
};

eXo.communication.chat.webui.UICreateNewRoomPopupWindow = new UICreateNewRoomPopupWindow();
