/**
 * @author uocnguyen
 */
function BuddyItem(buddyInfo, actionCallback) {
  this.buddyInfo = buddyInfo;
  this.actionCallback = actionCallback;
  this.flags = {debug: false};
  this.CSS_CLASS = {
    unavailable : 'OfflineIcon',
    available   : 'OnlineIcon',
    away        : 'AwayIcon',
    chat        : 'FreeToChat',
    busy        : 'ExtendsAwayIcon',
    dnd         : 'ExtendsAwayIcon'
  };
  
  this.init();
  this.updateStatus(buddyInfo.presence.type, true);
}

BuddyItem.prototype.init = function() {
  var DOMUtil = eXo.core.DOMUtil;
  this.rootNode = eXo.communication.chat.core.LocalTemplateEngine.getTemplateByClassName('TitleIconChat');

  this.iconChatNode = DOMUtil.findFirstDescendantByClass(this.rootNode, 'a', 'IconChat');
  this.updateStatus(this.buddyInfo.presence.type);

  this.iconChatNode.innerHTML = this.getUserName(this.buddyInfo.user);

  this.rootNode.setAttribute('userName', this.buddyInfo.user);
  this.rootNode.setAttribute('nickname', this.buddyInfo.nickname);

  if (window.addEventListener) {
    this.rootNode.addEventListener('mousedown', this.actionCallback, false);
  } else {
    this.rootNode.attachEvent('onmousedown', this.actionCallback, false);
  }
};

BuddyItem.prototype.updateStatus = function(newStatus, skipCheck) {
  if ((skipCheck) || (this.buddyInfo.presence.type != newStatus) &&
      this.CSS_CLASS[newStatus]) {
    this.iconChatNode.className = 
      this.iconChatNode.className.replace(this.CSS_CLASS[this.buddyInfo.presence.type], this.CSS_CLASS[newStatus]);
    this.buddyInfo.presence.type = newStatus;
    if (this.iconChatNode.className.indexOf(this.CSS_CLASS[this.buddyInfo.presence.type]) == -1) {
      this.iconChatNode.className = 'IconChat ' + this.CSS_CLASS[this.buddyInfo.presence.type];
    }
  }
};

BuddyItem.prototype.getUserName = function(userNameFullStr) {
  if (userNameFullStr.indexOf('/') != -1) {
    return (userNameFullStr.substring(0, userNameFullStr.indexOf('/')));
  } else {
    return userNameFullStr;
  }
};

BuddyItem.prototype.remove = function() {
  var buddyItemNode = false;
  if (this.buddyInfo) {
    buddyItemNode = this.rootNode
  } else {
    buddyItemNode = eXo.core.DOMUtil.findAncestorByClass(this, 'BuddyItem');
  }
  if (buddyItemNode) {
    eXo.core.DOMUtil.removeElement(buddyItemNode);
  }
  return false;
}

eXo.communication.chat.webui.component.BuddyItem = BuddyItem;

/**
 * BuddyListControl component
 * 
 * @param {Node} rootNode
 */
function BuddyListControl(rootNode, buddyItemActionCallback, UIMainChatWindow) {
  this.rootNode = rootNode;
  if (!this.rootNode || !(this.rootNode.tagName)) {
    this.rootNode = document.createElement('div');
  }
  this.flags = {debug: false};
  this.UIMainChatWindow = UIMainChatWindow;
  this.buddyItemActionCallback = buddyItemActionCallback;
  this.BuddyItem = eXo.communication.chat.webui.component.BuddyItem;
  this.cleanup();
}

/**
 * @return {eXo.communication.chat.webui.component.BuddyItem}
 */
BuddyListControl.prototype.getNewInstanceOfBuddyItem = function(buddyInfo) {
  var buddyItemObj = new this.BuddyItem(buddyInfo, this.buddyItemActionCallback);
  buddyItemObj.flags['debug'] = this.flags['debug'];
  return buddyItemObj;
};

BuddyListControl.prototype.getBuddyItem = function(buddyId) {
  var buddyObj = this.buddyList[this.getUserName(buddyId)];
  if (buddyObj &&
      buddyObj.buddyInfo) {
    return buddyObj;
  }
  return false;
};

BuddyListControl.prototype.removeBuddy = function(buddyId){
  var buddyItemObj = this.getBuddyItem(buddyId);
  if (buddyItemObj) {
    buddyItemObj.remove();
    this.buddyList[buddyId] = null;
  }
};

// build new buddylist
BuddyListControl.prototype.build = function(roster, isNotCleanUp) {
  if (!isNotCleanUp) {
    this.cleanup();
  }
  this.buddyList = this.buddyList || {};
  for (var i=0; i<roster.length; i++) {
    var buddyInfo = roster[i];
    buddyItemObj = this.getNewInstanceOfBuddyItem(buddyInfo);
    this.buddyList[buddyInfo.user] = buddyItemObj;
    this.rootNode.appendChild(buddyItemObj.rootNode);
  }
};

BuddyListControl.prototype.makeContactListFromPresenceList = function(presences) {
  var contactList = [];
  var mainServiceName = this.UIMainChatWindow.serverInfo.mainServiceName;
  for (var i=0; i<presences.length; i++) {
    var contact = {};
    contact.presence = presences[i];
    contact.groups = [];
    contact.nickname = presences[i].from.substr(presences[i].from.indexOf('/') + 1, presences[i].from.length);
    contact.subscriptionStatus = null;
    contact.subscriptionType = null;
    contact.user = contact.nickname + '@' +  mainServiceName;
    contactList.push(contact);
  }
  return contactList;
};

BuddyListControl.prototype.cleanup = function() {
  if (this.buddyList) {
    for (var item in this.buddyList) {
      var buddyItemObj = this.buddyList[item];
      if (buddyItemObj &&
          buddyItemObj instanceof Object &&
          buddyItemObj.buddyInfo) {
        try {
          buddyItemObj.remove();
        } catch (e) {}
      }
    }
  }
  this.buddyList = null;
  this.rootNode.innerHTML = '<span/>';
};

BuddyListControl.prototype.getUserName = function(userNameFullStr) {
  if (userNameFullStr.indexOf('/') != -1) {
    return (userNameFullStr.substring(0, userNameFullStr.indexOf('/')));
  } else {
    return userNameFullStr;
  }
};

BuddyListControl.prototype.update = function(presences) {
  for (var i=0; i<presences.length; i++) {
    var presence = presences[i];
    if (this.flags['debug']) {
      console.debug('update status for: ' + presence.from);
    }
    var buddyItemObj = this.getBuddyItem(presence.from);
    if (buddyItemObj) {
      if (presence.mode) {
        buddyItemObj.updateStatus(presence.mode);
      } else {
        buddyItemObj.updateStatus(presence.type);
      }
    }
  }
};

BuddyListControl.prototype.xUpdate = function(presences) {
  var buddyListTmp = this.makeContactListFromPresenceList(presences);
  this.buddyList = this.buddyList || {};
  for (var i=0; i<buddyListTmp.length; i++) {
    var buddyInfo = buddyListTmp[i];
    var presence = presences[i];
    var buddyItemObj = this.buddyList[buddyInfo.user];
    if (buddyItemObj) {
      if (presence.mode) {
        buddyItemObj.updateStatus(presence.mode);
      } else {
        buddyItemObj.updateStatus(presence.type);
      }
    } else {
      buddyItemObj = this.getNewInstanceOfBuddyItem(buddyInfo);
      this.buddyList[buddyInfo.user] = buddyItemObj;
      this.rootNode.appendChild(buddyItemObj.rootNode);
    }
  }
};

eXo.communication.chat.webui.component.BuddyListControl = BuddyListControl;
