/**
 *
 *  @author Uoc Nguyen
 */
eXo.require('eXo.communication.chat.core.XMPPCommunicator', '/chat/javascript/');

function eXoChatLoader() {
}

eXoChatLoader.prototype.init = function(userName) {
  this.eXoChatWindowNode = document.createElement('div');
  this.eXoChatWindowNode.className = 'eXoChatWindow';
	this.eXoChatWindowContentNode = document.createElement('iframe');
	this.eXoChatWindowContentNode.className = 'WindowContent';
	this.eXoChatWindowContentNode.src = '/chat/eXoChat.html';
  with (this.eXoChatWindowContentNode.style) {
    width = '100%';
    height = '100%';
  }

  var searchStr = '';
  if (userName) {
    searchStr += '?username=' + userName;
  }

  this.eXoChatWindowContentNode.src = this.eXoChatWindowContentNode.src + searchStr;

  this.eXoChatWindowNode.appendChild(this.eXoChatWindowContentNode);
  this.eXoChatWindowNode.style.display = 'none';
  document.body.appendChild(this.eXoChatWindowNode);
  this.setChatWindowVisible(true);
};

eXoChatLoader.prototype.setChatWindowVisible = function(visible) {
  if (visible) {
    var browserWidth = eXo.core.Browser.getBrowserWidth();
    var browserHeight = eXo.core.Browser.getBrowserHeight();
    var topPos = Math.round(browserHeight * 0.05); + document.body.scrollTop;
    var leftPos = Math.round(browserWidth * 0.05);
    var windowWidth = Math.round(browserWidth * 0.9);
    var windowHeight = Math.round(browserHeight * 0.9);
    with (this.eXoChatWindowNode.style) {
      position = 'absolute';
      top = topPos + 'px';
      left = leftPos + 'px';
      width = windowWidth + 'px';
      height = windowHeight + 'px';
      display = 'block';
    }
  } else {
    this.eXoChatWindowNode.style.display = 'none';
  }
};

eXo.communication.chat.webui.eXoChatLoader = new eXoChatLoader();
