/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.rest.RESTOrganizationServiceAbstractImpl;
import org.exoplatform.services.organization.rest.xml.CountXMLEntity;
import org.exoplatform.services.organization.rest.xml.GroupListXMLEntity;
import org.exoplatform.services.organization.rest.xml.GroupXMLEntity;
import org.exoplatform.services.organization.rest.xml.MembershipListXMLEntity;
import org.exoplatform.services.organization.rest.xml.MembershipTypesListXMLEntity;
import org.exoplatform.services.organization.rest.xml.MembershipXMLEntity;
import org.exoplatform.services.organization.rest.xml.UserListXMLEntity;
import org.exoplatform.services.organization.rest.xml.UserXMLEntity;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.SerializableTransformer;

@URITemplate(value="/organization/xml/")
public class RESTOrganizationServiceXMLImpl
extends RESTOrganizationServiceAbstractImpl
implements ResourceContainer {
    protected static final String XML_CONTENT_TYPE = "text/xml";

    public RESTOrganizationServiceXMLImpl(OrganizationService organizationService) {
        super(organizationService);
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/group/create/")
    public Response createGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupName") String groupName, @QueryParam(value="label") String label, @QueryParam(value="description") String description, @QueryParam(value="parentId") String parentId) {
        Response response = super.createGroup(baseURI, groupName, label, description, parentId);
        if (response.getStatus() == 500) {
            return response;
        }
        String id = ((Group)response.getEntity()).getId();
        return Response.Builder.created((String)(baseURI + "/organization/xml/group/info" + id)).build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/membership/create/")
    public Response createMembership(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="groupId") String groupId, @QueryParam(value="type") String type) {
        Response response = super.createMembership(baseURI, username, groupId, type);
        if (response != null) {
            return response;
        }
        String id = ((Membership)response.getEntity()).getId();
        return Response.Builder.created((String)(baseURI + "/organization/xml/membership/info/" + id)).build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/user/create/")
    public Response createUser(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email) {
        Response response = super.createUser(baseURI, username, password, firstname, lastname, email);
        if (response != null) {
            return response;
        }
        return Response.Builder.created((String)(baseURI + "/organization/xml/user/" + username)).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/delete/")
    public Response deleteGroup(@QueryParam(value="groupId") String groupId) {
        Response response = super.deleteGroup(groupId);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/delete/{membershipId}/")
    public Response deleteMembership(@URIParam(value="membershipId") String membershipId) {
        Response response = super.deleteMembership(membershipId);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/delete/{username}/")
    public Response deleteUser(@URIParam(value="username") String username) {
        Response response = super.deleteUser(username);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/delete-user/")
    public Response deleteUserFromGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupId") String groupId, @QueryParam(value="username") String username) {
        Response response = super.deleteUserFromGroup(baseURI, groupId, username);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/info/{membershipId}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response findMembership(@ContextParam(value="baseURI") String baseURI, @URIParam(value="membershipId") String membershipId) {
        try {
            Membership membership = this.membershipHandler.findMembership(membershipId);
            if (membership != null) {
                return Response.Builder.ok((Object)new MembershipXMLEntity(membership, baseURI), (String)XML_CONTENT_TYPE).build();
            }
            return Response.Builder.withStatus((int)404).errorMessage("Membership with id: '" + membershipId + "' not found!").build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/view-all/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response findMemberships(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupId") String groupId, @QueryParam(value="username") String username, @QueryParam(value="type") String type) {
        try {
            Collection memberships = null;
            if (groupId != null && username != null && type != null) {
                Membership membership = this.membershipHandler.findMembershipByUserGroupAndType(username, groupId = groupId.startsWith("/") ? groupId : "/" + groupId, type);
                if (membership != null) {
                    return Response.Builder.ok((Object)new MembershipXMLEntity(membership, baseURI), (String)XML_CONTENT_TYPE).build();
                }
                return Response.Builder.withStatus((int)404).errorMessage("Membership for groupId: '" + groupId + "', username: '" + username + "', membership type: '" + type + "' not found!").build();
            }
            if (groupId != null && username != null) {
                groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
                memberships = this.membershipHandler.findMembershipsByUserAndGroup(username, groupId);
            } else if (groupId != null) {
                Group group = this.groupHandler.findGroupById(groupId = groupId.startsWith("/") ? groupId : "/" + groupId);
                if (group == null) {
                    return Response.Builder.withStatus((int)404).errorMessage("Group '" + groupId + "' not found!").build();
                }
                memberships = this.membershipHandler.findMembershipsByGroup(group);
            } else if (username != null) {
                memberships = this.membershipHandler.findMembershipsByUser(username);
            } else {
                return Response.Builder.withStatus((int)500).errorMessage("Username, groupId or membership type should be specified!").build();
            }
            if (username != null && this.userHandler.findUserByName(username) != null) {
                return Response.Builder.ok((Object)new MembershipListXMLEntity(memberships, username, baseURI), (String)XML_CONTENT_TYPE).build();
            }
            return Response.Builder.ok((Object)new MembershipListXMLEntity(memberships, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/find-all/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response findUsers(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate) {
        try {
            Query query = new Query();
            query.setUserName(username);
            query.setFirstName(firstname);
            query.setLastName(lastname);
            query.setEmail(email);
            if (fromLoginDate != null) {
                try {
                    query.setFromLoginDate(DateFormat.getDateTimeInstance().parse(fromLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            if (toLoginDate != null) {
                try {
                    query.setToLoginDate(DateFormat.getDateTimeInstance().parse(toLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            List list = this.userHandler.findUsers(query).getAll();
            return Response.Builder.ok((Object)new UserListXMLEntity(list, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/user/view-from-to/{from}/{to}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response findUsersRange(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate, @URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount) {
        try {
            Query query = new Query();
            query.setUserName(username);
            query.setFirstName(firstname);
            query.setLastName(lastname);
            query.setEmail(email);
            if (fromLoginDate != null) {
                try {
                    query.setFromLoginDate(DateFormat.getDateTimeInstance().parse(fromLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            if (toLoginDate != null) {
                try {
                    query.setToLoginDate(DateFormat.getDateTimeInstance().parse(toLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            List list = this.userHandler.findUsers(query).getAll();
            Integer amount_ = amount;
            if (amount > list.size()) {
                amount_ = list.size();
            }
            return Response.Builder.ok((Object)new UserListXMLEntity(list.subList(offset, amount_), baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/filter/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getAllGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="filter") String filter) {
        try {
            Collection groups = this.groupHandler.getAllGroups();
            if (filter != null && filter.length() > 0) {
                ArrayList temp = new ArrayList(groups);
                for (Group g : temp) {
                    if (g.getId().contains(filter)) continue;
                    groups.remove(g);
                }
            }
            return Response.Builder.ok((Object)new GroupListXMLEntity(groups, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/info/{groupId}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getGroup(@ContextParam(value="baseURI") String baseURI, @URIParam(value="groupId") String groupId) {
        try {
            groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            Group group = this.groupHandler.findGroupById(groupId);
            if (group == null) {
                return Response.Builder.withStatus((int)404).errorMessage("Group '" + groupId + "' not found.").build();
            }
            List members = this.userHandler.findUsersByGroup(groupId).getAll();
            return Response.Builder.ok((Object)new GroupXMLEntity(group, members, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/view-all/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getGroups(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="parentId") String parentId) {
        try {
            Collection groups = null;
            if (parentId != null && parentId.length() > 0) {
                Group parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId);
                if (parent == null) {
                    return Response.Builder.withStatus((int)404).errorMessage("Parent '" + parentId + "' not found.").build();
                }
                groups = this.groupHandler.findGroups(parent);
            } else {
                groups = this.groupHandler.findGroups(null);
            }
            return Response.Builder.ok((Object)new GroupListXMLEntity(groups, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/count/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getGroupsCount() {
        try {
            int number = this.groupHandler.getAllGroups().size();
            return Response.Builder.ok((Object)new CountXMLEntity(number, "groups"), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/groups-for-user/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getGroupsOfUser(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username) {
        try {
            if (this.userHandler.findUserByName(username) == null) {
                return Response.Builder.withStatus((int)404).errorMessage("User '" + username + "' not found.").build();
            }
            Collection groups = this.groupHandler.findGroupsOfUser(username);
            return Response.Builder.ok((Object)new GroupListXMLEntity(groups, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/group/view-from-to/{from}/{to}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getGroupsRange(@ContextParam(value="baseURI") String baseURI, @URIParam(value="from") Integer offset, @URIParam(value="to") Integer amount, @QueryParam(value="parentId") String parentId) {
        try {
            Collection groups = null;
            if (parentId != null && parentId.length() > 0) {
                Group parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId);
                if (parent == null) {
                    return Response.Builder.withStatus((int)404).errorMessage("Parent '" + parentId + "' not found.").build();
                }
                groups = this.groupHandler.findGroups(parent);
            } else {
                groups = this.groupHandler.findGroups(null);
            }
            Integer amount_ = amount;
            if (amount > groups.size()) {
                amount_ = groups.size();
            }
            return Response.Builder.ok((Object)new GroupListXMLEntity(new ArrayList(groups).subList(offset, amount_), baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/membership/get-types/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getMembershipTypes() {
        try {
            Collection membershipTypes = this.membershipTypeHandler.findMembershipTypes();
            return Response.Builder.ok((Object)new MembershipTypesListXMLEntity(membershipTypes), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/info/{username}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getUser(@URIParam(value="username") String username) {
        try {
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                return Response.Builder.withStatus((int)404).errorMessage("User '" + username + "' not found.").build();
            }
            return Response.Builder.ok((Object)new UserXMLEntity(user), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/users/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getUsers(@ContextParam(value="baseURI") String baseURI) {
        try {
            List list = this.userHandler.findUsers(new Query()).getAll();
            return Response.Builder.ok((Object)new UserListXMLEntity(list, baseURI), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/count/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getUsersCount() {
        try {
            int number = this.userHandler.findUsers(new Query()).getAll().size();
            return Response.Builder.ok((Object)new CountXMLEntity(number, "users"), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/view-range/{from}/{number}/")
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getUsersRange(@ContextParam(value="baseURI") String baseURI, @URIParam(value="from") Integer offset, @URIParam(value="number") Integer amount) {
        try {
            List list = this.userHandler.findUsers(new Query()).getAll();
            int prevFrom = -1;
            if (offset > 0) {
                prevFrom = offset - amount > 0 ? offset - amount : 0;
            }
            int nextFrom = offset + amount < list.size() ? offset + amount : -1;
            int to = offset + amount < list.size() ? offset + amount : list.size();
            return Response.Builder.ok((Object)new UserListXMLEntity(list.subList(offset, to), baseURI, prevFrom, nextFrom, amount), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/group/update/")
    public Response updateGroup(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="groupId") String groupId, @QueryParam(value="name") String name, @QueryParam(value="label") String label, @QueryParam(value="description") String description) {
        Response response = super.updateGroup(baseURI, groupId, name, label, description);
        if (response != null) {
            return response;
        }
        return Response.Builder.noContent().build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/user/update/")
    public Response updateUser(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email) {
        Response response = super.updateUser(baseURI, username, password, firstname, lastname, email);
        if (response != null) {
            return response;
        }
        return Response.Builder.created((String)(baseURI + "user/" + username)).build();
    }
}

