/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven.plugin;

import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.exoplatform.maven.plugin.FileToCheck;

@Mojo(name="check")
public class DiffExtensionMojo
extends AbstractMojo {
    @Parameter(defaultValue="true")
    private boolean abortBuildOnDiff;
    @Parameter(required=true)
    private String sourceVersion;
    @Parameter(required=true)
    private String targetVersion;
    @Parameter(defaultValue="${project.build.directory}/diffExtension", readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Component
    private RepositoryManager repositoryManager;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArchiverManager archiverManager;
    @Parameter(defaultValue="")
    private List<FileToCheck> files;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.files == null) {
            this.files = new ArrayList<FileToCheck>();
        }
        this.getLog().info((CharSequence)("Checking upgrade from " + this.sourceVersion + " to " + this.targetVersion));
        ArrayList<FileToCheck> changedFiles = new ArrayList<FileToCheck>();
        for (FileToCheck f : this.files) {
            Artifact artifactOldVersion = this.getArtifact(f.groupId, f.artifactId, this.sourceVersion, f.type);
            Artifact artifactNewVersion = this.getArtifact(f.groupId, f.artifactId, this.targetVersion, f.type);
            File oldVersion = this.unpack(artifactOldVersion);
            File newVersion = this.unpack(artifactNewVersion);
            String oldFilePath = oldVersion.getPath() + f.path;
            String newFilePath = newVersion.getPath() + f.path;
            File fileOldVersion = new File(oldFilePath);
            File fileNewVersion = new File(newFilePath);
            String oldMd5 = this.fileMD5Sum(fileOldVersion);
            String newMd5 = this.fileMD5Sum(fileNewVersion);
            if (oldMd5 == null || newMd5 == null) {
                this.getLog().warn((CharSequence)("Unable to get md5Sum for " + f.path));
                f.setPatch(this.extractPatch(fileOldVersion, fileNewVersion));
                changedFiles.add(f);
                continue;
            }
            if (!oldMd5.equals(newMd5)) {
                f.setPatch(this.extractPatch(fileOldVersion, fileNewVersion));
                changedFiles.add(f);
                continue;
            }
            this.getLog().info((CharSequence)("File " + f.groupId + ":" + f.artifactId + f.path + " doesn't change between " + this.sourceVersion + " and " + this.targetVersion));
        }
        if (changedFiles.size() > 0) {
            for (FileToCheck fileToCheck : changedFiles) {
                this.getLog().warn((CharSequence)("File " + fileToCheck.groupId + ":" + fileToCheck.artifactId + fileToCheck.path + " changes between " + this.sourceVersion + " and " + this.targetVersion + ". Need to check."));
                if (fileToCheck.getPatch() == null) continue;
                for (Delta delta : fileToCheck.getPatch().getDeltas()) {
                    this.getLog().warn((CharSequence)String.format("diff: \n\t[oldVersion] -> %s\n\t[newVersion] -> %s", delta.getOriginal().toString(), delta.getRevised().toString()));
                }
            }
            if (this.abortBuildOnDiff) {
                throw new MojoFailureException("Diff exists. Please check");
            }
        }
    }

    private Patch extractPatch(File fileOldVersion, File fileNewVersion) {
        try {
            List<String> oldLines = this.toLines(fileOldVersion);
            List<String> newLines = this.toLines(fileNewVersion);
            return DiffUtils.diff(oldLines, newLines);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Unable to read files " + fileOldVersion + " and " + fileNewVersion), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> toLines(File file) throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }

    public File unpack(Artifact artifact) throws MojoExecutionException {
        File file = artifact.getFile();
        String path = this.outputDirectory.getPath() + "/" + artifact.getGroupId() + "-" + artifact.getArtifactId() + "-" + artifact.getVersion();
        File artifactFile = new File(path);
        this.getLog().debug((CharSequence)("Unpack artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()));
        try {
            UnArchiver unArchiver;
            if (artifactFile.exists()) {
                this.getLog().debug((CharSequence)(artifactFile.getPath() + " exists, delete it"));
                FileUtils.deleteDirectory((File)artifactFile);
            }
            artifactFile.mkdirs();
            if (!artifactFile.exists()) {
                throw new MojoExecutionException("Location to write unpacked files to could not be created: " + artifactFile);
            }
            try {
                unArchiver = this.archiverManager.getUnArchiver(artifact.getType());
                this.getLog().debug((CharSequence)("Found unArchiver by type: " + unArchiver));
            }
            catch (NoSuchArchiverException e) {
                unArchiver = this.archiverManager.getUnArchiver(file);
                this.getLog().debug((CharSequence)("Found unArchiver by extension: " + unArchiver));
            }
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(artifactFile);
            unArchiver.extract();
            return artifactFile;
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + artifactFile + System.lineSeparator() + e.toString(), (Exception)((Object)e));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unable to delete existing folder " + artifactFile.getPath(), (Exception)e);
        }
    }

    protected Artifact getArtifact(String groupId, String artifactId, String version, String type) throws MojoExecutionException {
        Artifact artifact;
        try {
            ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest();
            DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
            coordinate.setGroupId(groupId);
            coordinate.setArtifactId(artifactId);
            coordinate.setVersion(version);
            ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(type);
            String extension = artifactHandler != null ? artifactHandler.getExtension() : type;
            coordinate.setExtension(extension);
            artifact = this.artifactResolver.resolveArtifact(buildingRequest, (ArtifactCoordinate)coordinate).getArtifact();
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Unable to find/resolve artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    public ProjectBuildingRequest newResolveArtifactProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteRepositories);
        return buildingRequest;
    }

    public String fileMD5Sum(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            String md5 = DigestUtils.md5Hex((InputStream)is);
            return md5;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Unable to get md5sum for " + file.getPath()));
            return null;
        }
    }
}

