/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven.plugin.exobuild;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.exoplatform.maven.plugin.exobuild.AbstractFromDependenciesMojo;
import org.exoplatform.maven.plugin.exobuild.utils.DependencyStatusSets;
import org.exoplatform.maven.plugin.exobuild.utils.DependencyUtil;
import org.exoplatform.maven.plugin.exobuild.utils.filters.MarkerFileFilter;
import org.exoplatform.maven.plugin.exobuild.utils.markers.DefaultFileMarkerHandler;

public class UnpackDependenciesMojo
extends AbstractFromDependenciesMojo {
    private String includes;
    private String excludes;

    public void execute() throws MojoExecutionException {
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact);
        Set artifacts = dss.getResolvedDependencies();
        for (Artifact artifact : artifacts) {
            File destDir = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.stripVersion, this.outputDirectory, artifact);
            this.unpack(artifact.getFile(), destDir, this.getIncludes(), this.getExcludes());
            DefaultFileMarkerHandler handler = new DefaultFileMarkerHandler(artifact, this.markersDirectory);
            handler.setMarker();
        }
        artifacts = dss.getSkippedDependencies();
        for (Artifact artifact : artifacts) {
            this.getLog().info((CharSequence)(artifact.getFile().getName() + " already exists in destination."));
        }
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new MarkerFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, new DefaultFileMarkerHandler(this.markersDirectory));
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }
}

