/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven.plugin.exobuild.fromConfiguration;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;
import org.exoplatform.maven.plugin.exobuild.fromConfiguration.AbstractFromConfigurationMojo;
import org.exoplatform.maven.plugin.exobuild.fromConfiguration.ArtifactItem;
import org.exoplatform.maven.plugin.exobuild.utils.filters.ArtifactItemFilter;
import org.exoplatform.maven.plugin.exobuild.utils.filters.MarkerFileFilter;
import org.exoplatform.maven.plugin.exobuild.utils.markers.UnpackFileMarkerHandler;

public final class UnpackMojo
extends AbstractFromConfigurationMojo {
    private File markersDirectory;
    private String includes;
    private String excludes;

    public void execute() throws MojoExecutionException {
        ArrayList processedItems = this.getProcessedArtifactItems(false);
        for (ArtifactItem artifactItem : processedItems) {
            if (artifactItem.isNeedsProcessing()) {
                this.unpackArtifact(artifactItem);
                continue;
            }
            this.getLog().info((CharSequence)(artifactItem.getArtifact().getFile().getName() + " already unpacked."));
        }
    }

    private void unpackArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        UnpackFileMarkerHandler handler = new UnpackFileMarkerHandler(artifactItem, this.markersDirectory);
        this.unpack(artifactItem.getArtifact().getFile(), artifactItem.getOutputDirectory(), artifactItem.getIncludes(), artifactItem.getExcludes());
        handler.setMarker();
    }

    ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem item) {
        UnpackFileMarkerHandler handler = new UnpackFileMarkerHandler(item, this.markersDirectory);
        return new MarkerFileFilter(this.isOverWriteReleases(), this.isOverWriteSnapshots(), this.isOverWriteIfNewer(), handler);
    }

    protected ArrayList getProcessedArtifactItems(boolean removeVersion) throws MojoExecutionException {
        ArrayList items = super.getProcessedArtifactItems(removeVersion);
        for (ArtifactItem artifactItem : items) {
            if (StringUtils.isEmpty((String)artifactItem.getIncludes())) {
                artifactItem.setIncludes(this.getIncludes());
            }
            if (!StringUtils.isEmpty((String)artifactItem.getExcludes())) continue;
            artifactItem.setExcludes(this.getExcludes());
        }
        return items;
    }

    public File getMarkersDirectory() {
        return this.markersDirectory;
    }

    public void setMarkersDirectory(File theMarkersDirectory) {
        this.markersDirectory = theMarkersDirectory;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }
}

