/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.cxf.common.util.ASMHelper;
import org.apache.cxf.jaxws.interceptors.WrapperHelper;
import org.exo.asm.*;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WrapperHelperCompiler
extends ASMHelper {
    final Class<?> wrapperType;
    final Method[] setMethods;
    final Method[] getMethods;
    final Method[] jaxbMethods;
    final Field[] fields;
    final Object objectFactory;
    final * cw;

    private WrapperHelperCompiler(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        this.wrapperType = wrapperType;
        this.setMethods = setMethods;
        this.getMethods = getMethods;
        this.jaxbMethods = jaxbMethods;
        this.fields = fields;
        this.objectFactory = objectFactory;
        this.cw = this.createClassWriter();
    }

    static WrapperHelper compileWrapperHelper(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        try {
            return new WrapperHelperCompiler(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory).compile();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public WrapperHelper compile() {
        if (this.cw == null) {
            return null;
        }
        int count = 1;
        String newClassName = this.wrapperType.getName() + "_WrapperTypeHelper" + count;
        newClassName = newClassName.replaceAll("\\$", ".");
        newClassName = WrapperHelperCompiler.periodToSlashes((String)newClassName);
        Class cls = super.findClass(newClassName.replace('/', '.'), this.wrapperType);
        while (cls != null) {
            try {
                WrapperHelper helper = (WrapperHelper)WrapperHelper.class.cast(cls.newInstance());
                if (!helper.getSignature().equals(this.computeSignature())) {
                    newClassName = this.wrapperType.getName() + "_WrapperTypeHelper" + ++count;
                    newClassName = newClassName.replaceAll("\\$", ".");
                    newClassName = WrapperHelperCompiler.periodToSlashes((String)newClassName);
                    cls = super.findClass(newClassName.replace('/', '.'), this.wrapperType);
                    continue;
                }
                return helper;
            }
            catch (Exception e) {
                return null;
            }
        }
        this.cw.visit(49, 33, newClassName, null, WrapperHelperCompiler.periodToSlashes((String)WrapperHelper.class.getName()), null);
        WrapperHelperCompiler.addConstructor(newClassName, this.cw, this.objectFactory == null ? null : this.objectFactory.getClass());
        boolean b = this.addSignature();
        if (b) {
            this.addCreateWrapperObject(newClassName, this.objectFactory == null ? null : this.objectFactory.getClass());
        }
        if (b) {
            b = WrapperHelperCompiler.addGetWrapperParts(newClassName, this.wrapperType, this.getMethods, this.fields, this.cw);
        }
        try {
            if (b) {
                this.cw.visitEnd();
                byte[] bt = this.cw.toByteArray();
                Class cl = this.loadClass(newClassName.replace('/', '.'), this.wrapperType, bt);
                Object o = cl.newInstance();
                return (WrapperHelper)WrapperHelper.class.cast(o);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return null;
    }

    private String computeSignature() {
        StringBuilder b = new StringBuilder();
        b.append(this.setMethods.length).append(':');
        for (int x = 0; x < this.setMethods.length; ++x) {
            if (this.getMethods[x] == null) {
                b.append("null,");
                continue;
            }
            b.append(this.getMethods[x].getName()).append('/');
            b.append(this.getMethods[x].getReturnType().getName()).append(',');
        }
        return b.toString();
    }

    private boolean addSignature() {
        String sig = this.computeSignature();
        if (sig == null) {
            return false;
        }
        * mv = this.cw.visitMethod(1, "getSignature", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        * l0 = new *();
        mv.visitLabel(l0);
        mv.visitLineNumber(100, l0);
        mv.visitLdcInsn((Object)sig);
        mv.visitInsn(176);
        * l1 = new *();
        mv.visitLabel(l1);
        mv.visitLineNumber(101, l1);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return true;
    }

    private static void addConstructor(String newClassName, * cw, Class<?> objectFactory) {
        if (objectFactory != null) {
            String ofName = "L" + WrapperHelperCompiler.periodToSlashes((String)objectFactory.getName()) + ";";
            * fv = cw.visitField(0, "factory", ofName, null, null);
            fv.visitEnd();
        }
        * mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        * l0 = new *();
        mv.visitLabel(l0);
        mv.visitLineNumber(102, l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, WrapperHelperCompiler.periodToSlashes((String)WrapperHelper.class.getName()), "<init>", "()V");
        if (objectFactory != null) {
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, WrapperHelperCompiler.periodToSlashes((String)objectFactory.getName()));
            mv.visitInsn(89);
            mv.visitMethodInsn(183, WrapperHelperCompiler.periodToSlashes((String)objectFactory.getName()), "<init>", "()V");
            mv.visitFieldInsn(181, WrapperHelperCompiler.periodToSlashes((String)newClassName), "factory", "L" + WrapperHelperCompiler.periodToSlashes((String)objectFactory.getName()) + ";");
        }
        mv.visitInsn(177);
        * l1 = new *();
        mv.visitLabel(l1);
        mv.visitLineNumber(103, l0);
        mv.visitLocalVariable("this", "L" + newClassName + ";", null, l0, l1, 0);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private boolean addCreateWrapperObject(String newClassName, Class<?> objectFactoryClass) {
        * mv = this.cw.visitMethod(1, "createWrapperObject", "(Ljava/util/List;)Ljava/lang/Object;", "(Ljava/util/List<*>;)Ljava/lang/Object;", new String[]{"org/apache/cxf/interceptor/Fault"});
        mv.visitCode();
        * lBegin = new *();
        mv.visitLabel(lBegin);
        mv.visitLineNumber(104, lBegin);
        mv.visitTypeInsn(187, WrapperHelperCompiler.periodToSlashes((String)this.wrapperType.getName()));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, WrapperHelperCompiler.periodToSlashes((String)this.wrapperType.getName()), "<init>", "()V");
        mv.visitVarInsn(58, 2);
        for (int x = 0; x < this.setMethods.length; ++x) {
            if (this.getMethods[x] == null) {
                if (this.setMethods[x] == null && this.fields[x] == null) continue;
                return false;
            }
            Class<?> tp = this.getMethods[x].getReturnType();
            mv.visitVarInsn(25, 2);
            if (List.class.isAssignableFrom(tp)) {
                this.doCollection(mv, x);
                continue;
            }
            if (JAXBElement.class.isAssignableFrom(tp)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, WrapperHelperCompiler.periodToSlashes((String)newClassName), "factory", "L" + WrapperHelperCompiler.periodToSlashes((String)objectFactoryClass.getName()) + ";");
            }
            mv.visitVarInsn(25, 1);
            mv.visitIntInsn(16, x);
            mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            if (tp.isPrimitive()) {
                mv.visitTypeInsn(192, (String)NONPRIMITIVE_MAP.get(tp));
                mv.visitMethodInsn(182, (String)NONPRIMITIVE_MAP.get(tp), tp.getName() + "Value", "()" + (String)PRIMITIVE_MAP.get(tp));
            } else if (JAXBElement.class.isAssignableFrom(tp)) {
                mv.visitTypeInsn(192, WrapperHelperCompiler.periodToSlashes((String)this.jaxbMethods[x].getParameterTypes()[0].getName()));
                mv.visitMethodInsn(182, WrapperHelperCompiler.periodToSlashes((String)objectFactoryClass.getName()), this.jaxbMethods[x].getName(), WrapperHelperCompiler.getMethodSignature((Method)this.jaxbMethods[x]));
            } else if (tp.isArray()) {
                mv.visitTypeInsn(192, WrapperHelperCompiler.getClassCode(tp));
            } else {
                mv.visitTypeInsn(192, WrapperHelperCompiler.periodToSlashes((String)tp.getName()));
            }
            mv.visitMethodInsn(182, WrapperHelperCompiler.periodToSlashes((String)this.wrapperType.getName()), this.setMethods[x].getName(), "(" + WrapperHelperCompiler.getClassCode(tp) + ")V");
        }
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        * lEnd = new *();
        mv.visitLabel(lEnd);
        mv.visitLineNumber(105, lEnd);
        mv.visitLocalVariable("this", "L" + newClassName + ";", null, lBegin, lEnd, 0);
        mv.visitLocalVariable("lst", "Ljava/util/List;", "Ljava/util/List<*>;", lBegin, lEnd, 1);
        mv.visitLocalVariable("ok", "L" + WrapperHelperCompiler.periodToSlashes((String)this.wrapperType.getName()) + ";", null, lBegin, lEnd, 2);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return true;
    }

    private void doCollection(* mv, int x) {
        * l3 = new *();
        mv.visitLabel(l3);
        mv.visitLineNumber(114, l3);
        mv.visitMethodInsn(182, WrapperHelperCompiler.periodToSlashes((String)this.wrapperType.getName()), this.getMethods[x].getName(), WrapperHelperCompiler.getMethodSignature((Method)this.getMethods[x]));
        mv.visitVarInsn(58, 3);
        mv.visitVarInsn(25, 1);
        mv.visitIntInsn(16, x);
        mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "java/util/List");
        mv.visitVarInsn(58, 4);
        mv.visitVarInsn(25, 3);
        * nonNullLabel = new *();
        mv.visitJumpInsn(199, nonNullLabel);
        if (this.setMethods[x] == null) {
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)(this.getMethods[x].getName() + " returned null and there isn't a set method."));
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
        } else {
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 4);
            mv.visitTypeInsn(192, this.getMethods[x].getReturnType().getName().replace('.', '/'));
            mv.visitMethodInsn(182, WrapperHelperCompiler.periodToSlashes((String)this.wrapperType.getName()), this.setMethods[x].getName(), WrapperHelperCompiler.getMethodSignature((Method)this.setMethods[x]));
        }
        * jumpOverLabel = new *();
        mv.visitJumpInsn(167, jumpOverLabel);
        mv.visitLabel(nonNullLabel);
        mv.visitLineNumber(106, nonNullLabel);
        mv.visitVarInsn(25, 4);
        mv.visitJumpInsn(198, jumpOverLabel);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(185, "java/util/List", "addAll", "(Ljava/util/Collection;)Z");
        mv.visitInsn(87);
        mv.visitLabel(jumpOverLabel);
        mv.visitLineNumber(107, jumpOverLabel);
    }

    private static boolean addGetWrapperParts(String newClassName, Class<?> wrapperClass, Method[] getMethods, Field[] fields, * cw) {
        * mv = cw.visitMethod(1, "getWrapperParts", "(Ljava/lang/Object;)Ljava/util/List;", "(Ljava/lang/Object;)Ljava/util/List<Ljava/lang/Object;>;", new String[]{"org/apache/cxf/interceptor/Fault"});
        mv.visitCode();
        * lBegin = new *();
        mv.visitLabel(lBegin);
        mv.visitLineNumber(108, lBegin);
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, WrapperHelperCompiler.periodToSlashes((String)wrapperClass.getName()));
        mv.visitVarInsn(58, 3);
        for (int x = 0; x < getMethods.length; ++x) {
            * l3;
            Method method = getMethods[x];
            if (method == null && fields[x] != null) {
                return false;
            }
            if (method == null) {
                l3 = new *();
                mv.visitLabel(l3);
                mv.visitLineNumber(200 + x, l3);
                mv.visitVarInsn(25, 2);
                mv.visitInsn(1);
                mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
                mv.visitInsn(87);
                continue;
            }
            l3 = new *();
            mv.visitLabel(l3);
            mv.visitLineNumber(250 + x, l3);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, WrapperHelperCompiler.periodToSlashes((String)wrapperClass.getName()), method.getName(), WrapperHelperCompiler.getMethodSignature((Method)method));
            if (method.getReturnType().isPrimitive()) {
                WrapperHelperCompiler.createObjectWrapper(mv, method.getReturnType());
            }
            if (JAXBElement.class.isAssignableFrom(method.getReturnType())) {
                mv.visitMethodInsn(182, "javax/xml/bind/JAXBElement", "getValue", "()Ljava/lang/Object;");
            }
            mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
        }
        * l2 = new *();
        mv.visitLabel(l2);
        mv.visitLineNumber(108, l2);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        * lEnd = new *();
        mv.visitLabel(lEnd);
        mv.visitLineNumber(109, lEnd);
        mv.visitLocalVariable("this", "L" + newClassName + ";", null, lBegin, lEnd, 0);
        mv.visitLocalVariable("o", "Ljava/lang/Object;", null, lBegin, lEnd, 1);
        mv.visitLocalVariable("ret", "Ljava/util/List;", "Ljava/util/List<Ljava/lang/Object;>;", lBegin, lEnd, 2);
        mv.visitLocalVariable("ok", "L" + WrapperHelperCompiler.periodToSlashes((String)wrapperClass.getName()) + ";", null, lBegin, lEnd, 3);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return true;
    }

    private static void createObjectWrapper(* mv, Class<?> cl) {
        mv.visitMethodInsn(184, (String)NONPRIMITIVE_MAP.get(cl), "valueOf", "(" + (String)PRIMITIVE_MAP.get(cl) + ")L" + (String)NONPRIMITIVE_MAP.get(cl) + ";");
    }
}

