/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.social.core.storage.cache.selector;

import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.identity.provider.SpaceIdentityProvider;
import org.exoplatform.social.core.storage.cache.model.key.IdentityFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.ListIdentitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ScopeCacheKey;

/**
 * @author <a href="mailto:alain.defrance@exoplatform.com">Alain Defrance</a>
 * @version $Revision$
 */
public class IdentityCacheSelector extends ScopeCacheSelector<ScopeCacheKey, Object> {

  private String provider;

  public IdentityCacheSelector(final String provider) {

    if (provider == null) {
      throw new NullPointerException();
    }

    if (!provider.equals(OrganizationIdentityProvider.NAME) && !provider.equals(SpaceIdentityProvider.NAME)) {
      throw new IllegalArgumentException();
    }

    this.provider = provider;
  }

  @Override
  public boolean select(final ScopeCacheKey key, final ObjectCacheInfo<? extends Object> ocinfo) {

    if (!super.select(key, ocinfo)) {
      return false;
    }

    if (key instanceof IdentityFilterKey) {
      return ((IdentityFilterKey)key).getProviderId().equals(OrganizationIdentityProvider.NAME);
    }

    if (key instanceof ListIdentitiesKey) {
      return ((ListIdentitiesKey)key).getKey().getProviderId().equals(OrganizationIdentityProvider.NAME) || 
                                      ((ListIdentitiesKey)key).getKey().getProviderId().equals(SpaceIdentityProvider.NAME);
    }

    return false;

  }

}
