/*
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform.services.jcr.impl.util;

/**
 * Created by The eXo Platform SAS Author : Peter Nedonosko peter.nedonosko@exoplatform.com.ua
 * 15.08.2006
 * 
 * @author <a href="mailto:peter.nedonosko@exoplatform.com.ua">Peter Nedonosko</a>
 * @version $Id: UnicodeFormatter.java 11907 2008-03-13 15:36:21Z ksm $
 */
public class UnicodeFormatter
{

   static public String byteToHex(byte b)
   {
      // Returns hex String representation of byte b
      char hexDigit[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
      char[] array = {hexDigit[(b >> 4) & 0x0f], hexDigit[b & 0x0f]};
      return new String(array);
   }

   static public String charToHex(char c)
   {
      // Returns hex String representation of char c
      byte hi = (byte)(c >>> 8);
      byte lo = (byte)(c & 0xff);
      return byteToHex(hi) + byteToHex(lo);
   }

   static public String charToUString(char c)
   {
      // Returns unicode String representation of char c - like \\uXXXX
return "\\u" + charToHex(c);
   }
}
