/*
 * Copyright (C) 2003-2008 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ecm.webui.component.explorer.control.filter;

import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.ext.filter.UIExtensionAbstractFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

import javax.jcr.Node;
import java.util.Map;

/**
 * Created by The eXo Platform SARL
 * Author : Nguyen Anh Vu
 *          anhvurz90@gmail.com
 * Oct 16, 2009
 * 10:34:12 AM
 */
public class IsNotFavouriteFilter extends UIExtensionAbstractFilter {

  public IsNotFavouriteFilter() {
    this(null);
  }

  public IsNotFavouriteFilter(String messageKey) {
    super(messageKey, UIExtensionFilterType.MANDATORY);
  }

  public static boolean isNotFavourite(Node node, UIJCRExplorer uiExplorer) throws Exception {
    FavoriteService favoriteService = WCMCoreUtils.getService(FavoriteService.class);

    return !favoriteService.isFavoriter(WCMCoreUtils.getRemoteUser(), node);
  }

  public boolean accept(Map<String, Object> context) throws Exception {
      if (context == null) return true;
      Node currentNode = (Node) context.get(Node.class.getName());
      UIJCRExplorer uiExplorer = (UIJCRExplorer)context.get(UIJCRExplorer.class.getName());
      return isNotFavourite(currentNode, uiExplorer);
  }

  public void onDeny(Map<String, Object> context) throws Exception {  }
}
