/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.info;

import java.security.AccessControlException;
import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import org.exoplatform.ecm.permission.info.UIPermissionInputSet;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UIPermissionInfo;
import org.exoplatform.ecm.webui.core.UIPermissionFormBase;
import org.exoplatform.ecm.webui.core.UIPermissionManagerBase;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/core/UIPermissionForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionFormBase.ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CloseActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionFormBase.SelectUserActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionFormBase.SelectMemberActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionFormBase.AddAnyActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIPermissionInputSet.OnChangeActionListener.class})})
public class UIPermissionForm
extends UIPermissionFormBase
implements UISelectable {
    public void doSelect(String selectField, Object value) {
        block2: {
            try {
                ExtendedNode node = (ExtendedNode)this.getCurrentNode();
                this.checkAll(false);
                this.fillForm(value.toString(), node);
                this.lockForm(value.toString().equals(this.getExoOwner((Node)node)));
                this.getUIStringInput(selectField).setValue((Object)value.toString());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    public Node getCurrentNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public static class CloseActionListener
    extends EventListener<UIPermissionForm> {
        public void execute(Event<UIPermissionForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIPermissionForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UIPermissionForm> {
        public void execute(Event<UIPermissionForm> event) throws Exception {
            UIPermissionForm uiForm = (UIPermissionForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            UIPermissionManagerBase uiParent = (UIPermissionManagerBase)uiForm.getParent();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String userOrGroup = (String)((UIPermissionInputSet)uiForm.getChild(UIPermissionInputSet.class)).getUIStringInput("userOrGroup").getValue();
            ArrayList<String> permsList = new ArrayList<String>();
            ArrayList<String> permsRemoveList = new ArrayList<String>();
            uiExplorer.addLockToken(currentNode);
            if (!currentNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                return;
            }
            for (String perm : PermissionType.ALL) {
                if (uiForm.getUICheckBoxInput(perm) != null && uiForm.getUICheckBoxInput(perm).isChecked()) {
                    permsList.add(perm);
                    continue;
                }
                permsRemoveList.add(perm);
            }
            if (uiForm.getUICheckBoxInput("add_node").isChecked() && !permsList.contains("set_property")) {
                permsList.add("set_property");
            }
            if (!uiForm.getUICheckBoxInput("add_node").isChecked() && !permsRemoveList.contains("set_property")) {
                permsRemoveList.add("set_property");
            }
            if (Utils.isNameEmpty((String)userOrGroup)) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.userOrGroup-required", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                return;
            }
            if (permsList.size() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.checkbox-require", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                return;
            }
            String[] permsArray = permsList.toArray(new String[permsList.size()]);
            ExtendedNode node = (ExtendedNode)currentNode;
            if (PermissionUtil.canChangePermission((Node)node)) {
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                    node.setPermission(Utils.getNodeOwner((Node)node), PermissionType.ALL);
                }
                for (String perm : permsRemoveList) {
                    try {
                        node.removePermission(userOrGroup, perm);
                    }
                    catch (AccessDeniedException ade) {
                        uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.access-denied", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                        return;
                    }
                    catch (AccessControlException accessControlException) {
                        uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.access-denied", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                        return;
                    }
                }
                try {
                    if (PermissionUtil.canChangePermission((Node)node)) {
                        node.setPermission(userOrGroup, permsArray);
                    }
                    node.save();
                }
                catch (AccessDeniedException ade) {
                    uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.access-denied", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                    return;
                }
                catch (AccessControlException accessControlException) {
                    uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.access-denied", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                    return;
                }
                ((UIPermissionInfo)uiParent.getChild(UIPermissionInfo.class)).updateGrid(1);
                if (uiExplorer.getRootNode().equals(node) && !PermissionUtil.canRead((Node)currentNode)) {
                    ((UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class)).reloadWhenBroken(uiExplorer);
                    return;
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.not-change-permission", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
                return;
            }
            uiForm.updateSymlinks(uiForm.getCurrentNode());
            currentNode.getSession().save();
            uiForm.refresh();
            uiExplorer.setIsHidePopup(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
        }
    }
}

