/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.EcmsSearchResult;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public abstract class BaseSearchServiceConnector
extends SearchServiceConnector {
    public static final String sortByDate = "date";
    public static final String sortByRelevancy = "relevancy";
    public static final String sortByTitle = "title";
    protected SiteSearchService siteSearch_ = (SiteSearchService)WCMCoreUtils.getService(SiteSearchService.class);
    protected ManageDriveService driveService_ = (ManageDriveService)WCMCoreUtils.getService(ManageDriveService.class);
    protected static final Log LOG = ExoLogger.getLogger((String)BaseSearchServiceConnector.class.getName());
    public static final String DEFAULT_SITENAME = "intranet";
    public static final String PAGE_NAGVIGATION = "documents";
    public static final String NONE_NAGVIGATION = "#";
    public static final String PORTLET_NAME = "FileExplorerPortlet";

    public BaseSearchServiceConnector(InitParams initParams) throws Exception {
        super(initParams);
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        List<SearchResult> ret;
        block9: {
            ret = new ArrayList<SearchResult>();
            QueryCriteria criteria = this.createQueryCriteria(query, offset, limit, sort, order);
            try {
                if (sites == null || sites.size() == 0 || ConversationState.getCurrent().getIdentity().getUserId() != null) {
                    criteria.setSiteName(null);
                    ret = this.convertResult(this.searchNodes(criteria), limit, context);
                } else if (sites.size() == 1) {
                    criteria.setSiteName(sites.iterator().next());
                    ret = this.convertResult(this.searchNodes(criteria), limit, context);
                } else {
                    Iterator<String> iter = sites.iterator();
                    criteria.setOffset(0L);
                    while (iter.hasNext() && limit > 0) {
                        criteria.setSiteName(iter.next());
                        List<SearchResult> ret1 = this.convertResult(this.searchNodes(criteria), limit, context);
                        if (ret1.size() <= offset) {
                            offset -= ret1.size();
                            continue;
                        }
                        if (ret1.size() < offset + limit) {
                            ret.addAll(ret1.subList(offset, ret1.size() - offset));
                            limit -= ret1.size() - offset;
                            offset = 0;
                            continue;
                        }
                        ret.addAll(ret1.subList(offset, limit - offset));
                        offset = 0;
                        limit = 0;
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)e);
            }
        }
        return ret;
    }

    protected abstract QueryCriteria createQueryCriteria(String var1, long var2, long var4, String var6, String var7);

    protected abstract AbstractPageList<ResultNode> searchNodes(QueryCriteria var1) throws Exception;

    protected abstract ResultNode filterNode(ResultNode var1) throws RepositoryException;

    protected List<SearchResult> convertResult(AbstractPageList<ResultNode> pageList, int limit, SearchContext context) {
        ArrayList<SearchResult> ret;
        block8: {
            ret = new ArrayList<SearchResult>();
            try {
                if (pageList != null) {
                    for (int i = 1; i <= pageList.getAvailablePage(); ++i) {
                        for (ResultNode obj : pageList.getPage(i)) {
                            try {
                                ResultNode retNode;
                                if (!(obj instanceof ResultNode) || (retNode = this.filterNode(obj)) == null) continue;
                                DriveData driveData = this.getDriveData(retNode);
                                Calendar date = this.getDate(retNode);
                                EcmsSearchResult result = new EcmsSearchResult(this.getPath(driveData, retNode, context), this.getTitleResult(retNode), retNode.getExcerpt(), this.getDriveTitle(driveData) + this.fileSize(retNode) + this.formatDate(date), this.getImageUrl(retNode), date.getTimeInMillis(), (long)retNode.getScore(), this.getFileType(retNode));
                                if (result != null) {
                                    ret.add(result);
                                }
                                if (ret.size() < limit) continue;
                                return ret;
                            }
                            catch (Exception e) {
                                if (!LOG.isErrorEnabled()) continue;
                                LOG.error((Object)e);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)e.getMessage());
            }
        }
        return ret;
    }

    protected String fileSize(Node node) throws Exception {
        return Utils.fileSize((Node)node);
    }

    protected String getImageUrl(Node node) {
        return "/eXoResources/skin/images/Icons/FileTypeIcons/uiIconsFileType64x64.png";
    }

    protected DriveData getDriveData(Node node) throws Exception {
        List<DriveData> dataList = this.getDriveDataList();
        DriveData ret = null;
        for (DriveData data : dataList) {
            if (!node.getPath().startsWith(data.getHomePath()) || ret != null && ret.getHomePath().length() >= data.getHomePath().length()) continue;
            ret = data;
        }
        return ret;
    }

    protected List<DriveData> getDriveDataList() throws Exception {
        return this.driveService_.getDriveByUserRoles(ConversationState.getCurrent().getIdentity().getUserId(), Utils.getMemberships());
    }

    protected Calendar getDate(Node node) throws Exception {
        return node.hasProperty("exo:lastModifiedDate") ? node.getProperty("exo:lastModifiedDate").getDate() : node.getProperty("exo:dateCreated").getDate();
    }

    protected String formatDate(Calendar date) {
        DateFormat format = SimpleDateFormat.getDateTimeInstance(0, 3);
        return " - " + format.format(date.getTime());
    }

    protected String getDriveTitle(DriveData driveData) {
        if (driveData == null) {
            return "";
        }
        String id = driveData.getName();
        String path = driveData.getHomePath();
        try {
            RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            Node groupNode = (Node)WCMCoreUtils.getSystemSessionProvider().getSession(repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), repoService.getCurrentRepository()).getItem(path);
            while (groupNode.getParent() != null) {
                if (groupNode.hasProperty("exo:driveLabel")) {
                    return groupNode.getProperty("exo:driveLabel").getString();
                }
                groupNode = groupNode.getParent();
            }
            return id.replace(".", " / ");
        }
        catch (Exception e) {
            return id.replace(".", " / ");
        }
    }

    protected abstract String getPath(DriveData var1, ResultNode var2, SearchContext var3) throws Exception;

    protected abstract String getFileType(ResultNode var1) throws Exception;

    protected abstract String getTitleResult(ResultNode var1) throws Exception;
}

