/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.SiteConfigTemplates;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.importer.Imported;
import org.exoplatform.portal.mop.importer.NavigationImporter;
import org.exoplatform.portal.mop.importer.PageImporter;
import org.exoplatform.portal.mop.importer.PortalConfigImporter;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.mop.api.workspace.Workspace;
import org.jibx.runtime.JiBXException;

public class NewPortalConfigListener
extends BaseComponentPlugin {
    private final UserPortalConfigService owner_;
    private ConfigurationManager cmanager_;
    private DataStorage dataStorage_;
    private PageService pageService_;
    private volatile List<NewPortalConfig> configs;
    private List<SiteConfigTemplates> templateConfigs;
    private String pageTemplatesLocation_;
    private String defaultPortal;
    private boolean defaultPortalSpecified = false;
    private boolean isUseTryCatch;
    private boolean overrideExistingData;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final POMSessionManager pomMgr;
    private NavigationService navigationService_;
    private DescriptionService descriptionService_;
    final Set<String> createdOwners = new HashSet<String>();
    private boolean isFirstStartup = false;
    private final Pattern OWNER_PATTERN = Pattern.compile("@owner@");

    public NewPortalConfigListener(UserPortalConfigService owner, POMSessionManager pomMgr, DataStorage dataStorage, PageService pageService, ConfigurationManager cmanager, InitParams params, NavigationService navigationService, DescriptionService descriptionService) throws Exception {
        this.owner_ = owner;
        this.cmanager_ = cmanager;
        this.dataStorage_ = dataStorage;
        this.pageService_ = pageService;
        this.navigationService_ = navigationService;
        this.descriptionService_ = descriptionService;
        ValueParam valueParam = params.getValueParam("page.templates.location");
        if (valueParam != null) {
            this.pageTemplatesLocation_ = valueParam.getValue();
        }
        if ((valueParam = params.getValueParam("default.portal")) != null) {
            this.defaultPortal = valueParam.getValue();
        }
        if (this.defaultPortal == null || this.defaultPortal.trim().length() == 0) {
            this.defaultPortal = "classic";
        } else {
            this.defaultPortalSpecified = true;
        }
        this.configs = params.getObjectParamValues(NewPortalConfig.class);
        this.templateConfigs = params.getObjectParamValues(SiteConfigTemplates.class);
        valueParam = params.getValueParam("initializing.failure.ignore");
        this.isUseTryCatch = valueParam != null ? valueParam.getValue().toLowerCase().equals("true") : true;
        valueParam = params.getValueParam("override");
        this.overrideExistingData = valueParam != null ? "true".equals(valueParam.getValue()) : false;
        this.pomMgr = pomMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touchImport() {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            POMSession session = this.pomMgr.getSession();
            Workspace workspace = session.getWorkspace();
            Imported imported = (Imported)workspace.adapt(Imported.class);
            imported.setLastModificationDate(new Date());
            imported.setStatus(Imported.Status.DONE.status());
            session.save();
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performImport() throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            Imported imported;
            boolean perform;
            POMSession session = this.pomMgr.getSession();
            Workspace workspace = session.getWorkspace();
            boolean bl = perform = !workspace.isAdapted(Imported.class);
            if (perform) {
                imported = (Imported)workspace.adapt(Imported.class);
                imported.setCreationDate(new Date());
                if (this.dataStorage_.getPortalConfig(this.defaultPortal) != null) {
                    perform = false;
                    imported.setStatus(Imported.Status.DONE.status());
                } else {
                    this.isFirstStartup = true;
                }
                session.save();
            } else {
                imported = (Imported)workspace.adapt(Imported.class);
                Integer st = imported.getStatus();
                if (st != null) {
                    Imported.Status status = Imported.Status.getStatus(st);
                    boolean bl2 = perform = Imported.Status.WANT_REIMPORT == status;
                }
            }
            if (this.overrideExistingData) {
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = perform;
            return bl4;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (!this.performImport()) {
            return;
        }
        if (this.isUseTryCatch) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                for (NewPortalConfig ele : this.configs) {
                    try {
                        this.initPortalConfigDB(ele);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            finally {
                RequestLifeCycle.end();
            }
            for (NewPortalConfig ele : this.configs) {
                try {
                    this.initPageDB(ele);
                }
                catch (Exception e) {
                    this.log.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
                }
            }
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                for (NewPortalConfig ele : this.configs) {
                    try {
                        this.initPageNavigationDB(ele);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            finally {
                RequestLifeCycle.end();
            }
            for (NewPortalConfig ele : this.configs) {
                try {
                    ele.getPredefinedOwner().clear();
                }
                catch (Exception e) {
                    this.log.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
                }
            }
        } else {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                for (NewPortalConfig ele : this.configs) {
                    this.initPortalConfigDB(ele);
                }
            }
            finally {
                RequestLifeCycle.end();
            }
            for (NewPortalConfig ele : this.configs) {
                this.initPageDB(ele);
            }
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                for (NewPortalConfig ele : this.configs) {
                    this.initPageNavigationDB(ele);
                }
            }
            finally {
                RequestLifeCycle.end();
            }
            for (NewPortalConfig ele : this.configs) {
                ele.getPredefinedOwner().clear();
            }
        }
        this.touchImport();
    }

    String getDefaultPortal() {
        return this.defaultPortal;
    }

    NewPortalConfig getPortalConfig(String ownerType, String template) {
        for (NewPortalConfig portalConfig : this.configs) {
            if (!portalConfig.getOwnerType().equals(ownerType)) continue;
            return new NewPortalConfig(portalConfig);
        }
        return null;
    }

    public void mergePlugin(NewPortalConfigListener other) {
        ArrayList<Object> result;
        if (other.defaultPortalSpecified) {
            this.defaultPortal = other.defaultPortal;
        }
        if (this.configs == null) {
            this.configs = other.configs;
        } else if (other.configs != null && !other.configs.isEmpty()) {
            result = new ArrayList<NewPortalConfig>(this.configs);
            result.addAll(other.configs);
            this.configs = Collections.unmodifiableList(result);
        }
        if (this.templateConfigs == null) {
            this.templateConfigs = other.templateConfigs;
        } else if (other.templateConfigs != null && !other.templateConfigs.isEmpty()) {
            result = new ArrayList<SiteConfigTemplates>(this.templateConfigs);
            result.addAll(other.templateConfigs);
            this.templateConfigs = Collections.unmodifiableList(result);
        }
        this.overrideExistingData = this.overrideExistingData || other.overrideExistingData;
    }

    public void deleteListenerElements(NewPortalConfigListener other) {
        ArrayList<Object> result;
        if (this.configs == null) {
            this.log.warn((Object)"No Portal configurations was loaded, nothing to delete !");
        } else if (other.configs != null && !other.configs.isEmpty()) {
            result = new ArrayList<NewPortalConfig>(this.configs);
            for (NewPortalConfig newPortalConfigToDelete : other.configs) {
                int i = 0;
                while (i < result.size()) {
                    NewPortalConfig newPortalConfig = (NewPortalConfig)result.get(i);
                    if (newPortalConfigToDelete.getOwnerType().equals(newPortalConfig.getOwnerType())) {
                        for (String owner : newPortalConfigToDelete.getPredefinedOwner()) {
                            newPortalConfig.getPredefinedOwner().remove(owner);
                        }
                    }
                    if (newPortalConfig.getPredefinedOwner().size() == 0) {
                        result.remove(newPortalConfig);
                        continue;
                    }
                    ++i;
                }
            }
            this.configs = Collections.unmodifiableList(result);
        }
        if (this.templateConfigs == null) {
            this.log.warn((Object)"No Portal templates configurations was loaded, nothing to delete !");
        } else if (other.templateConfigs != null && !other.templateConfigs.isEmpty()) {
            result = new ArrayList<SiteConfigTemplates>(this.templateConfigs);
            this.deleteSiteConfigTemplates(other, result, PortalConfig.PORTAL_TYPE);
            this.deleteSiteConfigTemplates(other, result, PortalConfig.GROUP_TYPE);
            this.deleteSiteConfigTemplates(other, result, PortalConfig.USER_TYPE);
            this.templateConfigs = Collections.unmodifiableList(result);
        }
    }

    private void deleteSiteConfigTemplates(NewPortalConfigListener other, List<SiteConfigTemplates> result, String templateType) {
        for (SiteConfigTemplates siteConfigTemplatesToDelete : other.templateConfigs) {
            Set<String> portalTemplatesToDelete = siteConfigTemplatesToDelete.getTemplates(templateType);
            if (portalTemplatesToDelete == null || portalTemplatesToDelete.size() <= 0) continue;
            int i = 0;
            while (i < result.size()) {
                SiteConfigTemplates siteConfigTemplates = result.get(i);
                Set<String> portalTemplates = siteConfigTemplates.getTemplates(templateType);
                if (portalTemplatesToDelete != null && portalTemplatesToDelete.size() > 0) {
                    portalTemplates.removeAll(portalTemplatesToDelete);
                }
                if (!(siteConfigTemplates.getTemplates(PortalConfig.PORTAL_TYPE) != null && siteConfigTemplates.getTemplates(PortalConfig.PORTAL_TYPE).size() != 0 || siteConfigTemplates.getTemplates(PortalConfig.GROUP_TYPE) != null && siteConfigTemplates.getTemplates(PortalConfig.GROUP_TYPE).size() != 0 || siteConfigTemplates.getTemplates(PortalConfig.USER_TYPE) != null && siteConfigTemplates.getTemplates(PortalConfig.USER_TYPE).size() != 0)) {
                    result.remove(siteConfigTemplates);
                    continue;
                }
                ++i;
            }
        }
    }

    public void initPortalConfigDB(NewPortalConfig config) throws Exception {
        for (String owner : config.getPredefinedOwner()) {
            if (!this.createPortalConfig(config, owner)) continue;
            this.createdOwners.add(owner);
        }
    }

    public void initPageDB(NewPortalConfig config) throws Exception {
        for (String owner : config.getPredefinedOwner()) {
            if (!this.createdOwners.contains(owner)) continue;
            this.createPage(config, owner);
        }
    }

    public void initPageNavigationDB(NewPortalConfig config) throws Exception {
        for (String owner : config.getPredefinedOwner()) {
            this.createPageNavigation(config, owner);
        }
    }

    public boolean createPortalConfig(NewPortalConfig config, String owner) throws Exception {
        PortalConfig pConfig;
        String type = config.getOwnerType();
        UnmarshalledObject<PortalConfig> obj = this.getConfig(config, owner, type, PortalConfig.class);
        if (obj == null) {
            String fixedName = NewPortalConfigListener.fixOwnerName(type, owner);
            if (this.dataStorage_.getPortalConfig(type, fixedName) != null) {
                return true;
            }
            pConfig = new PortalConfig(type, fixedName);
        } else {
            pConfig = obj.getObject();
        }
        ImportMode importMode = this.getRightMode(config.getImportMode());
        PortalConfigImporter portalImporter = new PortalConfigImporter(importMode, pConfig, this.dataStorage_);
        try {
            portalImporter.perform();
            return true;
        }
        catch (Exception ex) {
            this.log.error((Object)("An Exception occured when creating the Portal Configuration. Exception message: " + ex.getMessage()), (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPage(NewPortalConfig config, String owner) throws Exception {
        UnmarshalledObject<Page.PageSet> pageSet = this.getConfig(config, owner, "pages", Page.PageSet.class);
        if (pageSet == null) {
            return;
        }
        ArrayList<Page> list = pageSet.getObject().getPages();
        for (Page page : list) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                ImportMode importMode = this.getRightMode(config.getImportMode());
                PageImporter importer = new PageImporter(importMode, page, this.dataStorage_, this.pageService_);
                importer.perform();
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void createPageNavigation(NewPortalConfig config, String owner) throws Exception {
        UnmarshalledObject<PageNavigation> obj = this.getConfig(config, owner, "navigation", PageNavigation.class);
        if (obj == null) {
            return;
        }
        PageNavigation navigation = obj.getObject();
        ImportMode importMode = this.getRightMode(config.getImportMode());
        PortalConfig portalConfig = this.dataStorage_.getPortalConfig(config.getOwnerType(), owner);
        Locale locale = portalConfig != null && portalConfig.getLocale() != null ? new Locale(portalConfig.getLocale()) : Locale.ENGLISH;
        NavigationImporter merge = new NavigationImporter(locale, importMode, navigation, this.navigationService_, this.descriptionService_);
        merge.perform();
    }

    private <T> UnmarshalledObject<T> getConfig(NewPortalConfig config, String owner, String fileName, Class<T> type) throws Exception {
        this.log.debug((Object)("About to load config=" + config + " owner=" + owner + " fileName=" + fileName));
        String ownerType = config.getOwnerType();
        String path = "/" + ownerType + "/" + owner + "/" + fileName + ".xml";
        String xml = this.getDefaultConfig(config.getTemplateLocation(), path);
        if (xml == null) {
            String templateName = config.getTemplateName() != null ? config.getTemplateName() : fileName;
            path = "/" + ownerType + "/template/" + templateName + "/" + fileName + ".xml";
            xml = this.getDefaultConfig(config.getTemplateLocation(), path);
            if (xml != null) {
                xml = this.OWNER_PATTERN.matcher(xml).replaceAll(owner);
            }
        }
        if (xml != null) {
            boolean ok = false;
            try {
                UnmarshalledObject<T> o = this.fromXML(config.getOwnerType(), owner, xml, type);
                ok = true;
                UnmarshalledObject<T> unmarshalledObject = o;
                return unmarshalledObject;
            }
            catch (JiBXException e) {
                this.log.error((Object)(e.getMessage() + " file: " + path), (Throwable)e);
                throw e;
            }
            finally {
                if (!ok) {
                    this.log.error((Object)("Could not load file: " + path));
                }
            }
        }
        return null;
    }

    private String getDefaultConfig(String location, String path) {
        String s = location + path;
        String content = null;
        try {
            this.log.debug((Object)("Attempt to load file " + s));
            content = IOUtil.getStreamContentAsString((InputStream)this.cmanager_.getInputStream(s));
            this.log.debug((Object)("Loaded file from path " + s + " with content " + content));
        }
        catch (Exception ignore) {
            this.log.debug((Object)("Could not get file " + s + " will return null instead"));
        }
        return content;
    }

    public Page createPageFromTemplate(String ownerType, String owner, String temp) throws Exception {
        String path = this.pageTemplatesLocation_ + "/" + temp + "/page.xml";
        InputStream is = this.cmanager_.getInputStream(path);
        String xml = IOUtil.getStreamContentAsString((InputStream)is);
        return this.fromXML(ownerType, owner, xml, Page.class).getObject();
    }

    public String getTemplateConfig(String type, String name) {
        for (SiteConfigTemplates tempConfig : this.templateConfigs) {
            Set<String> templates = tempConfig.getTemplates(type);
            if (templates == null || !templates.contains(name)) continue;
            return tempConfig.getLocation();
        }
        return null;
    }

    public Set<String> getTemplateConfigs(String siteType) {
        HashSet<String> result = new HashSet<String>();
        for (SiteConfigTemplates tempConfig : this.templateConfigs) {
            Set<String> templates = tempConfig.getTemplates(siteType);
            if (templates == null || templates.size() <= 0) continue;
            result.addAll(templates);
        }
        return result;
    }

    public PortalConfig getPortalConfigFromTemplate(String siteType, String templateName) {
        String templatePath = this.getTemplateConfig(siteType, templateName);
        NewPortalConfig config = new NewPortalConfig(templatePath);
        config.setTemplateName(templateName);
        config.setOwnerType(siteType);
        UnmarshalledObject<PortalConfig> result = null;
        try {
            result = this.getConfig(config, templateName, siteType, PortalConfig.class);
            if (result != null) {
                return result.getObject();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Cannot find configuration of template: " + templateName));
        }
        return null;
    }

    private <T> UnmarshalledObject<T> fromXML(String ownerType, String owner, String xml, Class<T> clazz) throws Exception {
        UnmarshalledObject<T> obj = ModelUnmarshaller.unmarshall(clazz, xml.getBytes("UTF-8"));
        T o = obj.getObject();
        if (o instanceof PageNavigation) {
            PageNavigation nav = (PageNavigation)o;
            nav.setOwnerType(ownerType);
            nav.setOwnerId(owner);
            NewPortalConfigListener.fixOwnerName((PageNavigation)o);
        } else if (o instanceof PortalConfig) {
            PortalConfig portalConfig = (PortalConfig)o;
            portalConfig.setType(ownerType);
            portalConfig.setName(owner);
            NewPortalConfigListener.fixOwnerName(portalConfig);
        } else if (o instanceof Page.PageSet) {
            for (Page page : ((Page.PageSet)o).getPages()) {
                page.setOwnerType(ownerType);
                page.setOwnerId(owner);
                NewPortalConfigListener.fixOwnerName(page);
            }
        }
        return obj;
    }

    private static String fixOwnerName(String type, String owner) {
        if (type.equals(PortalConfig.GROUP_TYPE) && !owner.startsWith("/")) {
            return "/" + owner;
        }
        return owner;
    }

    private static void fixOwnerName(PortalConfig config) {
        config.setName(NewPortalConfigListener.fixOwnerName(config.getType(), config.getName()));
        NewPortalConfigListener.fixOwnerName(config.getPortalLayout());
    }

    private static void fixOwnerName(Container container) {
        for (ModelObject o : container.getChildren()) {
            if (!(o instanceof Container)) continue;
            NewPortalConfigListener.fixOwnerName((Container)o);
        }
    }

    private static void fixOwnerName(PageNavigation pageNav) {
        pageNav.setOwnerId(NewPortalConfigListener.fixOwnerName(pageNav.getOwnerType(), pageNav.getOwnerId()));
        ArrayList<NavigationFragment> fragments = pageNav.getFragments();
        if (fragments != null) {
            for (NavigationFragment fragment : fragments) {
                NewPortalConfigListener.fixOwnerName(fragment);
            }
        }
    }

    private static void fixOwnerName(NavigationFragment fragment) {
        ArrayList<PageNode> nodes = fragment.getNodes();
        if (nodes != null) {
            for (PageNode pageNode : nodes) {
                NewPortalConfigListener.fixOwnerName(pageNode);
            }
        }
    }

    private static void fixOwnerName(PageNode pageNode) {
        if (pageNode.getPageReference() != null) {
            String pageRef = pageNode.getPageReference();
            int pos1 = pageRef.indexOf("::");
            int pos2 = pageRef.indexOf("::", pos1 + 2);
            String type = pageRef.substring(0, pos1);
            String owner = pageRef.substring(pos1 + 2, pos2);
            String name = pageRef.substring(pos2 + 2);
            owner = NewPortalConfigListener.fixOwnerName(type, owner);
            pageRef = type + "::" + owner + "::" + name;
            pageNode.setPageReference(pageRef);
        }
        if (pageNode.getNodes() != null) {
            for (PageNode childPageNode : pageNode.getNodes()) {
                NewPortalConfigListener.fixOwnerName(childPageNode);
            }
        }
    }

    private static void fixOwnerName(Page page) {
        page.setOwnerId(NewPortalConfigListener.fixOwnerName(page.getOwnerType(), page.getOwnerId()));
        NewPortalConfigListener.fixOwnerName((Container)page);
    }

    private ImportMode getRightMode(String mode) {
        ImportMode importMode = mode != null ? ImportMode.valueOf(mode.trim().toUpperCase()) : this.owner_.getDefaultImportMode();
        if (this.isFirstStartup && (importMode == ImportMode.CONSERVE || importMode == ImportMode.INSERT)) {
            return ImportMode.MERGE;
        }
        return importMode;
    }
}

