/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.activities;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ActivitiesUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private DMSConfiguration dmsConfiguration_;
    private RepositoryService repoService_;
    private ManageViewService viewService_;

    public ActivitiesUpgradePlugin(RepositoryService repoService, DMSConfiguration dmsConfiguration, ManageViewService viewService, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
        this.dmsConfiguration_ = dmsConfiguration;
        this.viewService_ = viewService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        block9: {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            }
            Session session = null;
            try {
                session = WCMCoreUtils.getSystemSessionProvider().getSession("social", this.repoService_.getCurrentRepository());
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"=====Start migrate data for all activities=====");
                }
                String statement = "SELECT * FROM soc:activity WHERE soc:type = 'contents:spaces'";
                QueryResult result = session.getWorkspace().getQueryManager().createQuery(statement, "sql").execute();
                NodeIterator nodeIter = result.getNodes();
                while (nodeIter.hasNext()) {
                    Node viewNode = nodeIter.nextNode();
                    Node paramsNode = viewNode.getNode("soc:params");
                    String workspace = paramsNode.getProperty("workspace").getString();
                    String nodeUrl = viewNode.getProperty("soc:url").getString();
                    Session session2 = WCMCoreUtils.getSystemSessionProvider().getSession(workspace, this.repoService_.getCurrentRepository());
                    try {
                        Node node = (Node)session2.getItem(nodeUrl);
                        if (node.isNodeType("nt:file")) {
                            viewNode.setProperty("soc:type", "files:spaces");
                        }
                        session2.save();
                    }
                    catch (PathNotFoundException ex) {}
                }
                session.save();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"=====Completed the migration data for user views=====");
                }
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block9;
                this.log.error((Object)"An unexpected error occurs when migrating activities: ", (Throwable)e);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

