/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainChangesLogImpl
implements Externalizable,
PlainChangesLog {
    private static final int NULL_VALUE = -1;
    private static final int NOT_NULL_VALUE = 1;
    private static final long serialVersionUID = 5624550860372364084L;
    protected List<ItemState> items;
    protected String sessionId;
    protected int eventType;
    protected ExtendedSession session;
    protected Map<Object, ItemState> index = new HashMap<Object, ItemState>();
    protected Map<String, Map<String, ItemState>> lastChildNodeStates = new HashMap<String, Map<String, ItemState>>();
    protected Map<String, Map<String, ItemState>> lastChildPropertyStates = new HashMap<String, Map<String, ItemState>>();
    protected Map<String, List<ItemState>> childNodeStates = new HashMap<String, List<ItemState>>();
    protected Map<String, List<ItemState>> childPropertyStates = new HashMap<String, List<ItemState>>();
    protected Map<String, int[]> childNodesInfo = new HashMap<String, int[]>();
    protected final int CHILD_NODES_COUNT = 0;
    protected final int CHILD_NODES_LAST_ORDER_NUMBER = 1;
    protected String pairId;

    public PlainChangesLogImpl(List<ItemState> items, ExtendedSession session, int eventType) {
        this(items, session.getId(), eventType, null, session);
    }

    public PlainChangesLogImpl(List<ItemState> items, String sessionId, int eventType) {
        this(items, sessionId, eventType, null, null);
    }

    public PlainChangesLogImpl(List<ItemState> items, ExtendedSession session) {
        this(items, session, -1);
    }

    public PlainChangesLogImpl(ExtendedSession session) {
        this(new ArrayList<ItemState>(), session);
    }

    public PlainChangesLogImpl(String sessionId) {
        this(new ArrayList<ItemState>(), sessionId, -1);
    }

    public PlainChangesLogImpl() {
        this(new ArrayList<ItemState>(), (String)null, -1);
    }

    @Override
    public List<ItemState> getAllStates() {
        return this.items;
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public int getEventType() {
        return this.eventType;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public ExtendedSession getSession() {
        return this.session;
    }

    @Override
    public PlainChangesLog add(ItemState change) {
        this.items.add(change);
        this.addItem(change);
        return this;
    }

    @Override
    public PlainChangesLog addAll(List<ItemState> changes) {
        this.items.addAll(changes);
        int length = changes.size();
        for (int i = 0; i < length; ++i) {
            this.addItem(changes.get(i));
        }
        return this;
    }

    public void clear() {
        this.items.clear();
        this.index.clear();
        this.lastChildNodeStates.clear();
        this.lastChildPropertyStates.clear();
        this.childNodeStates.clear();
        this.childPropertyStates.clear();
        this.childNodesInfo.clear();
    }

    @Override
    public String getPairId() {
        return this.pairId;
    }

    @Override
    public String dump() {
        StringBuilder str = new StringBuilder("ChangesLog: \n");
        for (int i = 0; i < this.items.size(); ++i) {
            str.append(" ").append(ItemState.nameFromValue(this.items.get(i).getState())).append("\t").append(this.items.get(i).getData().getIdentifier());
            str.append("\t").append("isPersisted=").append(this.items.get(i).isPersisted()).append("\t").append("isEventFire=");
            str.append(this.items.get(i).isEventFire()).append("\t").append("isInternallyCreated=").append(this.items.get(i).isInternallyCreated()).append("\t");
            str.append(this.items.get(i).getData().getQPath().getAsString()).append("\n");
        }
        return str.toString();
    }

    protected PlainChangesLogImpl(List<ItemState> items, String sessionId, int eventType, String pairId, ExtendedSession session) {
        this.session = session;
        this.sessionId = sessionId;
        this.eventType = eventType;
        this.pairId = pairId;
        this.items = new ArrayList<ItemState>();
        this.addAll(items);
    }

    public static PlainChangesLogImpl createCopy(List<ItemState> items, PlainChangesLog originalLog) {
        return PlainChangesLogImpl.createCopy(items, originalLog.getPairId(), originalLog);
    }

    public static PlainChangesLogImpl createCopy(List<ItemState> items, String pairId, PlainChangesLog originalLog) {
        if (originalLog.getSession() != null) {
            return new PlainChangesLogImpl(items, originalLog.getSession().getId(), originalLog.getEventType(), pairId, originalLog.getSession());
        }
        return new PlainChangesLogImpl(items, originalLog.getSessionId(), originalLog.getEventType(), pairId, null);
    }

    public void remove(ItemState item) {
        if (item.isNode()) {
            this.remove(item.getData().getQPath());
        } else {
            this.removeProperty(item);
        }
    }

    protected void addItem(ItemState item) {
        Map<String, ItemState> children;
        this.index.put(item.getData().getIdentifier(), item);
        this.index.put(item.getData().getQPath(), item);
        this.index.put(new ParentIDQPathBasedKey(item), item);
        this.index.put(new IDStateBasedKey(item.getData().getIdentifier(), item.getState()), item);
        if (item.getData().isNode()) {
            children = this.lastChildNodeStates.get(item.getData().getParentIdentifier());
            if (children == null) {
                children = new HashMap<String, ItemState>();
                this.lastChildNodeStates.put(item.getData().getParentIdentifier(), children);
            }
            children.put(item.getData().getIdentifier(), item);
            List<ItemState> listItemState = this.childNodeStates.get(item.getData().getParentIdentifier());
            if (listItemState == null) {
                listItemState = new ArrayList<ItemState>();
                this.childNodeStates.put(item.getData().getParentIdentifier(), listItemState);
            }
            listItemState.add(item);
        } else {
            children = this.lastChildPropertyStates.get(item.getData().getParentIdentifier());
            if (children == null) {
                children = new HashMap<String, ItemState>();
                this.lastChildPropertyStates.put(item.getData().getParentIdentifier(), children);
            }
            children.put(item.getData().getIdentifier(), item);
            List<ItemState> listItemState = this.childPropertyStates.get(item.getData().getParentIdentifier());
            if (listItemState == null) {
                listItemState = new ArrayList<ItemState>();
                this.childPropertyStates.put(item.getData().getParentIdentifier(), listItemState);
            }
            listItemState.add(item);
        }
        if (item.isNode() && item.isPersisted()) {
            int[] childInfo = this.childNodesInfo.get(item.getData().getParentIdentifier());
            if (childInfo == null) {
                childInfo = new int[2];
            }
            if (item.isDeleted()) {
                childInfo[0] = childInfo[0] - 1;
            } else if (item.isAdded()) {
                childInfo[0] = childInfo[0] + 1;
                childInfo[1] = ((NodeData)item.getData()).getOrderNumber();
            }
            this.childNodesInfo.put(item.getData().getParentIdentifier(), childInfo);
        }
    }

    public int getChildNodesCount(String rootIdentifier) {
        int[] childInfo = this.childNodesInfo.get(rootIdentifier);
        return childInfo == null ? 0 : childInfo[0];
    }

    public int getLastChildOrderNumber(String rootIdentifier) {
        int[] childInfo = this.childNodesInfo.get(rootIdentifier);
        return childInfo == null ? -1 : childInfo[1];
    }

    public void remove(QPath rootPath) {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            ItemState item = this.items.get(i);
            QPath qPath = item.getData().getQPath();
            if (!qPath.isDescendantOf(rootPath) && !item.getAncestorToSave().isDescendantOf(rootPath) && !item.getAncestorToSave().equals(rootPath) && !qPath.equals(rootPath)) continue;
            if (item.isNode()) {
                this.removeNode(item);
                continue;
            }
            this.removeProperty(item);
        }
    }

    private void removeNode(ItemState item) {
        List<ItemState> listItemStates;
        Map<String, ItemState> children;
        int[] childInfo;
        this.items.remove(item);
        this.index.remove(item.getData().getIdentifier());
        this.index.remove(item.getData().getQPath());
        this.index.remove(new ParentIDQPathBasedKey(item));
        this.index.remove(new IDStateBasedKey(item.getData().getIdentifier(), item.getState()));
        this.childNodesInfo.remove(item.getData().getIdentifier());
        this.lastChildNodeStates.remove(item.getData().getIdentifier());
        this.childNodeStates.remove(item.getData().getIdentifier());
        if (item.isPersisted() && (childInfo = this.childNodesInfo.get(item.getData().getParentIdentifier())) != null) {
            if (item.isDeleted()) {
                childInfo[0] = childInfo[0] + 1;
            } else if (item.isAdded()) {
                childInfo[0] = childInfo[0] - 1;
            }
            this.childNodesInfo.put(item.getData().getParentIdentifier(), childInfo);
        }
        if ((children = this.lastChildNodeStates.get(item.getData().getParentIdentifier())) != null) {
            children.remove(item.getData().getIdentifier());
        }
        if ((listItemStates = this.childNodeStates.get(item.getData().getParentIdentifier())) != null) {
            listItemStates.remove(item);
        }
    }

    private void removeProperty(ItemState item) {
        List<ItemState> listItemStates;
        this.items.remove(item);
        this.index.remove(item.getData().getIdentifier());
        this.index.remove(item.getData().getQPath());
        this.index.remove(new ParentIDQPathBasedKey(item));
        this.index.remove(new IDStateBasedKey(item.getData().getIdentifier(), item.getState()));
        this.lastChildPropertyStates.remove(item.getData().getIdentifier());
        this.childPropertyStates.remove(item.getData().getIdentifier());
        Map<String, ItemState> children = this.lastChildPropertyStates.get(item.getData().getParentIdentifier());
        if (children != null) {
            children.remove(item.getData().getIdentifier());
        }
        if ((listItemStates = this.childPropertyStates.get(item.getData().getParentIdentifier())) != null) {
            listItemStates.remove(item);
        }
    }

    public Collection<ItemState> getLastChildrenStates(ItemData rootData, boolean forNodes) {
        Map<String, ItemState> children = forNodes ? this.lastChildNodeStates.get(rootData.getIdentifier()) : this.lastChildPropertyStates.get(rootData.getIdentifier());
        return children == null ? new ArrayList() : children.values();
    }

    public ItemState getLastState(ItemData item, boolean forNode) {
        Map<String, ItemState> children = forNode ? this.lastChildNodeStates.get(item.getParentIdentifier()) : this.lastChildPropertyStates.get(item.getParentIdentifier());
        return children == null ? null : children.get(item.getIdentifier());
    }

    public List<ItemState> getChildrenChanges(String rootIdentifier, boolean forNodes) {
        ArrayList children = forNodes ? this.childNodeStates.get(rootIdentifier) : this.childPropertyStates.get(rootIdentifier);
        return children == null ? new ArrayList() : children;
    }

    public ItemState getItemState(String itemIdentifier, int state) {
        return this.index.get(new IDStateBasedKey(itemIdentifier, state));
    }

    public ItemState getItemState(String itemIdentifier) {
        return this.index.get(itemIdentifier);
    }

    public ItemState getItemState(QPath itemPath) {
        return this.index.get(itemPath);
    }

    public ItemState getItemState(NodeData parentData, QPathEntry name, ItemType itemType) throws IllegalPathException {
        if (itemType != ItemType.UNKNOWN) {
            return this.index.get(new ParentIDQPathBasedKey(parentData.getIdentifier(), name, itemType));
        }
        ItemState state = this.index.get(new ParentIDQPathBasedKey(parentData.getIdentifier(), name, ItemType.NODE));
        if (state == null) {
            state = this.index.get(new ParentIDQPathBasedKey(parentData.getIdentifier(), name, ItemType.PROPERTY));
        }
        return state;
    }

    public List<ItemState> getDescendantsChanges(QPath rootPath) {
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        if (rootPath.equals(Constants.ROOT_PATH)) {
            list.addAll(this.items);
        } else {
            int length = this.items.size();
            for (int i = 0; i < length; ++i) {
                ItemState item = this.items.get(i);
                if (!item.isDescendantOf(rootPath)) continue;
                list.add(item);
            }
        }
        return list;
    }

    public List<ItemState> getItemStates(String itemIdentifier) {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        List<ItemState> currentStates = this.getAllStates();
        int length = currentStates.size();
        for (int i = 0; i < length; ++i) {
            ItemState state = currentStates.get(i);
            if (!state.getData().getIdentifier().equals(itemIdentifier)) continue;
            states.add(state);
        }
        return states;
    }

    public Collection<ItemState> getLastModifyStates(NodeData rootData) {
        HashMap<String, ItemState> changes = new HashMap<String, ItemState>();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemData item = this.items.get(i).getData();
            if (item.getIdentifier().equals(rootData.getIdentifier())) {
                if (this.items.get(i).isAdded()) {
                    return new ArrayList<ItemState>();
                }
                if (this.items.get(i).isDeleted()) continue;
                changes.put(item.getIdentifier(), this.items.get(i));
                continue;
            }
            if (!item.getParentIdentifier().equals(rootData.getIdentifier())) continue;
            changes.put(item.getIdentifier(), this.items.get(i));
        }
        return changes.values();
    }

    public ItemState findItemState(String id, Boolean isPersisted, int ... states) throws IllegalPathException {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState istate = allStates.get(i);
            boolean byState = false;
            if (states != null) {
                for (int state : states) {
                    if (istate.getState() != state) continue;
                    byState = true;
                    break;
                }
            } else {
                byState = true;
            }
            if (!byState || isPersisted != null && istate.isPersisted() != isPersisted.booleanValue() || !istate.getData().getIdentifier().equals(id)) continue;
            return istate;
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.eventType);
        byte[] buff = this.sessionId.getBytes("UTF-8");
        out.writeInt(buff.length);
        out.write(buff);
        int listSize = this.items.size();
        out.writeInt(listSize);
        for (int i = 0; i < listSize; ++i) {
            out.writeObject(this.items.get(i));
        }
        if (this.pairId != null) {
            out.writeInt(1);
            buff = this.pairId.getBytes("UTF-8");
            out.writeInt(buff.length);
            out.write(buff);
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.eventType = in.readInt();
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        this.sessionId = new String(buf, "UTF-8");
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            this.add((ItemState)in.readObject());
        }
        if (in.readInt() == 1) {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            this.pairId = new String(buf, "UTF-8");
        }
    }

    protected class ParentIDQPathBasedKey {
        private final QPathEntry name;
        private final String parentIdentifier;
        private final ItemType itemType;

        public ParentIDQPathBasedKey(ItemState item) {
            this.name = item.getData().getQPath().getEntries()[item.getData().getQPath().getEntries().length - 1];
            this.parentIdentifier = item.getData().getParentIdentifier();
            this.itemType = ItemType.getItemType(item.getData());
        }

        ParentIDQPathBasedKey(String parentIdentifier, QPathEntry name, ItemType itemType) {
            this.name = name;
            this.parentIdentifier = parentIdentifier;
            this.itemType = itemType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.getName().hashCode();
            result = 31 * result + this.name.getNamespace().hashCode();
            result = 31 * result + this.name.getIndex();
            result = 31 * result + (this.parentIdentifier == null ? 0 : this.parentIdentifier.hashCode());
            result = 31 * result + this.itemType.ordinal();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParentIDQPathBasedKey other = (ParentIDQPathBasedKey)obj;
            if (this.name == null ? other.name != null : !this.name.getName().equals(other.name.getName()) || !this.name.getNamespace().equals(other.name.getNamespace()) || this.name.getIndex() != other.name.getIndex()) {
                return false;
            }
            if (this.parentIdentifier == null ? other.parentIdentifier != null : !this.parentIdentifier.equals(other.parentIdentifier)) {
                return false;
            }
            return !(this.itemType == null ? other.itemType != null : !this.itemType.equals((Object)other.itemType));
        }
    }

    protected class IDStateBasedKey {
        private final String identifier;
        private final int state;

        public IDStateBasedKey(String identifier, int state) {
            this.identifier = identifier;
            this.state = state;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.identifier.hashCode();
            result = 31 * result + this.state;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IDStateBasedKey other = (IDStateBasedKey)obj;
            if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
                return false;
            }
            return this.state == other.state;
        }
    }
}

