/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SybaseJDBCConnectionHelper;
import org.exoplatform.services.jcr.util.IdGenerator;

public class SybaseMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    protected String SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE;
    protected String COUNT_NODES_IN_TEMPORARY_TABLE;
    protected String SELECT_LIMIT_NODES_FROM_TEMPORARY_TABLE;
    protected String DELETE_TEMPORARY_TABLE_A;
    protected String DELETE_TEMPORARY_TABLE_B;
    protected PreparedStatement selectLimitOffsetNodesIntoTemporaryTable;
    protected PreparedStatement selectLimitNodesInTemporaryTable;
    protected PreparedStatement deleteTemporaryTableA;
    protected PreparedStatement deleteTemporaryTableB;
    protected PreparedStatement countNodesInTemporaryTable;

    public SybaseMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    protected String fixEscapeSymbols(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': {
                    sb.append('%');
                    continue block4;
                }
                case '%': 
                case '[': 
                case ']': 
                case '_': {
                    sb.append(this.getWildcardEscapeSymbold());
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM into #tempA from " + this.JCR_ITEM + " I (index " + this.JCR_PK_ITEM + ") where I.I_CLASS=1 AND I.ID > ? order by I.ID ASC";
        this.COUNT_NODES_IN_TEMPORARY_TABLE = "select count(*) from #tempA";
        this.SELECT_LIMIT_NODES_FROM_TEMPORARY_TABLE = "select * into #tempB from #tempA order by #tempA.ID DESC";
        this.FIND_NODES_AND_PROPERTIES = "select #tempB.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from " + this.JCR_VALUE + " V, " + this.JCR_ITEM + " P, " + "#tempB" + " where P.PARENT_ID = " + "#tempB" + ".ID and P.I_CLASS=2 and V.PROPERTY_ID=P.ID " + "order by " + "#tempB" + ".ID";
        this.DELETE_TEMPORARY_TABLE_A = "drop table #tempA";
        this.DELETE_TEMPORARY_TABLE_B = "drop table #tempB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        SQLException e222;
        ResultSet resultSet;
        boolean tempTableBCreated;
        String tempTableBName;
        block36: {
            int newLimit;
            int count;
            boolean tempTableACreated;
            String tempTableAName;
            block33: {
                SQLException e222;
                SybaseJDBCConnectionHelper.EmptyResultSet emptyResultSet;
                block34: {
                    tempTableAName = "tempdb..a" + IdGenerator.generate();
                    tempTableBName = "tempdb..b" + IdGenerator.generate();
                    tempTableACreated = false;
                    tempTableBCreated = false;
                    try {
                        if (!this.dbConnection.getAutoCommit()) {
                            this.dbConnection.setAutoCommit(true);
                        }
                        this.selectLimitOffsetNodesIntoTemporaryTable = this.dbConnection.prepareStatement(this.SELECT_LIMIT_OFFSET_NODES_INTO_TEMPORARY_TABLE.replaceAll("#tempA", tempTableAName));
                        this.countNodesInTemporaryTable = this.dbConnection.prepareStatement(this.COUNT_NODES_IN_TEMPORARY_TABLE.replaceAll("#tempA", tempTableAName));
                        this.selectLimitNodesInTemporaryTable = this.dbConnection.prepareStatement(this.SELECT_LIMIT_NODES_FROM_TEMPORARY_TABLE.replaceAll("#tempA", tempTableAName).replaceAll("#tempB", tempTableBName));
                        if (this.findNodesAndProperties != null) {
                            this.findNodesAndProperties.close();
                        }
                        this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES.replaceAll("#tempB", tempTableBName));
                        this.deleteTemporaryTableA = this.dbConnection.prepareStatement(this.DELETE_TEMPORARY_TABLE_A.replaceAll("#tempA", tempTableAName));
                        this.deleteTemporaryTableB = this.dbConnection.prepareStatement(this.DELETE_TEMPORARY_TABLE_B.replaceAll("#tempB", tempTableBName));
                        this.selectLimitOffsetNodesIntoTemporaryTable.setMaxRows(limit + offset);
                        this.selectLimitOffsetNodesIntoTemporaryTable.setString(1, lastNodeId);
                        this.selectLimitOffsetNodesIntoTemporaryTable.execute();
                        tempTableACreated = true;
                        ResultSet nodesCountInTemporaryTable = this.countNodesInTemporaryTable.executeQuery();
                        if (!nodesCountInTemporaryTable.next()) {
                            throw new SQLException("Can not count nodes in temporary table.");
                        }
                        count = nodesCountInTemporaryTable.getInt(1);
                        newLimit = limit;
                        if (offset <= count) break block33;
                        emptyResultSet = new SybaseJDBCConnectionHelper.EmptyResultSet();
                        Object var13_13 = null;
                        if (!tempTableACreated) break block34;
                    }
                    catch (Throwable throwable) {
                        block38: {
                            SQLException e222;
                            Object var13_15 = null;
                            if (tempTableACreated) {
                                try {
                                    this.deleteTemporaryTableA.execute();
                                }
                                catch (SQLException e222) {
                                    LOG.warn((Object)("Can not delete temporary table " + tempTableAName));
                                }
                            }
                            if (tempTableBCreated) {
                                try {
                                    this.deleteTemporaryTableB.execute();
                                }
                                catch (SQLException e222) {
                                    LOG.warn((Object)("Can not delete temporary table " + tempTableBName));
                                }
                            }
                            if (this.selectLimitOffsetNodesIntoTemporaryTable != null) {
                                this.selectLimitOffsetNodesIntoTemporaryTable.close();
                            }
                            if (this.selectLimitNodesInTemporaryTable != null) {
                                this.selectLimitNodesInTemporaryTable.close();
                            }
                            if (this.deleteTemporaryTableA != null) {
                                this.deleteTemporaryTableA.close();
                            }
                            if (this.deleteTemporaryTableB != null) {
                                this.deleteTemporaryTableB.close();
                            }
                            if (this.countNodesInTemporaryTable == null) break block38;
                            this.countNodesInTemporaryTable.close();
                        }
                        throw throwable;
                    }
                    try {
                        this.deleteTemporaryTableA.execute();
                    }
                    catch (SQLException e222) {
                        LOG.warn((Object)("Can not delete temporary table " + tempTableAName));
                    }
                }
                if (tempTableBCreated) {
                    try {
                        this.deleteTemporaryTableB.execute();
                    }
                    catch (SQLException e222) {
                        LOG.warn((Object)("Can not delete temporary table " + tempTableBName));
                    }
                }
                if (this.selectLimitOffsetNodesIntoTemporaryTable != null) {
                    this.selectLimitOffsetNodesIntoTemporaryTable.close();
                }
                if (this.selectLimitNodesInTemporaryTable != null) {
                    this.selectLimitNodesInTemporaryTable.close();
                }
                if (this.deleteTemporaryTableA != null) {
                    this.deleteTemporaryTableA.close();
                }
                if (this.deleteTemporaryTableB != null) {
                    this.deleteTemporaryTableB.close();
                }
                if (this.countNodesInTemporaryTable != null) {
                    this.countNodesInTemporaryTable.close();
                }
                return emptyResultSet;
            }
            if (offset + limit > count) {
                newLimit = count - offset;
            }
            this.selectLimitNodesInTemporaryTable.setMaxRows(newLimit);
            this.selectLimitNodesInTemporaryTable.execute();
            tempTableBCreated = true;
            resultSet = this.findNodesAndProperties.executeQuery();
            Object var13_14 = null;
            if (!tempTableACreated) break block36;
            try {
                this.deleteTemporaryTableA.execute();
            }
            catch (SQLException e222) {
                LOG.warn((Object)("Can not delete temporary table " + tempTableAName));
            }
        }
        if (tempTableBCreated) {
            try {
                this.deleteTemporaryTableB.execute();
            }
            catch (SQLException e222) {
                LOG.warn((Object)("Can not delete temporary table " + tempTableBName));
            }
        }
        if (this.selectLimitOffsetNodesIntoTemporaryTable != null) {
            this.selectLimitOffsetNodesIntoTemporaryTable.close();
        }
        if (this.selectLimitNodesInTemporaryTable != null) {
            this.selectLimitNodesInTemporaryTable.close();
        }
        if (this.deleteTemporaryTableA != null) {
            this.deleteTemporaryTableA.close();
        }
        if (this.deleteTemporaryTableB != null) {
            this.deleteTemporaryTableB.close();
        }
        if (this.countNodesInTemporaryTable != null) {
            this.countNodesInTemporaryTable.close();
        }
        return resultSet;
    }
}

