/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.commons.utils.PrivilegedFileHelper;

public class BufferedDecoder
extends Base64.Decoder {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_READ_BUFFER_SIZE = 4096;
    private final int bufferSize;
    private File fileBuffer;
    private OutputStream out;

    public BufferedDecoder() {
        super(4096);
        this.bufferSize = 4096;
        this.out = new ByteArrayOutputStream(4096);
    }

    public BufferedDecoder(int bufferSize) {
        super(bufferSize);
        this.bufferSize = bufferSize;
        this.out = new ByteArrayOutputStream(4096);
    }

    public InputStream getInputStream() throws IOException {
        this.flush();
        if (this.out instanceof ByteArrayOutputStream) {
            return new ByteArrayInputStream(((ByteArrayOutputStream)this.out).toByteArray());
        }
        if (this.out instanceof BufferedOutputStream) {
            this.out.close();
            return new BufferedInputStream(PrivilegedFileHelper.fileInputStream((File)this.fileBuffer));
        }
        throw new IOException("unexpected change of buffer");
    }

    public void remove() throws IOException {
        if (this.fileBuffer != null && PrivilegedFileHelper.exists((File)this.fileBuffer) && !PrivilegedFileHelper.delete((File)this.fileBuffer)) {
            throw new IOException("Cannot remove file " + PrivilegedFileHelper.getAbsolutePath((File)this.fileBuffer) + " Close all streams.");
        }
    }

    public String toString() {
        if (this.out instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.out).toString();
        }
        if (this.out instanceof BufferedOutputStream) {
            try {
                this.out.close();
                BufferedInputStream is = new BufferedInputStream(PrivilegedFileHelper.fileInputStream((File)this.fileBuffer));
                StringBuffer fileData = new StringBuffer(4096);
                byte[] buf = new byte[this.bufferSize];
                int numRead = 0;
                while ((numRead = is.read(buf)) != -1) {
                    fileData.append(new String(buf, 0, numRead));
                }
                is.close();
                return fileData.toString();
            }
            catch (IOException e) {
                return "";
            }
        }
        return "";
    }

    private void swapBuffers() throws IOException {
        byte[] data = ((ByteArrayOutputStream)this.out).toByteArray();
        this.fileBuffer = PrivilegedFileHelper.createTempFile((String)"decoderBuffer", (String)".tmp");
        PrivilegedFileHelper.deleteOnExit((File)this.fileBuffer);
        this.out = new BufferedOutputStream(PrivilegedFileHelper.fileOutputStream((File)this.fileBuffer), this.bufferSize);
        this.out.write(data);
    }

    protected void writeBuffer(byte[] buffer, int start, int length) throws IOException {
        if (this.out instanceof ByteArrayOutputStream && ((ByteArrayOutputStream)this.out).size() + length > this.bufferSize) {
            this.swapBuffers();
        }
        this.out.write(buffer, start, length);
    }
}

