/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl.rdbms;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.core.BackupWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RdbmsWorkspaceInitializer
extends BackupWorkspaceInitializer {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RdbmsWorkspaceInitializer");
    protected final RepositoryService repositoryService;

    public RdbmsWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceRegistryImpl namespaceRegistry, LocationFactory locationFactory, NodeTypeManagerImpl nodeTypeManager, ValueFactoryImpl valueFactory, AccessManager accessManager, RepositoryService repositoryService) throws RepositoryConfigurationException, PathNotFoundException, RepositoryException {
        super(config, repConfig, dataManager, namespaceRegistry, locationFactory, nodeTypeManager, valueFactory, accessManager);
        this.repositoryService = repositoryService;
    }

    /*
     * Loose catch block
     */
    protected void doRestore() throws Throwable {
        block27: {
            ArrayList<DataRestore> dataRestorers = new ArrayList<DataRestore>();
            ManageableRepository repository = null;
            try {
                repository = this.repositoryService.getRepository(this.repositoryEntry.getName());
            }
            catch (RepositoryConfigurationException e) {
                throw new RepositoryException(e);
            }
            List backupableComponents = repository.getWorkspaceContainer(this.workspaceName).getComponentInstancesOfType(Backupable.class);
            ArrayList<WorkspaceContainerFacade> workspacesWaits4Resume = new ArrayList<WorkspaceContainerFacade>();
            Throwable throwable = null;
            if (!DBInitializerHelper.getDatabaseType(this.workspaceEntry).isMultiDatabase()) {
                for (WorkspaceEntry we : this.repositoryEntry.getWorkspaceEntries()) {
                    if (we.getName().equals(this.workspaceEntry.getName())) continue;
                    WorkspaceContainerFacade wsContainer = repository.getWorkspaceContainer(we.getName());
                    wsContainer.setState(3);
                    workspacesWaits4Resume.add(wsContainer);
                }
            }
            DataRestoreContext context = new DataRestoreContext(new String[]{"storage-dir"}, new Object[]{new File(this.restorePath)});
            for (Backupable component : backupableComponents) {
                dataRestorers.add(component.getDataRestorer(context));
            }
            for (DataRestore restorer : dataRestorers) {
                restorer.clean();
            }
            for (DataRestore restorer : dataRestorers) {
                restorer.restore();
            }
            for (DataRestore restorer : dataRestorers) {
                restorer.commit();
            }
            Object var11_13 = null;
            for (DataRestore restorer : dataRestorers) {
                try {
                    restorer.close();
                }
                catch (BackupException e) {
                    LOG.error((Object)"Can't close restorer", (Throwable)e);
                }
            }
            try {
                for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                    wsContainer.setState(1);
                }
            }
            catch (RepositoryException e) {
                if (throwable == null) {
                    LOG.error((Object)("Con not set ONLYNE state for repository " + repository.getConfiguration().getName()), (Throwable)e);
                    break block27;
                }
                throw new RepositoryException("Con not set ONLINE state for repository " + repository.getConfiguration().getName(), e);
            }
            break block27;
            {
                catch (Throwable e) {
                    throwable = e;
                    for (DataRestore restorer : dataRestorers) {
                        try {
                            restorer.rollback();
                        }
                        catch (BackupException e1) {
                            LOG.error((Object)"Can't rollback restorer", (Throwable)e1);
                        }
                    }
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                block28: {
                    Object var11_14 = null;
                    for (DataRestore restorer : dataRestorers) {
                        try {
                            restorer.close();
                        }
                        catch (BackupException e) {
                            LOG.error((Object)"Can't close restorer", (Throwable)e);
                        }
                    }
                    try {
                        for (WorkspaceContainerFacade wsContainer : workspacesWaits4Resume) {
                            wsContainer.setState(1);
                        }
                    }
                    catch (RepositoryException e) {
                        if (throwable == null) {
                            LOG.error((Object)("Con not set ONLYNE state for repository " + repository.getConfiguration().getName()), (Throwable)e);
                            break block28;
                        }
                        throw new RepositoryException("Con not set ONLINE state for repository " + repository.getConfiguration().getName(), e);
                    }
                }
                throw throwable2;
            }
        }
    }
}

