/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/jcr-xml-view")
public class XMLViewNodeRepresentationRenderer
implements ResourceContainer {
    protected RepositoryService repoService;
    protected SessionProviderService sessionProviderService;

    public XMLViewNodeRepresentationRenderer(RepositoryService repoService, SessionProviderService sessionProviderService) {
        this.repoService = repoService;
        this.sessionProviderService = sessionProviderService;
    }

    @GET
    @Path(value="/{viewType}/{repoName}/{repoPath:.*}/")
    public Response getXML(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @PathParam(value="viewType") String viewType, @Context UriInfo uriInfo) {
        ByteArrayOutputStream bos;
        try {
            ManageableRepository repo = this.repoService.getRepository(repoName);
            SessionProvider sp = this.sessionProviderService.getSessionProvider(null);
            if (sp == null) {
                throw new RepositoryException("SessionProvider is not properly set. Make the application callsSessionProviderService.setSessionProvider(..) somewhere before (for instance in Servlet Filter for WEB application)");
            }
            Session session = sp.getSession(this.workspaceName(repoPath), repo);
            bos = new ByteArrayOutputStream();
            if (viewType != null && (viewType.equalsIgnoreCase("system") || viewType.equalsIgnoreCase("sys"))) {
                session.exportSystemView(this.path(repoPath), bos, false, false);
            } else {
                session.exportDocumentView(this.path(repoPath), bos, false, false);
            }
        }
        catch (LoginException e) {
            return Response.status((int)403).entity((Object)e.getMessage()).build();
        }
        catch (NoSuchWorkspaceException e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        catch (RepositoryException e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        catch (RepositoryConfigurationException e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        catch (IOException e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok().entity((Object)bos.toByteArray()).type("text/xml").build();
    }

    protected String workspaceName(String repoPath) {
        return repoPath.split("/")[0];
    }

    protected String path(String repoPath) {
        String path = repoPath.substring(this.workspaceName(repoPath).length());
        if (!"".equals(path)) {
            return path;
        }
        return "/";
    }
}

