/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.organization.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.platform.organization.integration.EventType;
import org.exoplatform.platform.organization.integration.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.OrganizationServiceInitializer;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="Platform Organization Model Integration Service")
@NameTemplate(value={@Property(key="name", value="OrganizationIntegrationService"), @Property(key="service", value="extensions"), @Property(key="type", value="platform")})
@RESTEndpoint(path="orgsync")
public class OrganizationIntegrationService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(OrganizationIntegrationService.class);
    private static final Comparator<org.exoplatform.container.xml.ComponentPlugin> COMPONENT_PLUGIN_COMPARATOR = new Comparator<org.exoplatform.container.xml.ComponentPlugin>(){

        @Override
        public int compare(org.exoplatform.container.xml.ComponentPlugin o1, org.exoplatform.container.xml.ComponentPlugin o2) {
            return o1.getPriority() - o2.getPriority();
        }
    };
    public static final Comparator<Group> GROUP_COMPARATOR = new Comparator<Group>(){

        @Override
        public int compare(Group o1, Group o2) {
            if (o1.getId().contains(o2.getId())) {
                return 1;
            }
            if (o2.getId().contains(o1.getId())) {
                return -1;
            }
            return o2.getId().compareTo(o1.getId());
        }
    };
    private Map<String, UserEventListener> userDAOListeners_;
    private Map<String, GroupEventListener> groupDAOListeners_;
    private Map<String, MembershipEventListener> membershipDAOListeners_;
    private Map<String, UserProfileEventListener> userProfileListeners_;
    private OrganizationService organizationService;
    private RepositoryService repositoryService;
    private PortalContainer container;
    private boolean requestStarted = false;
    private boolean synchronizeGroups = false;

    public OrganizationIntegrationService(OrganizationService organizationService, RepositoryService repositoryService, ConfigurationManager manager, PortalContainer container, InitParams initParams) {
        Component organizationServiceComponent;
        ExternalComponentPlugins organizationServiceExternalComponentPlugins;
        this.organizationService = organizationService;
        this.repositoryService = repositoryService;
        this.container = container;
        this.userDAOListeners_ = new LinkedHashMap<String, UserEventListener>();
        this.groupDAOListeners_ = new LinkedHashMap<String, GroupEventListener>();
        this.membershipDAOListeners_ = new LinkedHashMap<String, MembershipEventListener>();
        this.userProfileListeners_ = new LinkedHashMap<String, UserProfileEventListener>();
        boolean hasExternalComponentPlugins = false;
        int nbExternalComponentPlugins = 0;
        try {
            organizationServiceExternalComponentPlugins = manager.getConfiguration().getExternalComponentPlugins(OrganizationIntegrationService.class.getName());
            if (organizationServiceExternalComponentPlugins != null && organizationServiceExternalComponentPlugins.getComponentPlugins() != null) {
                nbExternalComponentPlugins = organizationServiceExternalComponentPlugins.getComponentPlugins().size();
            }
            if ((organizationServiceComponent = manager.getComponent(OrganizationIntegrationService.class)) != null && organizationServiceComponent.getComponentPlugins() != null) {
                nbExternalComponentPlugins += organizationServiceComponent.getComponentPlugins().size();
            }
            hasExternalComponentPlugins = nbExternalComponentPlugins > 0;
        }
        catch (Exception e) {
            LOG.error((Object)"Test if this component has ExternalComponentPlugins generated an exception", (Throwable)e);
        }
        if (!hasExternalComponentPlugins) {
            try {
                organizationServiceExternalComponentPlugins = manager.getConfiguration().getExternalComponentPlugins(OrganizationService.class.getName());
                this.addComponentPlugin(organizationServiceExternalComponentPlugins.getComponentPlugins());
                organizationServiceComponent = manager.getComponent(OrganizationService.class);
                List organizationServicePlugins = organizationServiceComponent.getComponentPlugins();
                if (organizationServicePlugins != null) {
                    this.addComponentPlugin(organizationServicePlugins);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to add OrganizationService plugins", (Throwable)e);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("This component has already " + nbExternalComponentPlugins + " ExternalComponentPlugins"));
        }
        if (initParams != null) {
            if (initParams.containsKey((Object)"workspace")) {
                Util.WORKSPACE = initParams.getValueParam("workspace").getValue();
            } else {
                LOG.warn((Object)("'workspace' init param is empty, use default value: " + Util.WORKSPACE));
            }
            if (initParams.containsKey((Object)"synchronizeGroups")) {
                this.synchronizeGroups = Boolean.parseBoolean(initParams.getValueParam("synchronizeGroups").getValue());
            } else {
                LOG.warn((Object)"'synchronizeGroups' init param is empty, use default value: false");
            }
            if (initParams.containsKey((Object)"homePath")) {
                Util.HOME_PATH = initParams.getValueParam("homePath").getValue();
            } else {
                LOG.warn((Object)("'homePath' init param is empty, use default value: " + Util.HOME_PATH));
            }
        } else {
            LOG.warn((Object)("init params not set, use default values for 'homePath'[=" + Util.HOME_PATH + "] and 'workspace[=" + Util.WORKSPACE + "]'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            Util.init(session);
            if (this.synchronizeGroups) {
                this.syncAllGroups(EventType.ADDED.toString());
                this.syncAllGroups(EventType.DELETED.toString());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void stop() {
    }

    public void addComponentPlugin(List<org.exoplatform.container.xml.ComponentPlugin> plugins) {
        if (plugins == null) {
            return;
        }
        Collections.sort(plugins, COMPONENT_PLUGIN_COMPARATOR);
        for (org.exoplatform.container.xml.ComponentPlugin plugin : plugins) {
            try {
                Class<?> pluginClass = Class.forName(plugin.getType());
                ComponentPlugin cplugin = (ComponentPlugin)this.container.createComponent(pluginClass, plugin.getInitParams());
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
                this.addListenerPlugin(cplugin);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to instanciate component plugin " + plugin.getName() + ", type=" + plugin.getClass()), (Throwable)e);
            }
        }
    }

    public void addListenerPlugin(ComponentPlugin listener) {
        if (listener instanceof OrganizationServiceInitializer) {
            return;
        }
        if (listener instanceof UserEventListener) {
            this.userDAOListeners_.put(listener.getName(), (UserEventListener)listener);
        } else if (listener instanceof GroupEventListener) {
            this.groupDAOListeners_.put(listener.getName(), (GroupEventListener)listener);
        } else if (listener instanceof MembershipEventListener) {
            this.membershipDAOListeners_.put(listener.getName(), (MembershipEventListener)listener);
        } else if (listener instanceof UserProfileEventListener) {
            this.userProfileListeners_.put(listener.getName(), (UserProfileEventListener)listener);
        } else {
            LOG.warn((Object)("Unknown listener type : " + listener.getClass()));
        }
    }

    @Managed
    @ManagedDescription(value="invoke all organization model listeners. Becarefull, this could takes a lot of time.")
    @Impact(value=ImpactType.READ)
    public void syncAll() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"All groups, users, profiles and memberships listeners invocation.");
        }
        this.startRequest();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)" Search for non integrated Groups.");
            }
            this.syncAllGroups(EventType.ADDED.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)" Search for deleted Groups, but remain integrated.");
            }
            this.syncAllGroups(EventType.DELETED.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)" Search for non integrated Users.");
            }
            this.syncAllUsers(EventType.ADDED.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)" Search for deleted Users, but remain integrated.");
            }
            this.syncAllUsers(EventType.DELETED.toString());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        this.endRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="invoke all groups listeners")
    @Impact(value=ImpactType.READ)
    public void syncAllGroups(@ManagedDescription(value="Scan for added or deleted groups") @ManagedName(value="eventType") String eventType) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("All Groups listeners invocation, operation= " + eventType));
        }
        this.startRequest();
        ArrayList groups = new ArrayList(this.organizationService.getGroupHandler().getAllGroups());
        Collections.sort(groups, GROUP_COMPARATOR);
        EventType event = EventType.valueOf(eventType);
        switch (event) {
            case DELETED: {
                Collections.reverse(groups);
                Session session = null;
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    List<String> activatedGroups = Util.getActivatedGroups(session);
                    for (Group group : groups) {
                        activatedGroups.remove(group.getId());
                    }
                    for (String groupId : activatedGroups) {
                        this.syncGroup(groupId, eventType);
                    }
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            case UPDATED: {
                Session session = null;
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    List<String> activatedGroups = Util.getActivatedGroups(session);
                    for (String groupId : activatedGroups) {
                        this.syncGroup(groupId, eventType);
                    }
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            case ADDED: {
                Session session = null;
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    List<String> activatedGroups = Util.getActivatedGroups(session);
                    for (Group group : groups) {
                        if (activatedGroups.contains(group.getId())) continue;
                        this.syncGroup(group.getId(), eventType);
                    }
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
        }
        this.endRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="invoke a group listeners")
    @Impact(value=ImpactType.WRITE)
    public void syncGroup(@ManagedDescription(value="Group Id") @ManagedName(value="groupId") String groupId, @ManagedDescription(value="Event type ADDED, UPDATED or DELETED") @ManagedName(value="eventType") String eventType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\tGroup listeners invocation, operation= " + eventType + ", for group= " + groupId));
        }
        this.startRequest();
        EventType event = EventType.valueOf(eventType);
        switch (event) {
            case DELETED: {
                Session session = null;
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    List<Group> groups = Util.getActivatedChildrenGroup(session, groupId);
                    Collections.sort(groups, GROUP_COMPARATOR);
                    Collections.reverse(groups);
                    for (Group group : groups) {
                        this.invokeDeleteGroupListeners(group.getId());
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error during recovery of activated chidren group ", (Throwable)e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
                this.invokeDeleteGroupListeners(groupId);
                break;
            }
            case UPDATED: 
            case ADDED: {
                try {
                    Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
                    if (group == null) {
                        LOG.warn((Object)("\t\t" + groupId + " group wasn't found."));
                        return;
                    }
                    this.invokeListenersToSavedGroup(group, event.equals((Object)EventType.ADDED));
                    break;
                }
                catch (Exception e) {
                    LOG.error((Object)("\t\tError occured while invoking listeners of group: " + groupId), (Throwable)e);
                }
            }
        }
        this.endRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="invoke all users listeners")
    @Impact(value=ImpactType.READ)
    public void syncAllUsers(@ManagedDescription(value="Event type: added/updated/deleted") @ManagedName(value="eventType") String eventType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("All users listeners invocation, eventType = " + eventType));
        }
        this.startRequest();
        EventType event = EventType.valueOf(eventType);
        Session session = null;
        switch (event) {
            case DELETED: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"\tSearch for deleted users and invoke related listeners.");
                }
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    List<String> activatedUsers = Util.getActivatedUsers(session);
                    ListAccess usersListAccess = this.organizationService.getUserHandler().findAllUsers();
                    for (int i = 0; i <= usersListAccess.getSize(); i += 10) {
                        User[] users;
                        int length = i + 10 <= usersListAccess.getSize() ? 10 : usersListAccess.getSize() - i;
                        for (User user : users = (User[])usersListAccess.load(i, length)) {
                            activatedUsers.remove(user.getUserName());
                        }
                    }
                    for (String username : activatedUsers) {
                        this.syncUser(username, eventType);
                    }
                    break;
                }
                catch (Exception e) {
                    LOG.error((Object)"\t\tUnknown error was occured while preparing to proceed users deletion", (Throwable)e);
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            case UPDATED: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"\tAll users update invocation: Search for already existing users in Datasource and that are already integrated.");
                }
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    List<String> activatedUsers = Util.getActivatedUsers(session);
                    for (String username : activatedUsers) {
                        this.syncUser(username, eventType);
                    }
                    break;
                }
                catch (Exception e) {
                    LOG.error((Object)"\tUnknown error was occured while preparing to proceed users update", (Throwable)e);
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            case ADDED: {
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    List<String> activatedUsers = Util.getActivatedUsers(session);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"\tAll new users intagration: Search for already existing users in Datasource but not integrated yet.");
                    }
                    ListAccess usersListAccess = this.organizationService.getUserHandler().findAllUsers();
                    for (int i = 0; i <= usersListAccess.getSize(); i += 10) {
                        User[] users;
                        int length = i + 10 <= usersListAccess.getSize() ? 10 : usersListAccess.getSize() - i;
                        for (User user : users = (User[])usersListAccess.load(i, length)) {
                            if (activatedUsers.contains(user.getUserName())) continue;
                            this.syncUser(user.getUserName(), eventType);
                        }
                    }
                    if (session == null) break;
                }
                catch (Exception e) {
                    try {
                        LOG.error((Object)"\tUnknown error was occured while preparing to proceed users update", (Throwable)e);
                        if (session == null) break;
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.logout();
                        }
                        throw throwable;
                    }
                    session.logout();
                    break;
                }
                session.logout();
                break;
            }
        }
        this.endRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="invoke a user listeners")
    @Impact(value=ImpactType.READ)
    public void syncUser(@ManagedDescription(value="User name") @ManagedName(value="username") String username, @ManagedDescription(value="Event type") @ManagedName(value="eventType") String eventType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\tUser listeners invocation, operation= " + eventType + ", for user= " + username));
        }
        EventType event = EventType.valueOf(eventType);
        this.startRequest();
        switch (event) {
            case DELETED: {
                User user = null;
                try {
                    user = this.organizationService.getUserHandler().findUserByName(username);
                }
                catch (Exception e) {
                    LOG.warn((Object)("\t\tError occured while verifying if user is present in Datasource or not. This may not cause a problem :" + e.getMessage()));
                }
                if (user != null) {
                    LOG.warn((Object)("\t\tUser exists: can't invoke delete listeners on the existant user : " + username));
                    return;
                }
                this.invokeUserMembershipsListeners(username, event);
                this.invokeUserProfileListeners(username, event);
                Session session = null;
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    if (Util.hasUserFolder(session, username)) {
                        LOG.info((Object)("Invoke user deletion: " + username));
                        user = new UserImpl(username);
                        Collection<UserEventListener> userDAOListeners = this.userDAOListeners_.values();
                        for (UserEventListener userEventListener : userDAOListeners) {
                            try {
                                userEventListener.preDelete(user);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("\t\tFailed to call preDelete on " + username + " User with listener : " + userEventListener.getClass()), (Throwable)e);
                            }
                            try {
                                this.startRequest();
                                userEventListener.postDelete(user);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("\t\tFailed to call postDelete on " + username + " User with listener : " + userEventListener.getClass()), (Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("\t\tFailed to initialize " + username + " User"), (Throwable)e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
                this.endRequest();
                break;
            }
            case UPDATED: 
            case ADDED: {
                Session session = null;
                try {
                    boolean isNew = event.equals((Object)EventType.ADDED);
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    if (!isNew || !Util.hasUserFolder(session, username)) {
                        User user = this.organizationService.getUserHandler().findUserByName(username);
                        if (user.getCreatedDate() == null) {
                            user.setCreatedDate(new Date());
                        }
                        LOG.info((Object)("Invoke " + username + " user synchronization "));
                        Collection<UserEventListener> userDAOListeners = this.userDAOListeners_.values();
                        for (UserEventListener userEventListener : userDAOListeners) {
                            try {
                                userEventListener.preSave(user, isNew);
                            }
                            catch (IllegalStateException e) {
                                this.endRequest();
                                userEventListener.preSave(user, isNew);
                                this.startRequest();
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("\t\tFailed to call preSave for " + username + " User with listener : " + userEventListener.getClass()), (Throwable)e);
                            }
                        }
                        for (UserEventListener userEventListener : userDAOListeners) {
                            try {
                                this.startRequest();
                                userEventListener.postSave(user, isNew);
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("\t\tFailed to call postSave for " + username + " User with listener : " + userEventListener.getClass()), (Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("\t\tFailed to call listeners for " + username + " User"), (Throwable)e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
                this.endRequest();
                this.invokeUserProfileListeners(username, event);
                this.invokeUserMembershipsListeners(username, event);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    @ManagedDescription(value="invoke a membership listeners")
    @Impact(value=ImpactType.READ)
    public void syncMembership(@ManagedDescription(value="User name") @ManagedName(value="username") String username, @ManagedDescription(value="group identifier") @ManagedName(value="groupId") String groupId, @ManagedDescription(value="event type") @ManagedName(value="eventType") String eventType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Memberships listeners invocation, operation= " + eventType + ", for membership=" + username + ":" + groupId));
        }
        EventType event = EventType.valueOf(eventType);
        this.startRequest();
        switch (event) {
            case DELETED: {
                Session session = null;
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    List<Membership> activatedMemberships = Util.getActivatedMembershipsRelatedToUser(session, username);
                    int i = 0;
                    while (i < activatedMemberships.size()) {
                        Membership membership = activatedMemberships.get(i);
                        if (membership.getGroupId().equals(groupId)) {
                            activatedMemberships.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    if (activatedMemberships.isEmpty()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("No integrated memberships was found for user: " + username + ", and group = " + groupId));
                        }
                        return;
                    }
                    ArrayList<Membership> memberships = null;
                    try {
                        memberships = (ArrayList<Membership>)this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(username, groupId);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("\t\tError occured while verifying if membership is present in Datasource or not. This may not cause a problem :" + e.getMessage()));
                    }
                    if (memberships == null) {
                        memberships = new ArrayList<Membership>();
                    }
                    for (Membership membership : activatedMemberships) {
                        if (this.contains(membership, memberships)) continue;
                        this.invokeMembershipListeners(username, groupId, membership.getMembershipType(), event);
                    }
                    break;
                }
                catch (Exception e) {
                    LOG.error((Object)"\t\tUnknown error was occured while preparing to proceed membership deletion", (Throwable)e);
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            case UPDATED: 
            case ADDED: {
                boolean isNew = EventType.ADDED.equals((Object)event);
                Session session = null;
                try {
                    List memberships = null;
                    try {
                        memberships = (List)this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(username, groupId);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("\t\tError occured while verifying if membership is present in Datasource or not. This may not cause a problem :" + e.getMessage()));
                    }
                    if (memberships == null || memberships.isEmpty()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("No integrated memberships was found for user: " + username + ", and group = " + groupId));
                        }
                        return;
                    }
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    List<Membership> activatedMemberships = Util.getActivatedMembershipsRelatedToUser(session, username);
                    int i = 0;
                    while (i < activatedMemberships.size()) {
                        Membership membership = activatedMemberships.get(i);
                        if (membership.getGroupId().equals(groupId)) {
                            activatedMemberships.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    if (!isNew && activatedMemberships.isEmpty()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("No integrated memberships was found for user: " + username + ", abd group = " + groupId));
                        }
                        return;
                    }
                    for (Membership membership : memberships) {
                        if (isNew) {
                            if (this.contains(membership, activatedMemberships)) continue;
                            this.invokeMembershipListeners(username, groupId, membership.getMembershipType(), event);
                            continue;
                        }
                        if (!this.contains(membership, activatedMemberships)) continue;
                        this.invokeMembershipListeners(username, groupId, membership.getMembershipType(), event);
                    }
                    break;
                }
                catch (Exception e) {
                    LOG.error((Object)"\t\tUnknown error was occured while preparing to proceed membership deletion", (Throwable)e);
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
        }
        this.endRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMembershipListeners(String username, String groupId, String membershipType, EventType eventType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\tMembership listeners invocation, operation= " + (Object)((Object)eventType) + ", for membership= " + membershipType + ":" + username + ":" + groupId));
        }
        this.startRequest();
        switch (eventType) {
            case DELETED: {
                try {
                    Membership membership = null;
                    try {
                        membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(username, groupId, membershipType);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("\t\tError occured while verifying if membership is present in Datasource or not. This may not cause a problem :" + e.getMessage()));
                    }
                    if (membership != null) {
                        LOG.warn((Object)("\t\tMembership exists: can't invoke delete listeners on the existant membership : " + membership.getId()));
                        return;
                    }
                    membership = new MembershipImpl();
                    ((MembershipImpl)membership).setGroupId(groupId);
                    ((MembershipImpl)membership).setUserName(username);
                    ((MembershipImpl)membership).setMembershipType(membershipType);
                    ((MembershipImpl)membership).setId(Util.computeId(membership));
                    try {
                        LOG.info((Object)("Invoke " + membership.getId() + " Membership deletion listeners."));
                        Collection<MembershipEventListener> membershipDAOListeners = this.membershipDAOListeners_.values();
                        for (MembershipEventListener membershipEventListener : membershipDAOListeners) {
                            try {
                                membershipEventListener.preDelete(membership);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("\t\tFailed to call preDelete on " + username + " Membership (" + membership.getId() + ") listener = " + membershipEventListener.getClass()), (Throwable)e);
                            }
                            try {
                                membershipEventListener.postDelete(membership);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("\t\tFailed to call postDelete on " + username + " Membership (" + membership.getId() + ") listener = " + membershipEventListener.getClass()), (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("\t\tFailed to call listeners on Membership (" + membership.getId() + ")"), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"\t\tUnknown error was occured while preparing to proceed membership deletion", (Throwable)e);
                }
                break;
            }
            case UPDATED: 
            case ADDED: {
                boolean isNew = EventType.ADDED.equals((Object)eventType);
                Session session = null;
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    Membership membership = this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(username, groupId, membershipType);
                    try {
                        if (!Util.hasGroupFolder(session, groupId)) {
                            this.syncGroup(groupId, EventType.ADDED.toString());
                        }
                        if (!Util.hasUserFolder(session, username)) {
                            this.syncUser(username, EventType.ADDED.toString());
                        }
                        if (membership == null || isNew && Util.hasMembershipFolder(session, membership)) break;
                        LOG.info((Object)("Invoke " + membership.getId() + " Membership synchronization."));
                        Collection<MembershipEventListener> membershipDAOListeners = this.membershipDAOListeners_.values();
                        for (MembershipEventListener membershipEventListener : membershipDAOListeners) {
                            try {
                                membershipEventListener.preSave(membership, isNew);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("\t\tFailed to call preSave on Membership (" + membership.getId() + ",isNew = " + isNew + ") listener = " + membershipEventListener.getClass()), (Throwable)e);
                            }
                            try {
                                membershipEventListener.postSave(membership, isNew);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("\t\tFailed to call postSave on Membership (" + membership.getId() + ") listener = " + membershipEventListener.getClass()), (Throwable)e);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("\t\tFailed to call listeners on Membership (" + membership.getId() + ")"), (Throwable)e);
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("\t\tFailed to call listeners on " + username + " Memberships listeners"), (Throwable)e);
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
        }
        this.endRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeDeleteGroupListeners(String groupId) {
        try {
            Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
            if (group != null) {
                LOG.warn((Object)("\t\tGroup exists: can't invoke delete listeners on the existant group : " + groupId));
                return;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("\t\tException while trying to get a group instance with id : " + groupId + ", it may has been already synchronized:" + exception.getMessage()));
        }
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (!Util.hasGroupFolder(session, groupId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"\t\tGroup doesn't exist or has been already deleted.");
                }
                return;
            }
            List<Membership> memberships = Util.getActivatedMembershipsRelatedToGroup(session, groupId);
            for (Membership membership : memberships) {
                Membership tmpMembership = this.organizationService.getMembershipHandler().removeMembership(membership.getId(), true);
                if (tmpMembership != null) continue;
                this.invokeMembershipListeners(membership.getUserName(), membership.getGroupId(), membership.getMembershipType(), EventType.DELETED);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("\t\tCouldn't process deletion of Memberships related to the group : " + groupId), (Throwable)exception);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        GroupImpl group = new GroupImpl(groupId);
        group.setId(groupId);
        Collection<GroupEventListener> groupDAOListeners = this.groupDAOListeners_.values();
        LOG.info((Object)("Invoke " + groupId + " Group deletion listeners."));
        for (GroupEventListener groupEventListener : groupDAOListeners) {
            try {
                groupEventListener.preDelete((Group)group);
            }
            catch (Exception e) {
                LOG.warn((Object)("\t\tFailed to call preDelete on " + group.getId() + " Group, listener = " + groupEventListener.getClass()), (Throwable)e);
            }
            try {
                groupEventListener.postDelete((Group)group);
            }
            catch (Exception e) {
                LOG.warn((Object)("\t\tFailed to call postDelete on " + group.getId() + " Group, listener = " + groupEventListener.getClass()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeUserMembershipsListeners(String username, EventType eventType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\t\tMemberships listeners invocation, operation= " + (Object)((Object)eventType) + ", for user= " + username));
        }
        this.startRequest();
        switch (eventType) {
            case DELETED: {
                Session session = null;
                try {
                    Collection userMemberships = null;
                    try {
                        userMemberships = this.organizationService.getMembershipHandler().removeMembershipByUser(username, true);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)("\t\t\tCouldn't process deletion of Memberships related to the user : " + username), (Throwable)exception);
                    }
                    if (userMemberships == null || userMemberships.isEmpty()) {
                        session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                        List<Membership> memberships = Util.getActivatedMembershipsRelatedToUser(session, username);
                        for (Membership membership : memberships) {
                            this.invokeMembershipListeners(username, membership.getGroupId(), membership.getMembershipType(), eventType);
                        }
                        break;
                    }
                    LOG.error((Object)("\t\t\tUser " + username + " was deleted, but some memberships are always existing : " + userMemberships));
                    break;
                }
                catch (Exception e) {
                    LOG.error((Object)"\t\t\tUnknown error was occured while preparing to proceed membership deletion", (Throwable)e);
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            case UPDATED: 
            case ADDED: {
                boolean isNew = EventType.ADDED.equals((Object)eventType);
                Session session = null;
                Collection memberships = null;
                List<Membership> activatedMemberships = null;
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    memberships = this.organizationService.getMembershipHandler().findMembershipsByUser(username);
                    activatedMemberships = Util.getActivatedMembershipsRelatedToUser(session, username);
                }
                catch (Exception e) {
                    LOG.error((Object)("\t\t\tFailed to call Membership listeners for user : " + username), (Throwable)e);
                    throw new IllegalStateException(e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
                for (Object membershipObject : memberships) {
                    Membership membership = (Membership)membershipObject;
                    boolean isAlreadyIntegrated = this.contains(membership, activatedMemberships);
                    if (isNew) {
                        if (!isAlreadyIntegrated) {
                            this.invokeMembershipListeners(username, membership.getGroupId(), membership.getMembershipType(), eventType);
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("\t\t\t" + membership.getId() + " Membership is already integrated"));
                        continue;
                    }
                    if (isAlreadyIntegrated) {
                        this.invokeMembershipListeners(username, membership.getGroupId(), membership.getMembershipType(), eventType);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("\t\t\t" + membership.getId() + " Membership is not yet added, add invoke listeners with parameter isNew=true"));
                    }
                    this.invokeMembershipListeners(username, membership.getGroupId(), membership.getMembershipType(), EventType.ADDED);
                }
                break;
            }
        }
        this.endRequest();
    }

    private boolean contains(Membership membership, List<Membership> activatedMemberships) {
        if (membership == null || activatedMemberships == null || activatedMemberships.size() == 0) {
            return false;
        }
        for (Membership tmpMembership : activatedMemberships) {
            if (!tmpMembership.getId().equals(membership.getId())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeUserProfileListeners(String username, EventType eventType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("\t\tProfile listeners invocation, operation= " + (Object)((Object)eventType) + ", for user= " + username));
        }
        this.startRequest();
        switch (eventType) {
            case UPDATED: 
            case ADDED: {
                Session session = null;
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    boolean isNew = EventType.ADDED.equals((Object)eventType);
                    UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(username);
                    if (userProfile == null) {
                        userProfile = this.organizationService.getUserProfileHandler().createUserProfileInstance(username);
                        this.organizationService.getUserProfileHandler().saveUserProfile(userProfile, isNew);
                        userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(username);
                    }
                    if (isNew && Util.hasProfileFolder(session, username)) break;
                    LOG.info((Object)("Invoke " + username + " user profile synchronization."));
                    Collection<UserProfileEventListener> userProfileListeners = this.userProfileListeners_.values();
                    for (UserProfileEventListener userProfileEventListener : userProfileListeners) {
                        if (userProfile.getUserInfoMap() == null) {
                            userProfile.setUserInfoMap(new HashMap());
                        }
                        try {
                            userProfileEventListener.preSave(userProfile, isNew);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("\t\t\tFailed to call preSave on " + username + " User profile with listener : " + userProfileEventListener.getClass()), (Throwable)e);
                        }
                        try {
                            userProfileEventListener.postSave(userProfile, isNew);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("\t\t\tFailed to call postSave on " + username + " User profile with listener : " + userProfileEventListener.getClass()), (Throwable)e);
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    LOG.warn((Object)("\t\t\tFailed to call listeners on " + username + " User profile"), (Throwable)e);
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            case DELETED: {
                Session session = null;
                try {
                    session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                    UserProfile userProfile = null;
                    try {
                        userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(username);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("\t\t\tError occured while verifying if userProfile is present in Datasource or not. This may not cause a problem :" + e.getMessage()));
                    }
                    if (userProfile != null) {
                        this.organizationService.getUserProfileHandler().removeUserProfile(username, true);
                        break;
                    }
                    if (!Util.hasProfileFolder(session, username)) break;
                    LOG.info((Object)("Invoke " + username + " user profile deletion listeners."));
                    userProfile = new UserProfileImpl(username);
                    userProfile.setUserInfoMap(new HashMap());
                    Collection<UserProfileEventListener> userProfileListeners = this.userProfileListeners_.values();
                    for (UserProfileEventListener userProfileEventListener : userProfileListeners) {
                        try {
                            userProfileEventListener.preDelete(userProfile);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("\t\t\tFailed to call preSave on " + username + " User profile with listener : " + userProfileEventListener.getClass()), (Throwable)e);
                        }
                        try {
                            userProfileEventListener.postDelete(userProfile);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("\t\t\tFailed to call postSave on " + username + " User profile with listener : " + userProfileEventListener.getClass()), (Throwable)e);
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    LOG.warn((Object)("\t\t\tFailed to call listeners on " + username + " User profile"), (Throwable)e);
                    break;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
        }
        this.endRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeListenersToSavedGroup(Group group, boolean isNew) {
        block14: {
            Session session = null;
            try {
                session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
                if (group.getParentId() != null && !group.getParentId().isEmpty()) {
                    try {
                        Group parentGroup = this.organizationService.getGroupHandler().findGroupById(group.getParentId());
                        this.invokeListenersToSavedGroup(parentGroup, isNew);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("\t\tError occured while attempting to get parent of " + group.getId() + " Group. Listeners will not be applied on parent " + group.getParentId()), (Throwable)e);
                    }
                }
                if (isNew && Util.hasGroupFolder(session, group.getId())) break block14;
                LOG.info((Object)("Invoke " + group.getId() + " Group deletion listeners."));
                Collection<GroupEventListener> groupDAOListeners = this.groupDAOListeners_.values();
                for (GroupEventListener groupEventListener : groupDAOListeners) {
                    try {
                        groupEventListener.preSave(group, isNew);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("\t\t\tFailed to call preSave on " + group.getId() + " Group, listener = " + groupEventListener.getClass()), (Throwable)e);
                    }
                    try {
                        groupEventListener.postSave(group, isNew);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("\t\t\tFailed to call postSave on " + group.getId() + " Group, listener = " + groupEventListener.getClass()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("\t\t\tFailed to call listeners for " + group.getId() + " Group."), (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    private void endRequest() {
        if (this.requestStarted && this.organizationService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle)this.organizationService).endRequest((ExoContainer)this.container);
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            this.requestStarted = false;
        }
    }

    private void startRequest() {
        if (this.organizationService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)this.container);
            this.requestStarted = true;
        }
    }
}

