/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import java.awt.image.BufferedImage;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.thumbnail.ThumbnailPlugin;
import org.exoplatform.services.cms.thumbnail.impl.ThumbnailType;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.pdfviewer.PDFViewerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.icepdf.core.pobjects.Document;

public class OfficeDocumentThumbnailPlugin
implements ComponentPlugin,
ThumbnailPlugin {
    private ThumbnailType config;
    private String description;
    private String name;
    private static final Log LOG = ExoLogger.getExoLogger((String)OfficeDocumentThumbnailPlugin.class.getName());

    public OfficeDocumentThumbnailPlugin(InitParams initParams) throws Exception {
        this.config = (ThumbnailType)initParams.getObjectParamValues(ThumbnailType.class).get(0);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public BufferedImage getBufferedImage(Node contentNode, String nodePath) throws Exception {
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        String repository = repositoryService.getCurrentRepository().getConfiguration().getName();
        Document pdfDocument = new Document();
        if (contentNode.isNodeType("nt:resource")) {
            contentNode = contentNode.getParent();
        }
        PDFViewerService pdfViewerService = WCMCoreUtils.getService(PDFViewerService.class);
        pdfDocument = pdfViewerService.initDocument(contentNode, repository);
        BufferedImage image = (BufferedImage)pdfDocument.getPageImage(0, 1, 2, 0.0f, 1.0f);
        pdfDocument.dispose();
        return image;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.config.getMimeTypes();
    }
}

