/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipJarUtil {
    public static InputStream getInputStreamForURL(URL url) throws IOException {
        JarURLConnection conn = (JarURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    public static Collection getEntries(String fileName) throws ZipException, IOException {
        return ZipJarUtil.getEntries(new ZipFile(fileName));
    }

    public static Collection getEntries(File file) throws ZipException, IOException {
        return ZipJarUtil.getEntries(new ZipFile(file));
    }

    public static Collection getEntries(URL url) throws ZipException, IOException {
        JarURLConnection conn = (JarURLConnection)url.openConnection();
        return ZipJarUtil.getEntries(conn.getJarFile());
    }

    public static Collection getEntries(ZipFile zipFile) throws ZipException, IOException {
        ArrayList<String> entries = new ArrayList<String>();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            if (ze.isDirectory()) continue;
            entries.add(ze.getName());
        }
        return entries;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(ZipJarUtil.getEntries("src/test/resources/a.zip"));
        System.out.println(ZipJarUtil.getEntries(new File("src/test/resources/a.zip")));
        System.out.println(ZipJarUtil.getEntries(new URL("jar:file:src/test/resources/a.zip!/")));
        System.out.println(ZipJarUtil.getEntries(new URL("jar:file:src/test/resources/a.zip!/resources/eu/medsea/mimeutil/magic.mime")));
    }
}

