/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import java.util.List;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;

public class SpaceFilter {
    private char firstCharacterOfSpaceName;
    private String spaceNameSearchCondition;
    private List<Space> includeSpaces;
    private String remoteId;
    private String appId;
    private static char CHAR_DEFAULT_VALUE = '\u0000';
    private Sorting sorting;

    public SpaceFilter() {
        this.firstCharacterOfSpaceName = CHAR_DEFAULT_VALUE;
        this.spaceNameSearchCondition = null;
    }

    public SpaceFilter(char firstCharacterOfSpaceName) {
        this.firstCharacterOfSpaceName = firstCharacterOfSpaceName;
        this.spaceNameSearchCondition = null;
    }

    public SpaceFilter(String spaceNameSearchCondition) {
        this.firstCharacterOfSpaceName = CHAR_DEFAULT_VALUE;
        this.spaceNameSearchCondition = SpaceUtils.removeSpecialCharacterInSpaceFilter(spaceNameSearchCondition);
    }

    public SpaceFilter(char firstCharacterOfSpaceName, String spaceNameSearchCondition) {
        this.firstCharacterOfSpaceName = firstCharacterOfSpaceName;
        this.spaceNameSearchCondition = SpaceUtils.removeSpecialCharacterInSpaceFilter(spaceNameSearchCondition);
    }

    public SpaceFilter(String remoteId, String appId) {
        this.appId = appId;
        this.remoteId = remoteId;
    }

    public List<Space> getIncludeSpaces() {
        return this.includeSpaces;
    }

    public void setIncludeSpaces(List<Space> includeSpaces) {
        this.includeSpaces = includeSpaces;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public char getFirstCharacterOfSpaceName() {
        return this.firstCharacterOfSpaceName;
    }

    public void setFirstCharacterOfSpaceName(char firstCharacterOfSpaceName) {
        this.firstCharacterOfSpaceName = firstCharacterOfSpaceName;
    }

    public String getSpaceNameSearchCondition() {
        return this.spaceNameSearchCondition;
    }

    public void setSpaceNameSearchCondition(String spaceNameSearchCondition) {
        this.spaceNameSearchCondition = SpaceUtils.removeSpecialCharacterInSpaceFilter(spaceNameSearchCondition);
    }

    public Sorting getSorting() {
        if (this.sorting == null) {
            this.sorting = new Sorting(Sorting.SortBy.TITLE, Sorting.OrderBy.ASC);
            return this.sorting;
        }
        return this.sorting;
    }

    public void setSorting(Sorting sorting) {
        this.sorting = sorting;
    }
}

