/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.CacheType;
import org.exoplatform.social.core.storage.cache.FutureExoCache;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.storage.cache.loader.ServiceContext;
import org.exoplatform.social.core.storage.cache.model.data.IdentityData;
import org.exoplatform.social.core.storage.cache.model.data.IntegerData;
import org.exoplatform.social.core.storage.cache.model.data.ListIdentitiesData;
import org.exoplatform.social.core.storage.cache.model.data.ProfileData;
import org.exoplatform.social.core.storage.cache.model.key.IdentityCompositeKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.ListIdentitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ListSpaceMembersKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceKey;
import org.exoplatform.social.core.storage.cache.selector.IdentityCacheSelector;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;

public class CachedIdentityStorage
implements IdentityStorage {
    private static final Log LOG = ExoLogger.getLogger(CachedIdentityStorage.class);
    private final ExoCache<IdentityKey, IdentityData> exoIdentityCache;
    private final ExoCache<IdentityCompositeKey, IdentityKey> exoIdentityIndexCache;
    private final ExoCache<IdentityKey, ProfileData> exoProfileCache;
    private final ExoCache<IdentityFilterKey, IntegerData> exoIdentitiesCountCache;
    private final ExoCache<ListIdentitiesKey, ListIdentitiesData> exoIdentitiesCache;
    private final FutureExoCache<IdentityKey, IdentityData, ServiceContext<IdentityData>> identityCache;
    private final FutureExoCache<IdentityCompositeKey, IdentityKey, ServiceContext<IdentityKey>> identityIndexCache;
    private final FutureExoCache<IdentityKey, ProfileData, ServiceContext<ProfileData>> profileCache;
    private final FutureExoCache<IdentityFilterKey, IntegerData, ServiceContext<IntegerData>> identitiesCountCache;
    private final FutureExoCache<ListIdentitiesKey, ListIdentitiesData, ServiceContext<ListIdentitiesData>> identitiesCache;
    private final IdentityStorageImpl storage;

    void clearCache() {
        try {
            this.exoIdentitiesCache.select((CachedObjectSelector)new IdentityCacheSelector("organization"));
            this.exoIdentitiesCountCache.select((CachedObjectSelector)new IdentityCacheSelector("organization"));
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    private List<Identity> buildIdentities(ListIdentitiesData data) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        for (IdentityKey k : data.getIds()) {
            Identity gotIdentity = this.findIdentityById(k.getId());
            gotIdentity.setProfile(this.loadProfile(gotIdentity.getProfile()));
            identities.add(gotIdentity);
        }
        return identities;
    }

    private ListIdentitiesData buildIds(List<Identity> identities) {
        ArrayList<IdentityKey> data = new ArrayList<IdentityKey>();
        for (Identity i : identities) {
            IdentityKey k = new IdentityKey(i);
            this.exoIdentityCache.put((Serializable)k, (Object)new IdentityData(i));
            this.exoProfileCache.put((Serializable)k, (Object)new ProfileData(i.getProfile()));
            data.add(new IdentityKey(i));
        }
        return new ListIdentitiesData((List<IdentityKey>)data);
    }

    public CachedIdentityStorage(IdentityStorageImpl storage, SocialStorageCacheService cacheService) {
        this.storage = storage;
        this.storage.setStorage(this);
        this.exoIdentityCache = cacheService.getIdentityCache();
        this.exoIdentityIndexCache = cacheService.getIdentityIndexCache();
        this.exoProfileCache = cacheService.getProfileCache();
        this.exoIdentitiesCountCache = cacheService.getCountIdentitiesCache();
        this.exoIdentitiesCache = cacheService.getIdentitiesCache();
        this.identityCache = CacheType.IDENTITY.createFutureCache(this.exoIdentityCache);
        this.identityIndexCache = CacheType.IDENTITY_INDEX.createFutureCache(this.exoIdentityIndexCache);
        this.profileCache = CacheType.PROFILE.createFutureCache(this.exoProfileCache);
        this.identitiesCountCache = CacheType.IDENTITIES_COUNT.createFutureCache(this.exoIdentitiesCountCache);
        this.identitiesCache = CacheType.IDENTITIES.createFutureCache(this.exoIdentitiesCache);
    }

    @Override
    public void saveIdentity(Identity identity) throws IdentityStorageException {
        this.storage.saveIdentity(identity);
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        this.exoIdentityCache.put((Serializable)key, (Object)new IdentityData(identity));
        this.clearCache();
    }

    @Override
    public Identity updateIdentity(Identity identity) throws IdentityStorageException {
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        this.exoIdentityCache.remove((Serializable)key);
        this.clearCache();
        return this.storage.updateIdentity(identity);
    }

    @Override
    public void updateIdentityMembership(String remoteId) throws IdentityStorageException {
        this.clearCache();
    }

    @Override
    public Identity findIdentityById(final String nodeId) throws IdentityStorageException {
        IdentityKey key = new IdentityKey(new Identity(nodeId));
        Identity i = ((IdentityData)this.identityCache.get(new ServiceContext<IdentityData>(){

            @Override
            public IdentityData execute() {
                return new IdentityData(CachedIdentityStorage.this.storage.findIdentityById(nodeId));
            }
        }, key)).build();
        if (i != null) {
            i.setProfile(this.loadProfile(i.getProfile()));
        }
        return i;
    }

    @Override
    public void deleteIdentity(Identity identity) throws IdentityStorageException {
        this.storage.deleteIdentity(identity);
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        IdentityData data = (IdentityData)this.exoIdentityCache.remove((Serializable)key);
        if (data != null) {
            this.exoIdentityIndexCache.remove((Serializable)new IdentityCompositeKey(data.getProviderId(), data.getRemoteId()));
        }
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
    }

    @Override
    public void hardDeleteIdentity(Identity identity) throws IdentityStorageException {
        this.storage.hardDeleteIdentity(identity);
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        IdentityData data = (IdentityData)this.exoIdentityCache.remove((Serializable)key);
        if (data != null) {
            this.exoIdentityIndexCache.remove((Serializable)new IdentityCompositeKey(data.getProviderId(), data.getRemoteId()));
        }
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
    }

    @Override
    public Profile loadProfile(final Profile profile) throws IdentityStorageException {
        IdentityKey key = new IdentityKey(new Identity(profile.getIdentity().getId()));
        return ((ProfileData)this.profileCache.get(new ServiceContext<ProfileData>(){

            @Override
            public ProfileData execute() {
                return new ProfileData(CachedIdentityStorage.this.storage.loadProfile(profile));
            }
        }, key)).build();
    }

    public void clearIdentityCached(Identity identity, String oldRemoteId) {
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        IdentityData data = (IdentityData)this.exoIdentityCache.remove((Serializable)key);
        if (data != null) {
            this.exoIdentityIndexCache.remove((Serializable)new IdentityCompositeKey(data.getProviderId(), oldRemoteId));
        }
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
    }

    @Override
    public Identity findIdentity(final String providerId, final String remoteId) throws IdentityStorageException {
        IdentityCompositeKey key = new IdentityCompositeKey(providerId, remoteId);
        IdentityKey k = (IdentityKey)this.identityIndexCache.get(new ServiceContext<IdentityKey>(){

            @Override
            public IdentityKey execute() {
                Identity i = CachedIdentityStorage.this.storage.findIdentity(providerId, remoteId);
                if (i == null) {
                    return null;
                }
                IdentityKey key = new IdentityKey(i);
                CachedIdentityStorage.this.exoIdentityCache.put((Serializable)key, (Object)new IdentityData(i));
                return key;
            }
        }, key);
        if (k != null) {
            return this.findIdentityById(k.getId());
        }
        return null;
    }

    @Override
    public void saveProfile(Profile profile) throws IdentityStorageException {
        this.storage.saveProfile(profile);
        IdentityKey key = new IdentityKey(new Identity(profile.getIdentity().getId()));
        this.exoProfileCache.remove((Serializable)key);
    }

    @Override
    public void updateProfile(Profile profile) throws IdentityStorageException {
        this.storage.updateProfile(profile);
        IdentityKey key = new IdentityKey(new Identity(profile.getIdentity().getId()));
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
    }

    @Override
    public int getIdentitiesCount(String providerId) throws IdentityStorageException {
        return this.storage.getIdentitiesCount(providerId);
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(final String providerId, final ProfileFilter profileFilter, final long offset, final long limit, final boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        ListIdentitiesKey listKey = new ListIdentitiesKey(key, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List<Identity> got = CachedIdentityStorage.this.storage.getIdentitiesByProfileFilter(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
                return CachedIdentityStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildIdentities(keys);
    }

    @Override
    public List<Identity> getIdentitiesForMentions(final String providerId, final ProfileFilter profileFilter, final long offset, final long limit, final boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        ListIdentitiesKey listKey = new ListIdentitiesKey(key, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List<Identity> got = CachedIdentityStorage.this.storage.getIdentitiesForMentions(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
                return CachedIdentityStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildIdentities(keys);
    }

    @Override
    public int getIdentitiesByProfileFilterCount(final String providerId, final ProfileFilter profileFilter) throws IdentityStorageException {
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        return (Integer)((IntegerData)this.identitiesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedIdentityStorage.this.storage.getIdentitiesByProfileFilterCount(providerId, profileFilter));
            }
        }, key)).build();
    }

    @Override
    public int getIdentitiesByFirstCharacterOfNameCount(final String providerId, final ProfileFilter profileFilter) throws IdentityStorageException {
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        return (Integer)((IntegerData)this.identitiesCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedIdentityStorage.this.storage.getIdentitiesByFirstCharacterOfNameCount(providerId, profileFilter));
            }
        }, key)).build();
    }

    @Override
    public List<Identity> getIdentitiesByFirstCharacterOfName(final String providerId, final ProfileFilter profileFilter, final long offset, final long limit, final boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        ListIdentitiesKey listKey = new ListIdentitiesKey(key, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List<Identity> got = CachedIdentityStorage.this.storage.getIdentitiesByFirstCharacterOfName(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
                return CachedIdentityStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildIdentities(keys);
    }

    @Override
    public String getType(String nodetype, String property) {
        return this.storage.getType(nodetype, property);
    }

    @Override
    public void addOrModifyProfileProperties(Profile profile) throws IdentityStorageException {
        this.storage.addOrModifyProfileProperties(profile);
    }

    @Override
    public List<Identity> getSpaceMemberIdentitiesByProfileFilter(final Space space, final ProfileFilter profileFilter, final SpaceMemberFilterListAccess.Type type, final long offset, final long limit) throws IdentityStorageException {
        SpaceKey spaceKey = new SpaceKey(space.getId());
        IdentityFilterKey identityKey = new IdentityFilterKey("space", profileFilter);
        ListSpaceMembersKey listKey = new ListSpaceMembersKey(spaceKey, identityKey, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List<Identity> got = CachedIdentityStorage.this.storage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, type, offset, limit);
                return CachedIdentityStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildIdentities(keys);
    }

    @Override
    public void updateProfileActivityId(Identity identity, String activityId, Profile.AttachedActivityType type) {
        this.storage.updateProfileActivityId(identity, activityId, type);
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        this.exoProfileCache.remove((Serializable)key);
        this.clearCache();
    }

    @Override
    public String getProfileActivityId(Profile profile, Profile.AttachedActivityType type) {
        return this.storage.getProfileActivityId(profile, type);
    }
}

